/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskindex;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.rdfhdt.hdt.iterator.utils.AsyncIteratorFetcher;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.SizeFetcher;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.ParallelSortableArrayList;
import org.rdfhdt.hdt.util.concurrent.KWayMerger;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.Pair;
import org.rdfhdt.hdt.util.io.compress.PairMergeIterator;
import org.rdfhdt.hdt.util.io.compress.PairReader;
import org.rdfhdt.hdt.util.io.compress.PairWriter;
import org.rdfhdt.hdt.util.listener.IntermediateListener;

public class DiskIndexSort
implements KWayMerger.KWayMergerImpl<Pair, SizeFetcher<Pair>> {
    private final CloseSuppressPath baseFileName;
    private final AsyncIteratorFetcher<Pair> source;
    private final MultiThreadListener listener;
    private final int bufferSize;
    private final long chunkSize;
    private final int k;
    private final Comparator<Pair> comparator;
    private final AtomicLong read = new AtomicLong();

    public DiskIndexSort(CloseSuppressPath baseFileName, AsyncIteratorFetcher<Pair> source, MultiThreadListener listener, int bufferSize, long chunkSize, int k, Comparator<Pair> comparator) {
        this.source = source;
        this.listener = MultiThreadListener.ofNullable((MultiThreadListener)listener);
        this.baseFileName = baseFileName;
        this.bufferSize = bufferSize;
        this.chunkSize = chunkSize;
        this.k = k;
        this.comparator = comparator;
    }

    @Override
    public void createChunk(SizeFetcher<Pair> flux, CloseSuppressPath output) throws KWayMerger.KWayMergerException {
        Pair pair;
        ParallelSortableArrayList<Pair> pairs = new ParallelSortableArrayList<Pair>(Pair[].class);
        this.listener.notifyProgress(10.0f, "reading pairs part 0");
        while ((pair = flux.get()) != null) {
            pairs.add(pair);
            long r = this.read.incrementAndGet();
            if (r % 1000000L != 0L) continue;
            this.listener.notifyProgress(10.0f, "reading pairs part " + r);
        }
        pairs.parallelSort(this.comparator);
        int count = 0;
        int block = pairs.size() < 10 ? 1 : pairs.size() / 10;
        IntermediateListener il = new IntermediateListener((ProgressListener)this.listener);
        il.setRange(70.0f, 100.0f);
        il.notifyProgress(0.0f, "creating file");
        try (PairWriter w = new PairWriter(output.openOutputStream(this.bufferSize, new OpenOption[0]), pairs.size());){
            for (int i = 0; i < pairs.size(); ++i) {
                if (i % block == 0) {
                    il.notifyProgress((float)i / ((float)block / 10.0f), "writing pair " + count + "/" + pairs.size());
                }
                w.append((Pair)pairs.get(i));
            }
            this.listener.notifyProgress(100.0f, "writing completed " + pairs.size() + " " + output.getFileName());
        }
        catch (IOException e) {
            throw new KWayMerger.KWayMergerException("Can't write chunk", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeChunks(List<CloseSuppressPath> inputs, CloseSuppressPath output) throws KWayMerger.KWayMergerException {
        try {
            this.listener.notifyProgress(0.0f, "merging pairs " + output.getFileName());
            Closeable[] readers = new PairReader[inputs.size()];
            long count = 0L;
            try {
                for (int i = 0; i < inputs.size(); ++i) {
                    readers[i] = new PairReader(inputs.get(i).openInputStream(this.bufferSize, new OpenOption[0]));
                }
                ExceptionIterator it = PairMergeIterator.buildOfTree((ExceptionIterator[])readers, this.comparator);
                long rSize = it.getSize();
                long size = Math.max(rSize, 1L);
                long block = size < 10L ? 1L : size / 10L;
                try (PairWriter w = new PairWriter(output.openOutputStream(this.bufferSize, new OpenOption[0]), rSize);){
                    while (it.hasNext()) {
                        w.append((Pair)it.next());
                        if (count % block == 0L) {
                            this.listener.notifyProgress((float)count / ((float)block / 10.0f), "merging pairs " + count + "/" + size);
                        }
                        ++count;
                    }
                }
            }
            finally {
                IOUtil.closeAll(readers);
            }
            this.listener.notifyProgress(100.0f, "pairs merged " + output.getFileName() + " " + count);
            IOUtil.closeAll(inputs);
        }
        catch (IOException e) {
            throw new KWayMerger.KWayMergerException(e);
        }
    }

    @Override
    public SizeFetcher<Pair> newStopFlux(Supplier<Pair> flux) {
        return SizeFetcher.of(flux, p -> 24L, this.chunkSize);
    }

    public ExceptionIterator<Pair, IOException> sort(int workers) throws InterruptedException, IOException, KWayMerger.KWayMergerException {
        this.listener.notifyProgress(0.0f, "Pair sort asked in " + this.baseFileName.toAbsolutePath());
        KWayMerger<Pair, SizeFetcher<Pair>> merger = new KWayMerger<Pair, SizeFetcher<Pair>>(this.baseFileName, this.source, this, Math.max(1, workers - 1), this.k);
        merger.start();
        Optional<CloseSuppressPath> sections = merger.waitResult();
        if (sections.isEmpty()) {
            return ExceptionIterator.empty();
        }
        final CloseSuppressPath path = sections.get();
        return new PairReader(path.openInputStream(this.bufferSize, new OpenOption[0])){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    IOUtil.closeObject(path);
                }
            }
        };
    }
}

