/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResult;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.impl.OneReadTempTriples;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.CompressTripleMergeIterator;
import org.rdfhdt.hdt.util.io.compress.CompressTripleReader;

public class TripleCompressionResultPartial
implements TripleCompressionResult {
    private final List<CompressTripleReader> files;
    private final TempTriples triples;
    private final long tripleCount;
    private final TripleComponentOrder order;

    public TripleCompressionResultPartial(List<CloseSuppressPath> files, long tripleCount, TripleComponentOrder order, int bufferSize) throws IOException {
        this.files = new ArrayList<CompressTripleReader>(files.size());
        this.tripleCount = tripleCount;
        this.order = order;
        this.triples = new OneReadTempTriples(this.createBTree(files, 0, files.size(), bufferSize).asIterator(), order, tripleCount);
    }

    private ExceptionIterator<TripleID, IOException> createBTree(List<CloseSuppressPath> files, int start, int end, int bufferSize) throws IOException {
        int size = end - start;
        if (size <= 0) {
            return ExceptionIterator.empty();
        }
        if (size == 1) {
            CompressTripleReader r = new CompressTripleReader(files.get(start).openInputStream(bufferSize, new OpenOption[0]));
            this.files.add(r);
            return r;
        }
        int mid = (start + end) / 2;
        ExceptionIterator<TripleID, IOException> left = this.createBTree(files, start, mid, bufferSize);
        ExceptionIterator<TripleID, IOException> right = this.createBTree(files, mid, end, bufferSize);
        return new CompressTripleMergeIterator(left, right, this.order);
    }

    @Override
    public TempTriples getTriples() {
        return this.triples;
    }

    @Override
    public long getTripleCount() {
        return this.tripleCount;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAll(this.files);
    }
}

