/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.IOException;
import java.nio.file.OpenOption;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResult;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.impl.OneReadTempTriples;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.CompressTripleReader;

public class TripleCompressionResultFile
implements TripleCompressionResult {
    private final long tripleCount;
    private final CompressTripleReader reader;
    private final TripleComponentOrder order;
    private final CloseSuppressPath triples;

    public TripleCompressionResultFile(long tripleCount, CloseSuppressPath triples, TripleComponentOrder order, int bufferSize) throws IOException {
        this.tripleCount = tripleCount;
        this.reader = new CompressTripleReader(triples.openInputStream(bufferSize, new OpenOption[0]));
        this.order = order;
        this.triples = triples;
    }

    @Override
    public TempTriples getTriples() {
        return new OneReadTempTriples(this.reader.asIterator(), this.order, this.tripleCount);
    }

    @Override
    public long getTripleCount() {
        return this.tripleCount;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAll(this.reader, this.triples);
    }
}

