/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;

public class MapOnCallHDT
implements HDT {
    private final Path hdtFile;
    private HDT hdt;

    public MapOnCallHDT(Path hdtFile) {
        this.hdtFile = CloseSuppressPath.unpack(hdtFile.toAbsolutePath());
    }

    private HDT mapOrGetHDT() {
        if (this.hdt == null) {
            try {
                this.hdt = HDTManager.mapHDT((String)this.hdtFile.toString());
            }
            catch (IOException e) {
                throw new RuntimeException("Can't map the hdt file", e);
            }
        }
        return this.hdt;
    }

    public Header getHeader() {
        return this.mapOrGetHDT().getHeader();
    }

    public Dictionary getDictionary() {
        return this.mapOrGetHDT().getDictionary();
    }

    public Triples getTriples() {
        return this.mapOrGetHDT().getTriples();
    }

    public void saveToHDT(OutputStream output, ProgressListener listener) throws IOException {
        Files.copy(this.hdtFile, output);
    }

    public void saveToHDT(String fileName, ProgressListener listener) throws IOException {
        Path future = Path.of(fileName, new String[0]).toAbsolutePath();
        if (!future.equals(this.hdtFile)) {
            Files.copy(this.hdtFile, future, new CopyOption[0]);
        }
    }

    public long size() {
        return this.mapOrGetHDT().size();
    }

    public String getBaseURI() {
        return this.mapOrGetHDT().getBaseURI();
    }

    public void close() throws IOException {
        IOUtil.closeAll(new Closeable[]{this.hdt});
        this.hdt = null;
    }

    public IteratorTripleString search(CharSequence subject, CharSequence predicate, CharSequence object) throws NotFoundException {
        return this.mapOrGetHDT().search(subject, predicate, object);
    }
}

