/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.rdfhdt.hdt.hdt.impl.diskimport.CompressionResult;
import org.rdfhdt.hdt.hdt.impl.diskimport.SectionCompressor;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.CompressNodeMergeIterator;
import org.rdfhdt.hdt.util.io.compress.CompressNodeReader;

public class CompressionResultPartial
implements CompressionResult {
    private final List<CompressNodeReaderTriple> files;
    private final long triplesCount;
    private final long ntSize;
    private final ExceptionIterator<IndexedNode, IOException> subject;
    private final ExceptionIterator<IndexedNode, IOException> predicate;
    private final ExceptionIterator<IndexedNode, IOException> object;

    public CompressionResultPartial(List<SectionCompressor.TripleFile> files, long triplesCount, long ntSize) throws IOException {
        this.files = new ArrayList<CompressNodeReaderTriple>(files.size());
        this.ntSize = ntSize;
        for (SectionCompressor.TripleFile file : files) {
            this.files.add(new CompressNodeReaderTriple(file));
        }
        this.triplesCount = triplesCount;
        this.subject = this.createBTree(0, files.size(), CompressNodeReaderTriple::getS);
        this.predicate = this.createBTree(0, files.size(), CompressNodeReaderTriple::getP);
        this.object = this.createBTree(0, files.size(), CompressNodeReaderTriple::getO);
    }

    private ExceptionIterator<IndexedNode, IOException> createBTree(int start, int end, Function<CompressNodeReaderTriple, CompressNodeReader> fetcher) {
        int size = end - start;
        if (size <= 0) {
            return ExceptionIterator.empty();
        }
        if (size == 1) {
            return fetcher.apply(this.files.get(start));
        }
        int mid = (start + end) / 2;
        ExceptionIterator<IndexedNode, IOException> left = this.createBTree(start, mid, fetcher);
        ExceptionIterator<IndexedNode, IOException> right = this.createBTree(mid, end, fetcher);
        return new CompressNodeMergeIterator(left, right);
    }

    @Override
    public long getTripleCount() {
        return this.triplesCount;
    }

    @Override
    public ExceptionIterator<IndexedNode, IOException> getSubjects() {
        return this.subject;
    }

    @Override
    public ExceptionIterator<IndexedNode, IOException> getPredicates() {
        return this.predicate;
    }

    @Override
    public ExceptionIterator<IndexedNode, IOException> getObjects() {
        return this.object;
    }

    @Override
    public void delete() throws IOException {
        IOUtil.closeAll(this.files);
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAll(this.files);
    }

    @Override
    public long getSubjectsCount() {
        return this.triplesCount;
    }

    @Override
    public long getPredicatesCount() {
        return this.triplesCount;
    }

    @Override
    public long getObjectsCount() {
        return this.triplesCount;
    }

    @Override
    public long getSharedCount() {
        return this.triplesCount;
    }

    @Override
    public long getRawSize() {
        return this.ntSize;
    }

    private static class CompressNodeReaderTriple
    implements Closeable {
        final CompressNodeReader s;
        final CompressNodeReader p;
        final CompressNodeReader o;
        final SectionCompressor.TripleFile file;

        public CompressNodeReaderTriple(SectionCompressor.TripleFile file) throws IOException {
            this.s = new CompressNodeReader(file.openRSubject());
            this.p = new CompressNodeReader(file.openRPredicate());
            this.o = new CompressNodeReader(file.openRObject());
            this.file = file;
        }

        @Override
        public void close() throws IOException {
            IOUtil.closeAll(this.s, this.p, this.o);
        }

        public CompressNodeReader getS() {
            return this.s;
        }

        public CompressNodeReader getP() {
            return this.p;
        }

        public CompressNodeReader getO() {
            return this.o;
        }
    }
}

