/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.IOException;
import org.rdfhdt.hdt.hdt.impl.diskimport.CompressionResult;
import org.rdfhdt.hdt.hdt.impl.diskimport.SectionCompressor;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.CompressNodeReader;

public class CompressionResultFile
implements CompressionResult {
    private final long tripleCount;
    private final long ntRawSize;
    private final CompressNodeReader subjects;
    private final CompressNodeReader predicates;
    private final CompressNodeReader objects;
    private final SectionCompressor.TripleFile sections;

    public CompressionResultFile(long tripleCount, long ntRawSize, SectionCompressor.TripleFile sections) throws IOException {
        this.tripleCount = tripleCount;
        this.ntRawSize = ntRawSize;
        this.subjects = new CompressNodeReader(sections.openRSubject());
        this.predicates = new CompressNodeReader(sections.openRPredicate());
        this.objects = new CompressNodeReader(sections.openRObject());
        this.sections = sections;
    }

    @Override
    public long getTripleCount() {
        return this.tripleCount;
    }

    @Override
    public ExceptionIterator<IndexedNode, IOException> getSubjects() {
        return this.subjects;
    }

    @Override
    public ExceptionIterator<IndexedNode, IOException> getPredicates() {
        return this.predicates;
    }

    @Override
    public ExceptionIterator<IndexedNode, IOException> getObjects() {
        return this.objects;
    }

    @Override
    public void delete() throws IOException {
        this.sections.delete();
    }

    @Override
    public long getSubjectsCount() {
        return this.subjects.getSize();
    }

    @Override
    public long getPredicatesCount() {
        return this.predicates.getSize();
    }

    @Override
    public long getObjectsCount() {
        return this.objects.getSize();
    }

    @Override
    public long getSharedCount() {
        return this.tripleCount;
    }

    @Override
    public long getRawSize() {
        return this.ntRawSize;
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeAll(this.objects, this.predicates, this.subjects);
    }
}

