/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.IOException;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.impl.CompressFourSectionDictionary;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.io.compress.CompressUtil;
import org.rdfhdt.hdt.util.io.compress.WriteLongArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressTripleMapper
implements CompressFourSectionDictionary.NodeConsumer {
    private static final Logger log = LoggerFactory.getLogger(CompressTripleMapper.class);
    private final WriteLongArrayBuffer subjects;
    private final WriteLongArrayBuffer predicates;
    private final WriteLongArrayBuffer objects;
    private final CloseSuppressPath locationSubjects;
    private final CloseSuppressPath locationPredicates;
    private final CloseSuppressPath locationObjects;
    private long shared = -1L;
    private final long tripleCount;

    public CompressTripleMapper(CloseSuppressPath location, long tripleCount, long chunkSize) {
        this.tripleCount = tripleCount;
        this.locationSubjects = location.resolve("map_subjects");
        this.locationPredicates = location.resolve("map_predicates");
        this.locationObjects = location.resolve("map_objects");
        int numbits = BitUtil.log2(tripleCount + 2L) + 1;
        int maxElement = (int)Math.min(chunkSize / 8L / 3L, 0x7FFFFFFAL);
        this.subjects = new WriteLongArrayBuffer(new SequenceLog64BigDisk(this.locationSubjects.toAbsolutePath().toString(), numbits, tripleCount + 2L, true), tripleCount, maxElement);
        this.predicates = new WriteLongArrayBuffer(new SequenceLog64BigDisk(this.locationPredicates.toAbsolutePath().toString(), numbits, tripleCount + 2L, true), tripleCount, maxElement);
        this.objects = new WriteLongArrayBuffer(new SequenceLog64BigDisk(this.locationObjects.toAbsolutePath().toString(), numbits, tripleCount + 2L, true), tripleCount, maxElement);
    }

    public void delete() {
        try {
            IOUtil.closeAll(this.subjects, this.predicates, this.objects);
        }
        catch (IOException e) {
            log.warn("Can't close triple map array", (Throwable)e);
        }
        try {
            IOUtil.closeAll(this.locationSubjects, this.locationPredicates, this.locationObjects);
        }
        catch (IOException e) {
            log.warn("Can't delete triple map array files", (Throwable)e);
        }
    }

    @Override
    public void onSubject(long preMapId, long newMapId) {
        assert (preMapId > 0L);
        assert (newMapId >= CompressUtil.getHeaderId(1L));
        this.subjects.set(preMapId, newMapId);
    }

    @Override
    public void onPredicate(long preMapId, long newMapId) {
        assert (preMapId > 0L);
        assert (newMapId >= CompressUtil.getHeaderId(1L));
        this.predicates.set(preMapId, newMapId);
    }

    @Override
    public void onObject(long preMapId, long newMapId) {
        assert (preMapId > 0L);
        assert (newMapId >= CompressUtil.getHeaderId(1L));
        this.objects.set(preMapId, newMapId);
    }

    public void setShared(long shared) {
        this.shared = shared;
        this.subjects.free();
        this.predicates.free();
        this.objects.free();
    }

    private void checkShared() {
        if (this.shared < 0L) {
            throw new IllegalArgumentException("Shared not set!");
        }
    }

    public long extractSubject(long id) {
        return this.extract(this.subjects, id);
    }

    public long extractPredicate(long id) {
        return this.extract(this.predicates, id) - this.shared;
    }

    public long extractObjects(long id) {
        return this.extract(this.objects, id);
    }

    private long extract(LongArray array, long id) {
        this.checkShared();
        return CompressUtil.computeSharedNode(array.get(id), this.shared);
    }

    public long getTripleCount() {
        return this.tripleCount;
    }
}

