/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTSupplier;
import org.rdfhdt.hdt.hdt.impl.diskimport.AsyncCatTreeWorker;
import org.rdfhdt.hdt.hdt.impl.diskimport.MapOnCallHDT;
import org.rdfhdt.hdt.iterator.utils.FluxStopTripleStringIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HideHDTOptions;
import org.rdfhdt.hdt.rdf.RDFFluxStop;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.Profiler;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.listener.PrefixListener;

public class CatTreeImpl
implements Closeable {
    private final HideHDTOptions hdtFormat;
    private final int kHDTCat;
    private final Path basePath;
    private final Path futureHDTLocation;
    private final Closer closer = Closer.of(new Object[0]);
    private final Profiler profiler;
    private final boolean async;

    public CatTreeImpl(HDTOptions hdtFormat) throws IOException {
        try {
            long khdtCatOpt = hdtFormat.getInt("loader.cattree.kcat", 1L);
            if (khdtCatOpt <= 0L || khdtCatOpt >= 0x7FFFFFF9L) {
                throw new IllegalArgumentException("Invalid kcat value: " + khdtCatOpt);
            }
            this.kHDTCat = (int)khdtCatOpt;
            String baseNameOpt = hdtFormat.get("loader.cattree.location");
            this.basePath = baseNameOpt == null || baseNameOpt.isEmpty() ? Files.createTempDirectory("hdt-java-cat-tree", new FileAttribute[0]) : Path.of(baseNameOpt, new String[0]);
            this.futureHDTLocation = Optional.ofNullable(hdtFormat.get("loader.cattree.futureHDTLocation")).map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
            boolean async = hdtFormat.getBoolean("loader.cattree.async", false);
            this.hdtFormat = new HideHDTOptions(hdtFormat, this::mapHiddenKeys);
            if (async) {
                int processors;
                long worker = hdtFormat.getInt("loader.disk.compressWorker", -1L);
                if (worker == -1L) {
                    processors = Runtime.getRuntime().availableProcessors();
                } else if (worker >= 0L && worker < Integer.MAX_VALUE) {
                    processors = (int)worker;
                } else {
                    throw new IllegalArgumentException("Bad worker count: " + worker);
                }
                if (processors >= 2) {
                    this.hdtFormat.overrideValue("loader.disk.compressWorker", processors - 1);
                    this.async = true;
                } else {
                    this.async = false;
                }
            } else {
                this.async = false;
            }
            this.profiler = Profiler.createOrLoadSubSection((String)"doHDTCatTree", (HDTOptions)hdtFormat, (boolean)true);
            this.closer.with(() -> ((Profiler)this.profiler).close(), new Object[0]);
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
        }
    }

    private String mapHiddenKeys(String key) {
        if ("loader.type".equals(key)) {
            return "loader.cattree.loadertype";
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<HDTFile> getNextHDTs(boolean nextFile, List<HDTFile> files, HDTFile current, int maxFiles) {
        if (files.isEmpty()) {
            return List.of();
        }
        ArrayList<HDTFile> next = new ArrayList<HDTFile>();
        if (nextFile || files.size() > maxFiles) {
            int i;
            for (i = 1; i < maxFiles && i <= files.size(); ++i) {
                HDTFile old = files.get(files.size() - i);
                if (nextFile && old.getChunks() > current.getChunks()) break;
                next.add(old);
            }
            if (nextFile && next.size() != maxFiles - 1) return List.of();
            for (i = 0; i < next.size(); ++i) {
                files.remove(files.size() - 1);
            }
        } else {
            next.addAll(files);
            files.clear();
        }
        next.add(current);
        return next;
    }

    public HDT doGeneration(RDFFluxStop fluxStop, HDTSupplier supplier, Iterator<TripleString> iterator, String baseURI, ProgressListener listener) throws IOException, ParserException {
        if (this.async && this.kHDTCat > 1) {
            return this.doGenerationAsync(fluxStop, supplier, iterator, baseURI, listener);
        }
        return this.doGenerationSync(fluxStop, supplier, iterator, baseURI, listener);
    }

    public HDT doGenerationAsync(RDFFluxStop fluxStop, HDTSupplier supplier, Iterator<TripleString> iterator, String baseURI, ProgressListener listener) throws IOException, ParserException {
        try (AsyncCatTreeWorker worker = new AsyncCatTreeWorker(this, fluxStop, supplier, iterator, baseURI, listener);){
            worker.start();
            HDT hDT = worker.buildHDT();
            return hDT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDT doGenerationSync(RDFFluxStop fluxStop, HDTSupplier supplier, Iterator<TripleString> iterator, String baseURI, ProgressListener listener) throws IOException, ParserException {
        boolean nextFile;
        FluxStopTripleStringIterator it = new FluxStopTripleStringIterator(iterator, fluxStop);
        ArrayList<HDTFile> files = new ArrayList<HDTFile>();
        long gen = 0L;
        long cat = 0L;
        Path hdtStore = this.basePath.resolve("hdt-store");
        Path hdtCatLocationPath = this.basePath.resolve("cat");
        String hdtCatLocation = hdtCatLocationPath.toAbsolutePath().toString();
        Files.createDirectories(hdtStore, new FileAttribute[0]);
        Files.createDirectories(hdtCatLocationPath, new FileAttribute[0]);
        do {
            Path hdtCatFileLocation;
            PrefixListener ilc;
            this.profiler.pushSection("generateHDT #" + ++gen);
            PrefixListener il = PrefixListener.of("gen#" + gen, listener);
            Path hdtLocation = hdtStore.resolve("hdt-" + gen + ".hdt");
            System.gc();
            supplier.doGenerateHDT((Iterator)it, baseURI, (HDTOptions)this.hdtFormat, (ProgressListener)il, hdtLocation);
            il.clearThreads();
            nextFile = it.hasNextFlux();
            HDTFile hdtFile = new HDTFile(hdtLocation, 1L);
            this.profiler.popSection();
            if (this.kHDTCat == 1) {
                while (!(files.isEmpty() || nextFile && ((HDTFile)files.get(files.size() - 1)).getChunks() > hdtFile.getChunks())) {
                    HDTFile lastHDTFile = (HDTFile)files.remove(files.size() - 1);
                    this.profiler.pushSection("catHDT #" + ++cat);
                    ilc = PrefixListener.of("cat#" + cat, listener);
                    hdtCatFileLocation = hdtStore.resolve("hdtcat-" + cat + ".hdt");
                    try (HDT abcat = HDTManager.catHDT((String)hdtCatLocation, (String)lastHDTFile.getHdtFile().toAbsolutePath().toString(), (String)hdtFile.getHdtFile().toAbsolutePath().toString(), (HDTOptions)this.hdtFormat, (ProgressListener)ilc);){
                        abcat.saveToHDT(hdtCatFileLocation.toAbsolutePath().toString(), (ProgressListener)ilc);
                    }
                    ilc.clearThreads();
                    Files.delete(lastHDTFile.getHdtFile());
                    Files.delete(hdtFile.getHdtFile());
                    hdtFile = new HDTFile(hdtCatFileLocation, lastHDTFile.getChunks() + hdtFile.getChunks());
                    this.profiler.popSection();
                }
            } else {
                List<HDTFile> nextHDTs;
                while (!(nextHDTs = this.getNextHDTs(nextFile, files, hdtFile, this.kHDTCat)).isEmpty()) {
                    this.profiler.pushSection("catHDT #" + ++cat);
                    ilc = PrefixListener.of("cat#" + cat, listener);
                    hdtCatFileLocation = hdtStore.resolve("hdtcat-" + cat + ".hdt");
                    assert (nextHDTs.size() > 1);
                    this.hdtFormat.overrideValue("loader.cattree.futureHDTLocation", hdtCatFileLocation.toAbsolutePath());
                    try (HDT abcat = HDTManager.catHDT(nextHDTs.stream().map(f -> f.getHdtFile().toAbsolutePath().toString()).collect(Collectors.toList()), (HDTOptions)this.hdtFormat, (ProgressListener)ilc);){
                        abcat.saveToHDT(hdtCatFileLocation.toAbsolutePath().toString(), (ProgressListener)ilc);
                    }
                    this.hdtFormat.overrideValue("loader.cattree.futureHDTLocation", null);
                    ilc.clearThreads();
                    for (HDTFile nextHDT : nextHDTs) {
                        Files.delete(nextHDT.getHdtFile());
                    }
                    long chunks = nextHDTs.stream().mapToLong(HDTFile::getChunks).sum();
                    hdtFile = new HDTFile(hdtCatFileLocation, chunks);
                    this.profiler.popSection();
                }
            }
            assert (nextFile || files.isEmpty()) : "no data remaining, but contains files";
            files.add(hdtFile);
        } while (nextFile);
        listener.notifyProgress(100.0f, "done, loading HDT");
        Path hdtFile = ((HDTFile)files.get((int)0)).hdtFile;
        assert (files.size() == 1) : "more than 1 file: " + files;
        assert (cat < gen) : "more cat than gen";
        assert (((HDTFile)files.get(0)).getChunks() == gen) : "gen size isn't the same as excepted: " + ((HDTFile)files.get(0)).getChunks() + " != " + gen;
        try {
            HDT hDT;
            if (this.futureHDTLocation != null) {
                Files.createDirectories(this.futureHDTLocation.toAbsolutePath().getParent(), new FileAttribute[0]);
                Files.deleteIfExists(this.futureHDTLocation);
                Files.move(hdtFile, this.futureHDTLocation, new CopyOption[0]);
                hDT = new MapOnCallHDT(this.futureHDTLocation);
                return hDT;
            }
            hDT = HDTManager.loadHDT((String)hdtFile.toAbsolutePath().toString());
            return hDT;
        }
        finally {
            Files.deleteIfExists(hdtFile);
            this.profiler.stop();
            this.profiler.writeProfiling();
        }
    }

    public HideHDTOptions getHdtFormat() {
        return this.hdtFormat;
    }

    public Path getFutureHDTLocation() {
        return this.futureHDTLocation;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public int getkHDTCat() {
        return this.kHDTCat;
    }

    public Path getBasePath() {
        return this.basePath;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    static class HDTFile {
        private final Path hdtFile;
        private final long chunks;

        public HDTFile(Path hdtFile, long chunks) {
            this.hdtFile = hdtFile;
            this.chunks = chunks;
        }

        public long getChunks() {
            return this.chunks;
        }

        public Path getHdtFile() {
            return this.hdtFile;
        }

        public String toString() {
            return "HDTFile{hdtFile=" + this.hdtFile + ", chunks=" + this.chunks + "}";
        }
    }
}

