/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl.diskimport;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTFactory;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTSupplier;
import org.rdfhdt.hdt.hdt.impl.diskimport.CatTreeImpl;
import org.rdfhdt.hdt.hdt.impl.diskimport.MapOnCallHDT;
import org.rdfhdt.hdt.iterator.utils.FluxStopTripleStringIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HideHDTOptions;
import org.rdfhdt.hdt.rdf.RDFFluxStop;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.Profiler;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import org.rdfhdt.hdt.util.concurrent.HeightTree;
import org.rdfhdt.hdt.util.listener.PrefixListener;

public class AsyncCatTreeWorker
implements Closeable {
    private final CatTreeImpl impl;
    private final ExceptionThread mergeThread;
    private final FluxStopTripleStringIterator it;
    private final int kcat;
    private final HDTSupplier supplier;
    private final String baseURI;
    private final ProgressListener listener;
    private final Profiler catProfiler;
    private final Profiler profiler;
    private final HeightTree<CatTreeImpl.HDTFile> tree = new HeightTree();
    private boolean endread;
    private final Path hdtStore;
    private final Path hdtCatLocationPath;
    private HDT hdt;

    public AsyncCatTreeWorker(CatTreeImpl impl, RDFFluxStop fluxStop, HDTSupplier supplier, Iterator<TripleString> iterator, String baseURI, ProgressListener listener) throws IOException {
        this.impl = impl;
        this.kcat = impl.getkHDTCat();
        this.it = new FluxStopTripleStringIterator(iterator, fluxStop);
        this.supplier = supplier;
        this.baseURI = baseURI;
        this.listener = listener;
        this.catProfiler = Profiler.createOrLoadSubSection((String)"asynccatloader", (HDTOptions)impl.getHdtFormat(), (boolean)false, (boolean)true);
        this.profiler = impl.getProfiler();
        this.hdtStore = impl.getBasePath().resolve("hdt-store");
        this.hdtCatLocationPath = impl.getBasePath().resolve("cat");
        Files.createDirectories(this.hdtStore, new FileAttribute[0]);
        Files.createDirectories(this.hdtCatLocationPath, new FileAttribute[0]);
        this.mergeThread = new ExceptionThread(this::runMergeThread, "CatTreeMergeThread").attach(new ExceptionThread(this::runGenThread, "CatTreeGenThread"));
    }

    public void start() {
        this.mergeThread.startAll();
    }

    public HDT buildHDT() throws ParserException, IOException {
        try {
            this.mergeThread.joinAndCrashIfRequired();
        }
        catch (InterruptedException e) {
            throw new ParserException((Throwable)e);
        }
        catch (ExceptionThread.ExceptionThreadException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof ParserException) {
                throw (ParserException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
        return this.hdt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGenThread() throws IOException, ParserException {
        boolean nextFile;
        long gen = 0L;
        do {
            this.profiler.pushSection("generateHDT #" + ++gen);
            PrefixListener il = PrefixListener.of("gen#" + gen, this.listener);
            Path hdtLocation = this.hdtStore.resolve("hdt-" + gen + ".hdt");
            System.gc();
            this.supplier.doGenerateHDT((Iterator)this.it, this.baseURI, (HDTOptions)this.impl.getHdtFormat(), (ProgressListener)il, hdtLocation);
            il.clearThreads();
            nextFile = this.it.hasNextFlux();
            HeightTree<CatTreeImpl.HDTFile> heightTree = this.tree;
            synchronized (heightTree) {
                this.tree.addElement(new CatTreeImpl.HDTFile(hdtLocation, 1L), 1);
                this.endread = !nextFile;
                this.tree.notifyAll();
            }
            this.profiler.popSection();
        } while (nextFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMergeThread() throws IOException, InterruptedException {
        int chunks;
        Path hdtCatFileLocation;
        PrefixListener ilc;
        List gen;
        List<CatTreeImpl.HDTFile> lst;
        long cat = 0L;
        HideHDTOptions spec = new HideHDTOptions(this.impl.getHdtFormat());
        spec.set("hdtcat.location", this.hdtCatLocationPath);
        while (!this.endread) {
            HeightTree<CatTreeImpl.HDTFile> heightTree = this.tree;
            synchronized (heightTree) {
                while ((lst = this.tree.getMax(this.kcat)) == null && !this.endread) {
                    this.tree.wait();
                }
            }
            if (lst == null) break;
            gen = lst.stream().map(CatTreeImpl.HDTFile::getHdtFile).map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
            this.profiler.pushSection("catHDT #" + ++cat);
            ilc = PrefixListener.of("cat#" + cat, this.listener);
            hdtCatFileLocation = this.hdtStore.resolve("hdtcat-" + cat + ".hdt");
            spec.overrideValue("loader.cattree.futureHDTLocation", hdtCatFileLocation.toAbsolutePath());
            try (HDT abcat = HDTManager.catHDT(gen, (HDTOptions)spec, (ProgressListener)ilc);){
                abcat.saveToHDT(hdtCatFileLocation.toAbsolutePath().toString(), (ProgressListener)ilc);
            }
            spec.overrideValue("loader.cattree.futureHDTLocation", null);
            ilc.clearThreads();
            for (CatTreeImpl.HDTFile hDTFile : lst) {
                Files.delete(hDTFile.getHdtFile());
            }
            chunks = (int)lst.stream().mapToLong(CatTreeImpl.HDTFile::getChunks).max().orElseThrow() + 1;
            HeightTree<CatTreeImpl.HDTFile> heightTree2 = this.tree;
            synchronized (heightTree2) {
                this.tree.addElement(new CatTreeImpl.HDTFile(hdtCatFileLocation, chunks), chunks);
            }
            this.profiler.popSection();
        }
        while (this.tree.size() > 1) {
            lst = this.tree.getAll(this.kcat);
            gen = lst.stream().map(CatTreeImpl.HDTFile::getHdtFile).map(Path::toAbsolutePath).map(Path::toString).collect(Collectors.toList());
            this.profiler.pushSection("catHDT #" + ++cat);
            ilc = PrefixListener.of("cat#" + cat, this.listener);
            hdtCatFileLocation = this.hdtStore.resolve("hdtcat-" + cat + ".hdt");
            spec.overrideValue("loader.cattree.futureHDTLocation", hdtCatFileLocation.toAbsolutePath());
            try (HDT abcat = HDTManager.catHDT(gen, (HDTOptions)spec, (ProgressListener)ilc);){
                abcat.saveToHDT(hdtCatFileLocation.toAbsolutePath().toString(), (ProgressListener)ilc);
            }
            spec.overrideValue("loader.cattree.futureHDTLocation", null);
            ilc.clearThreads();
            for (CatTreeImpl.HDTFile hDTFile : lst) {
                Files.delete(hDTFile.getHdtFile());
            }
            chunks = (int)lst.stream().mapToLong(CatTreeImpl.HDTFile::getChunks).max().orElseThrow() + 1;
            this.tree.addElement(new CatTreeImpl.HDTFile(hdtCatFileLocation, chunks), chunks);
        }
        if (this.tree.size() == 0) {
            this.hdt = HDTFactory.createHDT();
        } else {
            List<CatTreeImpl.HDTFile> hdts = this.tree.getAll(1);
            assert (hdts.size() == 1);
            Path hdtFile = hdts.get(0).getHdtFile();
            try {
                if (this.impl.getFutureHDTLocation() != null) {
                    Files.createDirectories(this.impl.getFutureHDTLocation().toAbsolutePath().getParent(), new FileAttribute[0]);
                    Files.deleteIfExists(this.impl.getFutureHDTLocation());
                    Files.move(hdtFile, this.impl.getFutureHDTLocation(), new CopyOption[0]);
                    this.hdt = new MapOnCallHDT(this.impl.getFutureHDTLocation());
                } else {
                    this.hdt = HDTManager.loadHDT((String)hdtFile.toAbsolutePath().toString());
                }
            }
            finally {
                Files.deleteIfExists(hdtFile);
                this.profiler.stop();
                this.profiler.writeProfiling();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.catProfiler.close();
    }
}

