/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.rdfhdt.hdt.dictionary.DictionaryFactory;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.hdt.impl.HDTBase;
import org.rdfhdt.hdt.header.HeaderFactory;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.triples.impl.WriteBitmapTriples;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;

public class WriteHDTImpl
extends HDTBase<HeaderPrivate, DictionaryPrivate, TriplesPrivate> {
    private String baseURI;
    private final CloseSuppressPath workingLocation;
    private boolean isClosed;

    public WriteHDTImpl(HDTOptions spec, CloseSuppressPath workingLocation, int bufferSize) throws IOException {
        super(spec);
        this.workingLocation = workingLocation;
        workingLocation.mkdirs();
        this.dictionary = DictionaryFactory.createWriteDictionary(this.spec, workingLocation.resolve("section"), bufferSize);
        this.triples = new WriteBitmapTriples(this.spec, workingLocation.resolve("tripleBitmap"), bufferSize);
        this.header = HeaderFactory.createHeader(this.spec);
    }

    public WriteHDTImpl(HDTOptions spec, CloseSuppressPath workingLocation, DictionaryPrivate dict, TriplesPrivate triples, HeaderPrivate header) throws IOException {
        super(spec);
        this.workingLocation = workingLocation;
        workingLocation.mkdirs();
        this.dictionary = dict;
        this.triples = triples;
        this.header = header;
    }

    @Override
    public void setBaseUri(String baseURI) {
        this.baseURI = baseURI;
    }

    @Override
    public void loadFromHDT(InputStream input, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void loadFromHDT(String fileName, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void mapFromHDT(File f, long offset, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void loadOrCreateIndex(ProgressListener listener, HDTOptions disk) {
        throw new NotImplementedException();
    }

    public void saveToHDT(String fileName, ProgressListener listener) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Path.of(fileName, new String[0]), new OpenOption[0]));){
            this.saveToHDT(out, listener);
        }
    }

    @Override
    public long size() {
        if (this.isClosed) {
            return 0L;
        }
        return this.getDictionary().size() + this.getTriples().size();
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        this.isClosed = true;
        IOUtil.closeAll(new Closeable[]{this.dictionary, this.triples, this.workingLocation});
    }

    public IteratorTripleString search(CharSequence subject, CharSequence predicate, CharSequence object) {
        throw new NotImplementedException();
    }
}

