/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.BitmapFactory;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.DictionaryFactory;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionaryBig;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionaryCat;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionaryBig;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionaryCat;
import org.rdfhdt.hdt.enums.ResultEstimationType;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTVersion;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.impl.HDTBase;
import org.rdfhdt.hdt.header.HeaderFactory;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.iterator.DictionaryTranslateIterator;
import org.rdfhdt.hdt.iterator.DictionaryTranslateIteratorBuffer;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.DictionaryEntriesDiff;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.triples.TriplesFactory;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesCat;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorCat;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorDiff;
import org.rdfhdt.hdt.triples.impl.BitmapTriplesIteratorMapDiff;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.Profiler;
import org.rdfhdt.hdt.util.StopWatch;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDTImpl
extends HDTBase<HeaderPrivate, DictionaryPrivate, TriplesPrivate> {
    private static final Logger log = LoggerFactory.getLogger(HDTImpl.class);
    private String hdtFileName;
    private String baseUri;
    private boolean isMapped;
    private boolean isClosed = false;

    public HDTImpl(HDTOptions spec) throws IOException {
        super(spec);
        this.header = HeaderFactory.createHeader(this.spec);
        this.dictionary = DictionaryFactory.createDictionary(this.spec);
        this.triples = TriplesFactory.createTriples(this.spec);
    }

    @Override
    public void loadFromHDT(InputStream input, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.load(input);
        String hdtFormat = ci.getFormat();
        if (!hdtFormat.equals("<http://purl.org/HDT/hdt#HDTv1>") && !hdtFormat.equals("<http://purl.org/HDT/hdt#HDTv2>")) {
            throw new IllegalFormatException("This software (v1.x.x | v2.x.x) cannot open this version of HDT File (" + hdtFormat + ")");
        }
        ci.clear();
        ci.load(input);
        iListener.setRange(0.0f, 5.0f);
        this.header = HeaderFactory.createHeader(ci);
        ((HeaderPrivate)this.header).load(input, ci, iListener);
        this.baseUri = ((HeaderPrivate)this.header).getBaseURI().toString();
        ci.clear();
        ci.load(input);
        iListener.setRange(5.0f, 60.0f);
        this.dictionary = DictionaryFactory.createDictionary(ci);
        this.dictionary.load(input, ci, iListener);
        ci.clear();
        ci.load(input);
        iListener.setRange(60.0f, 100.0f);
        this.triples = TriplesFactory.createTriples(ci);
        this.triples.load(input, ci, iListener);
        this.isClosed = false;
    }

    @Override
    public void loadFromHDT(String hdtFileName, ProgressListener listener) throws IOException {
        InputStream in = hdtFileName.endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(hdtFileName))) : new CountInputStream(new BufferedInputStream(new FileInputStream(hdtFileName)));
        this.loadFromHDT(in, listener);
        in.close();
        this.hdtFileName = hdtFileName;
        this.isClosed = false;
    }

    @Override
    public void mapFromHDT(File f, long offset, ProgressListener listener) throws IOException {
        this.hdtFileName = f.toString();
        this.isMapped = true;
        if (this.hdtFileName.endsWith(".gz")) {
            File old = f;
            this.hdtFileName = this.hdtFileName.substring(0, this.hdtFileName.length() - 3);
            f = new File(this.hdtFileName);
            if (!f.exists()) {
                System.err.println("We cannot map a gzipped HDT, decompressing into " + this.hdtFileName + " first.");
                IOUtil.decompressGzip(old, f);
                System.err.println("Gzipped HDT successfully decompressed. You might want to delete " + old.getAbsolutePath() + " to save disk space.");
            } else {
                System.err.println("We cannot map a gzipped HDT, using " + this.hdtFileName + " instead.");
            }
        }
        CountInputStream input = new CountInputStream(new BufferedInputStream(new FileInputStream(this.hdtFileName)));
        ControlInformation ci = new ControlInformation();
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.load(input);
        String hdtFormat = ci.getFormat();
        if (!hdtFormat.equals("<http://purl.org/HDT/hdt#HDTv1>") && !hdtFormat.equals("<http://purl.org/HDT/hdt#HDTv2>")) {
            throw new IllegalFormatException("This software (v1.x.x | v2.x.x) cannot open this version of HDT File (" + hdtFormat + ")");
        }
        ci.clear();
        ci.load(input);
        iListener.setRange(0.0f, 5.0f);
        this.header = HeaderFactory.createHeader(ci);
        ((HeaderPrivate)this.header).load(input, ci, iListener);
        this.baseUri = ((HeaderPrivate)this.header).getBaseURI().toString();
        if (this.baseUri.isEmpty()) {
            log.error("Empty base uri!");
        }
        ci.clear();
        input.mark(1024);
        ci.load(input);
        input.reset();
        iListener.setRange(5.0f, 60.0f);
        this.dictionary = DictionaryFactory.createDictionary(ci);
        this.dictionary.mapFromFile(input, f, iListener);
        ci.clear();
        input.mark(1024);
        ci.load(input);
        input.reset();
        iListener.setRange(60.0f, 100.0f);
        this.triples = TriplesFactory.createTriples(ci);
        this.triples.mapFromFile(input, f, iListener);
        input.close();
        this.isClosed = false;
    }

    public void saveToHDT(String fileName, ProgressListener listener) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileName));){
            this.saveToHDT(out, listener);
        }
        this.hdtFileName = fileName;
    }

    public IteratorTripleString search(CharSequence subject, CharSequence predicate, CharSequence object) throws NotFoundException {
        if (this.isClosed) {
            throw new IllegalStateException("Cannot search an already closed HDT");
        }
        TripleID triple = new TripleID(this.dictionary.stringToId(subject, TripleComponentRole.SUBJECT), this.dictionary.stringToId(predicate, TripleComponentRole.PREDICATE), this.dictionary.stringToId(object, TripleComponentRole.OBJECT));
        if (triple.isNoMatch()) {
            return new IteratorTripleString(){

                public TripleString next() {
                    return null;
                }

                public boolean hasNext() {
                    return false;
                }

                public ResultEstimationType numResultEstimation() {
                    return ResultEstimationType.EXACT;
                }

                public void goToStart() {
                }

                public long estimatedNumResults() {
                    return 0L;
                }

                public long getLastTriplePosition() {
                    throw new NotImplementedException();
                }
            };
        }
        if (this.isMapped) {
            try {
                if (this.dictionary instanceof MultipleSectionDictionary) {
                    return new DictionaryTranslateIteratorBuffer(this.triples.search(triple), (MultipleSectionDictionary)this.dictionary, subject, predicate, object);
                }
                return new DictionaryTranslateIteratorBuffer(this.triples.search(triple), (FourSectionDictionary)this.dictionary, subject, predicate, object);
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                return new DictionaryTranslateIterator(this.triples.search(triple), this.dictionary, subject, predicate, object);
            }
        }
        return new DictionaryTranslateIterator(this.triples.search(triple), this.dictionary, subject, predicate, object);
    }

    public void loadFromParts(HeaderPrivate h, DictionaryPrivate d, TriplesPrivate t) {
        this.header = h;
        this.dictionary = d;
        this.triples = t;
        this.isClosed = false;
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void loadFromModifiableHDT(TempHDT modHdt, ProgressListener listener) {
        modHdt.reorganizeDictionary(listener);
        modHdt.reorganizeTriples(listener);
        TempTriples modifiableTriples = modHdt.getTriples();
        TempDictionary modifiableDictionary = modHdt.getDictionary();
        if (this.triples.getClass().equals(modifiableTriples.getClass())) {
            this.triples = modifiableTriples;
        } else {
            this.triples.load(modifiableTriples, listener);
        }
        if (this.dictionary.getClass().equals(modifiableDictionary.getClass())) {
            this.dictionary = (DictionaryPrivate)((Object)modifiableDictionary);
        } else {
            this.dictionary.load(modifiableDictionary, listener);
        }
        this.baseUri = modHdt.getBaseURI();
        this.isClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadOrCreateIndex(ProgressListener listener, HDTOptions spec) throws IOException {
        CountInputStream in;
        block12: {
            if (this.triples.getNumberOfElements() == 0L) {
                return;
            }
            ControlInformation ci = new ControlInformation();
            Object indexName = this.hdtFileName + HDTVersion.get_index_suffix((String)"-");
            Object versionName = indexName = ((String)indexName).replaceAll("\\.hdt\\.gz", "hdt");
            File ff = new File((String)indexName);
            if (!ff.isFile() || !ff.canRead()) {
                indexName = this.hdtFileName + ".index";
                indexName = ((String)indexName).replaceAll("\\.hdt\\.gz", "hdt");
                ff = new File((String)indexName);
            }
            in = null;
            try {
                in = new CountInputStream(new BufferedInputStream(new FileInputStream(ff)));
                ci.load(in);
                if (this.isMapped) {
                    this.triples.mapIndex(in, new File((String)indexName), ci, listener);
                    break block12;
                }
                this.triples.loadIndex(in, ci, listener);
            }
            catch (Exception e) {
                block13: {
                    try {
                        if (!(e instanceof FileNotFoundException)) {
                            System.out.println("Error reading .hdt.index, generating a new one. The error was: " + e.getMessage());
                            e.printStackTrace();
                        }
                        StopWatch st = new StopWatch();
                        this.triples.generateIndex(listener, spec, this.dictionary);
                        if (this.hdtFileName == null) break block13;
                        BufferedOutputStream out = null;
                        try {
                            out = new BufferedOutputStream(new FileOutputStream((String)versionName));
                            ci.clear();
                            this.triples.saveIndex(out, ci, listener);
                            out.close();
                            System.out.println("Index generated and saved in " + st.stopAndShow());
                        }
                        catch (IOException e2) {
                            try {
                                System.err.println("Error writing index file.");
                                e2.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                IOUtil.closeQuietly(out);
                                throw throwable;
                            }
                            IOUtil.closeQuietly(out);
                            break block13;
                        }
                        IOUtil.closeQuietly(out);
                    }
                    catch (Throwable throwable) {
                        IOUtil.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtil.closeQuietly(in);
            }
        }
        IOUtil.closeQuietly(in);
    }

    public String getBaseURI() {
        return this.baseUri;
    }

    protected void setTriples(TriplesPrivate triples) {
        this.triples = triples;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        IOUtil.closeAll(new Closeable[]{this.dictionary, this.triples});
    }

    public String toString() {
        return String.format("HDT[file=%s,#triples=%d]", this.hdtFileName, this.triples.getNumberOfElements());
    }

    public String getHDTFileName() {
        if (this.hdtFileName == null) {
            try {
                this.hdtFileName = Files.createTempFile("hdt_", ".hdt", new FileAttribute[0]).toAbsolutePath().toString();
            }
            catch (IOException e) {
                this.hdtFileName = "default.hdt";
                log.warn("Can't create default HDT file name, using '{}'", (Object)this.hdtFileName, (Object)e);
            }
        }
        return this.hdtFileName;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public void cat(String location, HDT hdt1, HDT hdt2, ProgressListener listener, Profiler profiler) throws IOException {
        ControlInformation ci2;
        if (listener != null) {
            listener.notifyProgress(0.0f, "Generating dictionary");
        }
        try (FourSectionDictionaryCat dictionaryCat = new FourSectionDictionaryCat(location);){
            FourSectionDictionaryBig dictionary;
            profiler.pushSection("catdict");
            dictionaryCat.cat(hdt1.getDictionary(), hdt2.getDictionary(), listener);
            ci2 = new ControlInformation();
            try (CountInputStream fis = new CountInputStream(new BufferedInputStream(new FileInputStream(location + "dictionary")));){
                dictionary = new FourSectionDictionaryBig(new HDTSpecification());
                fis.mark(1024);
                ci2.load(fis);
                fis.reset();
                dictionary.mapFromFile(fis, new File(location + "dictionary"), null);
            }
            if (this.dictionary != null) {
                this.dictionary.close();
            }
            this.dictionary = dictionary;
            profiler.popSection();
            profiler.pushSection("cattriples");
            if (listener != null) {
                listener.notifyProgress(0.0f, "Generating triples");
            }
            BitmapTriplesIteratorCat it = new BitmapTriplesIteratorCat(hdt1.getTriples(), hdt2.getTriples(), dictionaryCat);
            BitmapTriplesCat bitmapTriplesCat = new BitmapTriplesCat(location);
            bitmapTriplesCat.cat(it, listener);
            profiler.popSection();
        }
        profiler.pushSection("Clean and map");
        Files.delete(Paths.get(location + "P1", new String[0]));
        Files.delete(Paths.get(location + "P1Types", new String[0]));
        Files.delete(Paths.get(location + "P2", new String[0]));
        Files.delete(Paths.get(location + "P2Types", new String[0]));
        Files.delete(Paths.get(location + "SH1", new String[0]));
        Files.delete(Paths.get(location + "SH1Types", new String[0]));
        Files.delete(Paths.get(location + "SH2", new String[0]));
        Files.delete(Paths.get(location + "SH2Types", new String[0]));
        Files.delete(Paths.get(location + "S1", new String[0]));
        Files.delete(Paths.get(location + "S1Types", new String[0]));
        Files.delete(Paths.get(location + "S2", new String[0]));
        Files.delete(Paths.get(location + "S2Types", new String[0]));
        Files.delete(Paths.get(location + "O1", new String[0]));
        Files.delete(Paths.get(location + "O1Types", new String[0]));
        Files.delete(Paths.get(location + "O2", new String[0]));
        Files.delete(Paths.get(location + "O2Types", new String[0]));
        CountInputStream fis2 = new CountInputStream(new BufferedInputStream(new FileInputStream(location + "triples")));
        ci2 = new ControlInformation();
        ci2.clear();
        fis2.mark(1024);
        ci2.load(fis2);
        fis2.reset();
        this.triples = TriplesFactory.createTriples(ci2);
        this.triples.mapFromFile(fis2, new File(location + "triples"), null);
        Files.delete(Paths.get(location + "mapping_back_1", new String[0]));
        Files.delete(Paths.get(location + "mapping_back_2", new String[0]));
        Files.delete(Paths.get(location + "mapping_back_type_1", new String[0]));
        Files.delete(Paths.get(location + "mapping_back_type_2", new String[0]));
        if (listener != null) {
            listener.notifyProgress(0.0f, "Generating header");
        }
        this.header = HeaderFactory.createHeader(this.spec);
        this.populateHeaderStructure(hdt1.getBaseURI());
        long rawSize1 = HDTImpl.getRawSize(hdt1.getHeader());
        long rawSize2 = HDTImpl.getRawSize(hdt2.getHeader());
        if (rawSize1 != -1L && rawSize2 != -1L) {
            ((HeaderPrivate)this.getHeader()).insert("_:statistics", "<http://purl.org/HDT/hdt#originalSize>", String.valueOf(rawSize1 + rawSize2));
        }
        profiler.popSection();
    }

    public void catCustom(String location, HDT hdt1, HDT hdt2, ProgressListener listener, Profiler profiler) throws IOException {
        Object prefix;
        if (listener != null) {
            listener.notifyProgress(0.0f, "Generating dictionary");
        }
        try (MultipleSectionDictionaryCat dictionaryCat = new MultipleSectionDictionaryCat(location);){
            profiler.pushSection("catdict");
            dictionaryCat.cat(hdt1.getDictionary(), hdt2.getDictionary(), listener);
            Iterator ci2 = new ControlInformation();
            try (CountInputStream fis = new CountInputStream(new BufferedInputStream(new FileInputStream(location + "dictionary")));){
                HDTSpecification spec = new HDTSpecification();
                spec.set("tempDictionary.impl", "multHash");
                spec.set("dictionary.type", "dictionaryMultiObj");
                MultipleSectionDictionaryBig dictionary = new MultipleSectionDictionaryBig(spec);
                fis.mark(1024);
                ci2.load(fis);
                fis.reset();
                dictionary.mapFromFile(fis, new File(location + "dictionary"), null);
                this.dictionary = dictionary;
            }
            profiler.popSection();
            profiler.pushSection("cattriples");
            if (listener != null) {
                listener.notifyProgress(0.0f, "Generating triples");
            }
            BitmapTriplesIteratorCat it = new BitmapTriplesIteratorCat(hdt1.getTriples(), hdt2.getTriples(), dictionaryCat);
            BitmapTriplesCat bitmapTriplesCat = new BitmapTriplesCat(location);
            bitmapTriplesCat.cat(it, listener);
            profiler.popSection();
        }
        profiler.pushSection("Clean and map");
        int countSubSections = 0;
        for (CharSequence datatype : hdt1.getDictionary().getAllObjects().keySet()) {
            prefix = "sub" + countSubSections;
            if (datatype.equals(LiteralsUtils.NO_DATATYPE)) {
                prefix = datatype.toString();
            }
            Files.delete(Paths.get(location + (String)prefix + "1", new String[0]));
            Files.delete(Paths.get(location + (String)prefix + "1Types", new String[0]));
            ++countSubSections;
        }
        countSubSections = 0;
        for (CharSequence datatype : hdt2.getDictionary().getAllObjects().keySet()) {
            prefix = "sub" + countSubSections;
            if (datatype.equals(LiteralsUtils.NO_DATATYPE)) {
                prefix = datatype.toString();
            }
            Files.delete(Paths.get(location + (String)prefix + "2", new String[0]));
            Files.delete(Paths.get(location + (String)prefix + "2Types", new String[0]));
            ++countSubSections;
        }
        Files.delete(Paths.get(location + "P1", new String[0]));
        Files.delete(Paths.get(location + "P1Types", new String[0]));
        Files.delete(Paths.get(location + "P2", new String[0]));
        Files.delete(Paths.get(location + "P2Types", new String[0]));
        Files.delete(Paths.get(location + "SH1", new String[0]));
        Files.delete(Paths.get(location + "SH1Types", new String[0]));
        Files.delete(Paths.get(location + "SH2", new String[0]));
        Files.delete(Paths.get(location + "SH2Types", new String[0]));
        Files.delete(Paths.get(location + "S1", new String[0]));
        Files.delete(Paths.get(location + "S1Types", new String[0]));
        Files.delete(Paths.get(location + "S2", new String[0]));
        Files.delete(Paths.get(location + "S2Types", new String[0]));
        Files.delete(Paths.get(location + "O1", new String[0]));
        Files.delete(Paths.get(location + "O1Types", new String[0]));
        Files.delete(Paths.get(location + "O2", new String[0]));
        Files.delete(Paths.get(location + "O2Types", new String[0]));
        try (CountInputStream fis2 = new CountInputStream(new BufferedInputStream(new FileInputStream(location + "triples")));){
            ControlInformation ci2 = new ControlInformation();
            ci2.clear();
            fis2.mark(1024);
            ci2.load(fis2);
            fis2.reset();
            this.triples = TriplesFactory.createTriples(ci2);
            this.triples.mapFromFile(fis2, new File(location + "triples"), null);
        }
        Files.delete(Paths.get(location + "mapping_back_1", new String[0]));
        Files.delete(Paths.get(location + "mapping_back_2", new String[0]));
        Files.delete(Paths.get(location + "mapping_back_type_1", new String[0]));
        Files.delete(Paths.get(location + "mapping_back_type_2", new String[0]));
        if (listener != null) {
            listener.notifyProgress(0.0f, "Generating header");
        }
        this.header = HeaderFactory.createHeader(this.spec);
        this.populateHeaderStructure(hdt1.getBaseURI());
        long rawSize1 = HDTImpl.getRawSize(hdt1.getHeader());
        long rawSize2 = HDTImpl.getRawSize(hdt2.getHeader());
        if (rawSize1 != -1L && rawSize2 != -1L) {
            ((HeaderPrivate)this.getHeader()).insert("_:statistics", "<http://purl.org/HDT/hdt#originalSize>", String.valueOf(rawSize1 + rawSize2));
        }
        profiler.popSection();
    }

    public void diff(HDT hdt1, HDT hdt2, ProgressListener listener, Profiler profiler) throws IOException {
        ModifiableBitmap bitmap = BitmapFactory.createRWBitmap((long)hdt1.getTriples().getNumberOfElements());
        BitmapTriplesIteratorDiff iterator = new BitmapTriplesIteratorDiff(hdt1, hdt2, bitmap);
        profiler.pushSection("fill bitmap");
        iterator.fillBitmap();
        profiler.popSection();
        this.diffBit(this.getHDTFileName(), hdt1, (Bitmap)bitmap, listener, profiler);
    }

    public void diffBit(String location, HDT hdt, Bitmap deleteBitmap, ProgressListener listener, Profiler profiler) throws IOException {
        IntermediateListener il = new IntermediateListener(listener);
        log.debug("Generating Dictionary...");
        il.notifyProgress(0.0f, "Generating Dictionary...");
        profiler.pushSection("diffdict");
        IteratorTripleID hdtIterator = hdt.getTriples().searchAll();
        DictionaryEntriesDiff iter = DictionaryEntriesDiff.createForType(hdt.getDictionary(), hdt, deleteBitmap, hdtIterator);
        iter.loadBitmaps();
        Map<CharSequence, ModifiableBitmap> bitmaps = iter.getBitmaps();
        try (DictionaryDiff diff = DictionaryFactory.createDictionaryDiff(hdt.getDictionary(), location);){
            diff.diff(hdt.getDictionary(), bitmaps, listener);
            ControlInformation ci2 = new ControlInformation();
            try (CountInputStream fis = new CountInputStream(new BufferedInputStream(new FileInputStream(location + "dictionary")));){
                fis.mark(1024);
                ci2.load(fis);
                fis.reset();
                DictionaryPrivate dictionary = DictionaryFactory.createDictionary(ci2);
                dictionary.mapFromFile(fis, new File(location + "dictionary"), null);
                this.dictionary = dictionary;
            }
            profiler.popSection();
            log.debug("Generating Triples...");
            profiler.pushSection("difftriples");
            il.notifyProgress(40.0f, "Generating Triples...");
            BitmapTriplesIteratorMapDiff mapIter = new BitmapTriplesIteratorMapDiff(hdt, deleteBitmap, diff);
            BitmapTriples triples = new BitmapTriples(this.spec);
            triples.load(mapIter, listener);
            this.triples = triples;
        }
        profiler.popSection();
        profiler.pushSection("Clean and map");
        log.debug("Clear data...");
        il.notifyProgress(80.0f, "Clear data...");
        if (!(hdt.getDictionary() instanceof FourSectionDictionary)) {
            int count = 0;
            for (CharSequence key : this.dictionary.getAllObjects().keySet()) {
                Object subPrefix = "sub" + count;
                if (key.equals(LiteralsUtils.NO_DATATYPE)) {
                    subPrefix = key;
                }
                Files.delete(Paths.get(location + (CharSequence)subPrefix, new String[0]));
                Files.delete(Paths.get(location + (CharSequence)subPrefix + "Types", new String[0]));
                ++count;
            }
        }
        Files.delete(Paths.get(location + "predicate", new String[0]));
        Files.delete(Paths.get(location + "predicateTypes", new String[0]));
        Files.delete(Paths.get(location + "subject", new String[0]));
        Files.delete(Paths.get(location + "subjectTypes", new String[0]));
        Files.delete(Paths.get(location + "object", new String[0]));
        Files.delete(Paths.get(location + "objectTypes", new String[0]));
        Files.delete(Paths.get(location + "shared", new String[0]));
        Files.delete(Paths.get(location + "sharedTypes", new String[0]));
        Files.delete(Paths.get(location + "backTypes", new String[0]));
        Files.delete(Paths.get(location + "back", new String[0]));
        Files.deleteIfExists(Paths.get(location + "P", new String[0]));
        Files.deleteIfExists(Paths.get(location + "S", new String[0]));
        Files.deleteIfExists(Paths.get(location + "O", new String[0]));
        Files.deleteIfExists(Paths.get(location + "SH_S", new String[0]));
        Files.deleteIfExists(Paths.get(location + "SH_O", new String[0]));
        log.debug("Set header...");
        il.notifyProgress(90.0f, "Set header...");
        this.header = HeaderFactory.createHeader(this.spec);
        this.populateHeaderStructure(hdt.getBaseURI());
        log.debug("Diff completed.");
        il.notifyProgress(100.0f, "Diff completed...");
        profiler.popSection();
    }
}

