/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryFactory;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.impl.CompressFourSectionDictionary;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.impl.HDTBase;
import org.rdfhdt.hdt.hdt.impl.HDTImpl;
import org.rdfhdt.hdt.hdt.impl.WriteHDTImpl;
import org.rdfhdt.hdt.hdt.impl.diskimport.CompressTripleMapper;
import org.rdfhdt.hdt.hdt.impl.diskimport.CompressionResult;
import org.rdfhdt.hdt.hdt.impl.diskimport.MapOnCallHDT;
import org.rdfhdt.hdt.hdt.impl.diskimport.TripleCompressionResult;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.iterator.utils.AsyncIteratorFetcher;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.Profiler;
import org.rdfhdt.hdt.util.StringUtil;
import org.rdfhdt.hdt.util.concurrent.KWayMerger;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.compress.MapCompressTripleMerger;
import org.rdfhdt.hdt.util.io.compress.TripleGenerator;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class HDTDiskImporter
implements Closeable {
    private final HDTOptions hdtFormat;
    private final MultiThreadListener listener;
    private final String compressMode;
    private final String futureHDTLocation;
    private final Path futureHDTLocationPath;
    private final CloseSuppressPath basePath;
    private final long chunkSize;
    private final int ways;
    private final int workers;
    private final int bufferSize;
    private final boolean mapHDT;
    private final boolean debugHDTBuilding;
    private final Profiler profiler;
    private final HDTBase<? extends HeaderPrivate, ? extends DictionaryPrivate, ? extends TriplesPrivate> hdt;
    private long rawSize;
    private boolean dict = false;
    private boolean header = false;
    private boolean triples = false;

    public static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory());
    }

    static long getMaxChunkSize(int workers) {
        return (long)((double)HDTDiskImporter.getAvailableMemory() * 0.85 / (4.5 * (double)workers));
    }

    public HDTDiskImporter(HDTOptions hdtFormat, ProgressListener progressListener, String baseURI) throws IOException {
        this.hdtFormat = hdtFormat;
        this.listener = ListenerUtil.multiThreadListener(progressListener);
        this.compressMode = hdtFormat.get("loader.disk.compressMode", "compressionComplete");
        this.workers = (int)hdtFormat.getInt("loader.disk.compressWorker", Runtime.getRuntime()::availableProcessors);
        if (this.workers <= 0) {
            throw new IllegalArgumentException("Number of workers should be positive!");
        }
        this.chunkSize = hdtFormat.getInt("loader.disk.chunkSize", () -> HDTDiskImporter.getMaxChunkSize(this.workers));
        if (this.chunkSize < 0L) {
            throw new IllegalArgumentException("Negative chunk size!");
        }
        long maxFileOpenedLong = hdtFormat.getInt("loader.disk.maxFileOpen", 1024L);
        if (maxFileOpenedLong < 0L || maxFileOpenedLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxFileOpened should be positive!");
        }
        int maxFileOpened = (int)maxFileOpenedLong;
        long kwayLong = hdtFormat.getInt("loader.disk.kway", () -> Math.max(1, BitUtil.log2(maxFileOpened / this.workers)));
        if (kwayLong <= 0L || kwayLong > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("kway can't be negative!");
        }
        this.ways = (int)kwayLong;
        long bufferSizeLong = hdtFormat.getInt("loader.disk.fileBufferSize", 8192L);
        if (bufferSizeLong > 0x7FFFFFFAL || bufferSizeLong <= 0L) {
            throw new IllegalArgumentException("Buffer size can't be negative or bigger than the size of an array!");
        }
        this.bufferSize = (int)bufferSizeLong;
        String baseNameOpt = hdtFormat.get("loader.disk.location");
        this.futureHDTLocation = hdtFormat.get("loader.disk.futureHDTLocation");
        this.futureHDTLocationPath = this.futureHDTLocation == null ? null : Path.of(this.futureHDTLocation, new String[0]);
        this.profiler = Profiler.createOrLoadSubSection((String)"doGenerateHDTDisk", (HDTOptions)hdtFormat, (boolean)true);
        try {
            this.basePath = baseNameOpt == null || baseNameOpt.isEmpty() ? CloseSuppressPath.of(Files.createTempDirectory("hdt-java-generate-disk", new FileAttribute[0])) : CloseSuppressPath.of(baseNameOpt, new String[0]);
            this.basePath.closeWithDeleteRecurse();
            this.mapHDT = this.futureHDTLocation != null && !this.futureHDTLocation.isEmpty();
            this.debugHDTBuilding = hdtFormat.getBoolean("debug.disk.build");
            this.basePath.mkdirs();
            this.hdt = !this.mapHDT ? new HDTImpl(hdtFormat) : new WriteHDTImpl(hdtFormat, this.basePath.resolve("maphdt"), this.bufferSize);
            this.hdt.setBaseUri(baseURI);
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                this.profiler.close();
                throw throwable;
            }
        }
    }

    public CompressTripleMapper compressDictionary(Iterator<TripleString> iterator) throws ParserException, IOException {
        CompressionResult compressionResult;
        if (this.dict) {
            throw new IllegalArgumentException("Dictionary already built! Use another importer instance!");
        }
        this.listener.notifyProgress(0.0f, "Sorting sections with chunk of size: " + StringUtil.humanReadableByteCount(this.chunkSize, true) + "B with " + this.ways + "ways and " + this.workers + " worker(s)");
        AsyncIteratorFetcher<TripleString> source = new AsyncIteratorFetcher<TripleString>(iterator);
        this.profiler.pushSection("section compression");
        try {
            compressionResult = DictionaryFactory.createSectionCompressor(this.hdtFormat, this.basePath.resolve("sectionCompression"), source, this.listener, this.bufferSize, this.chunkSize, 1 << this.ways, this.hdtFormat.getBoolean("debug.disk.slow.stream2")).compress(this.workers, this.compressMode);
        }
        catch (InterruptedException | KWayMerger.KWayMergerException e) {
            throw new ParserException((Throwable)e);
        }
        this.profiler.popSection();
        this.listener.unregisterAllThreads();
        this.listener.notifyProgress(20.0f, "Create sections and triple mapping");
        this.profiler.pushSection("dictionary write");
        Dictionary dictionary = this.hdt.getDictionary();
        CompressTripleMapper mapper = new CompressTripleMapper(this.basePath, compressionResult.getTripleCount(), this.chunkSize);
        try (CompressFourSectionDictionary modifiableDictionary = new CompressFourSectionDictionary(compressionResult, mapper, (ProgressListener)this.listener, this.debugHDTBuilding);){
            dictionary.loadAsync(modifiableDictionary, (ProgressListener)this.listener);
        }
        catch (InterruptedException e) {
            throw new ParserException((Throwable)e);
        }
        this.profiler.popSection();
        compressionResult.delete();
        this.rawSize = compressionResult.getRawSize();
        mapper.setShared(dictionary.getNshared());
        this.dict = true;
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressTriples(CompressTripleMapper mapper) throws ParserException, IOException {
        TripleCompressionResult tripleCompressionResult;
        if (this.triples) {
            throw new IllegalArgumentException("Triples already built! Use another importer instance!");
        }
        this.listener.notifyProgress(40.0f, "Create mapped and sort triple file");
        Triples triples = this.hdt.getTriples();
        TripleComponentOrder order = triples.getOrder();
        this.profiler.pushSection("triple compression/map");
        try {
            MapCompressTripleMerger tripleMapper = new MapCompressTripleMerger(this.basePath.resolve("tripleMapper"), new AsyncIteratorFetcher<TripleID>(new TripleGenerator(mapper.getTripleCount())), mapper, this.listener, order, this.bufferSize, this.chunkSize, 1 << this.ways);
            tripleCompressionResult = tripleMapper.merge(this.workers, this.compressMode);
        }
        catch (InterruptedException | KWayMerger.KWayMergerException e) {
            throw new ParserException((Throwable)e);
        }
        this.profiler.popSection();
        this.listener.unregisterAllThreads();
        this.profiler.pushSection("bit triple creation");
        try {
            TempTriples tempTriples = tripleCompressionResult.getTriples();
            IntermediateListener il = new IntermediateListener((ProgressListener)this.listener);
            il.setRange(80.0f, 90.0f);
            il.setPrefix("Create bit triples: ");
            il.notifyProgress(0.0f, "create triples");
            triples.load(tempTriples, il);
            tempTriples.close();
            mapper.delete();
        }
        finally {
            tripleCompressionResult.close();
        }
        this.profiler.popSection();
        this.triples = true;
    }

    public void createHeader() {
        if (this.header) {
            throw new IllegalArgumentException("Header already built! Use another importer instance!");
        }
        this.profiler.pushSection("header creation");
        this.listener.notifyProgress(90.0f, "Create HDT header");
        this.hdt.populateHeaderStructure(this.hdt.getBaseURI());
        this.hdt.getHeader().insert("_:statistics", "<http://purl.org/HDT/hdt#originalSize>", this.rawSize);
        this.profiler.popSection();
        this.header = true;
    }

    public HDT convertToHDT() throws IOException {
        if (!this.dict) {
            throw new IllegalArgumentException("Dictionary missing, can't create HDT");
        }
        if (!this.triples) {
            throw new IllegalArgumentException("Triples missing, can't create HDT");
        }
        if (!this.header) {
            throw new IllegalArgumentException("Header missing, can't create HDT");
        }
        if (this.mapHDT) {
            this.profiler.pushSection("map to hdt");
            try {
                this.hdt.saveToHDT(this.futureHDTLocation, (ProgressListener)this.listener);
            }
            finally {
                this.hdt.close();
            }
            IntermediateListener il = new IntermediateListener((ProgressListener)this.listener);
            il.setPrefix("Map HDT: ");
            il.setRange(95.0f, 100.0f);
            il.notifyProgress(0.0f, "start");
            try {
                MapOnCallHDT mapOnCallHDT = new MapOnCallHDT(this.futureHDTLocationPath);
                return mapOnCallHDT;
            }
            finally {
                this.profiler.popSection();
            }
        }
        this.listener.notifyProgress(100.0f, "HDT completed");
        return this.hdt;
    }

    public HDT runAllSteps(Iterator<TripleString> iterator) throws IOException, ParserException {
        CompressTripleMapper mapper = this.compressDictionary(iterator);
        this.compressTriples(mapper);
        this.createHeader();
        return this.convertToHDT();
    }

    @Override
    public void close() throws IOException {
        try {
            this.profiler.stop();
            this.profiler.writeProfiling();
            this.listener.notifyProgress(100.0f, "Clearing disk");
        }
        finally {
            try {
                this.basePath.close();
            }
            finally {
                this.profiler.close();
            }
        }
    }
}

