/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.hdt.HDTPrivate;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleString;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.triples.TriplesPrivate;
import org.rdfhdt.hdt.util.StringUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;

public abstract class HDTBase<H extends Header, D extends DictionaryPrivate, T extends TriplesPrivate>
implements HDTPrivate {
    protected final HDTOptions spec;
    protected H header;
    protected D dictionary;
    protected T triples;

    protected HDTBase(HDTOptions spec) {
        this.spec = HDTOptions.ofNullable((HDTOptions)spec);
    }

    public abstract void setBaseUri(String var1);

    public abstract boolean isClosed();

    public H getHeader() {
        return this.header;
    }

    public D getDictionary() {
        return this.dictionary;
    }

    public T getTriples() {
        return this.triples;
    }

    public long size() {
        if (this.isClosed()) {
            return 0L;
        }
        return this.dictionary.size() + this.triples.size();
    }

    public HDTOptions getSpec() {
        return this.spec;
    }

    public void saveToHDT(OutputStream output, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        IntermediateListener iListener = new IntermediateListener(listener);
        ci.clear();
        ci.setType(ControlInfo.Type.GLOBAL);
        ci.setFormat("<http://purl.org/HDT/hdt#HDTv1>");
        ci.save(output);
        ci.clear();
        ci.setType(ControlInfo.Type.HEADER);
        this.header.save(output, (ControlInfo)ci, (ProgressListener)iListener);
        ci.clear();
        ci.setType(ControlInfo.Type.DICTIONARY);
        this.dictionary.save(output, ci, iListener);
        ci.clear();
        ci.setType(ControlInfo.Type.TRIPLES);
        this.triples.save(output, ci, iListener);
    }

    public static long getRawSize(Header header) {
        try {
            IteratorTripleString rawSize1 = header.search((CharSequence)"_:statistics", (CharSequence)"<http://purl.org/HDT/hdt#originalSize>", (CharSequence)"");
            if (!rawSize1.hasNext()) {
                return -1L;
            }
            CharSequence obj = ((TripleString)rawSize1.next()).getObject();
            return Long.parseLong(obj, 1, obj.length() - 1, 10);
        }
        catch (NotFoundException e) {
            return -1L;
        }
    }

    @Override
    public void populateHeaderStructure(String baseUri) {
        if (baseUri == null || baseUri.length() == 0) {
            throw new IllegalArgumentException("baseURI cannot be empty");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Cannot add header to a closed HDT.");
        }
        H header = this.getHeader();
        Dictionary dictionary = this.getDictionary();
        Triples triples = this.getTriples();
        header.insert((CharSequence)baseUri, (CharSequence)"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", (CharSequence)"<http://purl.org/HDT/hdt#Dataset>");
        header.insert((CharSequence)baseUri, (CharSequence)"<http://www.w3.org/1999/02/22-rdf-syntax-ns#type>", (CharSequence)"<http://rdfs.org/ns/void#Dataset>");
        header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#triples>", triples.getNumberOfElements());
        header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#properties>", dictionary.getNpredicates());
        header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#distinctSubjects>", dictionary.getNsubjects());
        header.insert((CharSequence)baseUri, (CharSequence)"<http://rdfs.org/ns/void#distinctObjects>", dictionary.getNobjects());
        String formatNode = "_:format";
        String dictNode = "_:dictionary";
        String triplesNode = "_:triples";
        String statisticsNode = "_:statistics";
        String publicationInfoNode = "_:publicationInformation";
        header.insert((CharSequence)baseUri, (CharSequence)"<http://purl.org/HDT/hdt#formatInformation>", (CharSequence)formatNode);
        header.insert((CharSequence)formatNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionary>", (CharSequence)dictNode);
        header.insert((CharSequence)formatNode, (CharSequence)"<http://purl.org/HDT/hdt#triples>", (CharSequence)triplesNode);
        header.insert((CharSequence)baseUri, (CharSequence)"<http://purl.org/HDT/hdt#statisticalInformation>", (CharSequence)statisticsNode);
        header.insert((CharSequence)baseUri, (CharSequence)"<http://purl.org/HDT/hdt#publicationInformation>", (CharSequence)publicationInfoNode);
        dictionary.populateHeader(header, dictNode);
        triples.populateHeader(header, triplesNode);
        header.insert((CharSequence)statisticsNode, (CharSequence)"<http://purl.org/HDT/hdt#hdtSize>", this.getDictionary().size() + this.getTriples().size());
        header.insert((CharSequence)publicationInfoNode, (CharSequence)"<http://purl.org/dc/terms/issued>", (CharSequence)StringUtil.formatDate(new Date()));
    }
}

