/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.hdt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.kcat.KCatImpl;
import org.rdfhdt.hdt.enums.CompressionType;
import org.rdfhdt.hdt.enums.RDFNotation;
import org.rdfhdt.hdt.exceptions.NotFoundException;
import org.rdfhdt.hdt.exceptions.ParserException;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTFactory;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTPrivate;
import org.rdfhdt.hdt.hdt.HDTSupplier;
import org.rdfhdt.hdt.hdt.TempHDT;
import org.rdfhdt.hdt.hdt.TempHDTImporter;
import org.rdfhdt.hdt.hdt.impl.HDTDiskImporter;
import org.rdfhdt.hdt.hdt.impl.HDTImpl;
import org.rdfhdt.hdt.hdt.impl.TempHDTImporterOnePass;
import org.rdfhdt.hdt.hdt.impl.TempHDTImporterTwoPass;
import org.rdfhdt.hdt.hdt.impl.diskimport.CatTreeImpl;
import org.rdfhdt.hdt.hdt.writer.TripleWriterHDT;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.header.HeaderUtil;
import org.rdfhdt.hdt.iterator.utils.MapIterator;
import org.rdfhdt.hdt.iterator.utils.PipedCopyIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.rdf.RDFFluxStop;
import org.rdfhdt.hdt.rdf.RDFParserCallback;
import org.rdfhdt.hdt.rdf.RDFParserFactory;
import org.rdfhdt.hdt.rdf.TripleWriter;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.Profiler;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDTManagerImpl
extends HDTManager {
    private static final Logger logger = LoggerFactory.getLogger(HDTManagerImpl.class);

    public HDTOptions doReadOptions(String file) throws IOException {
        return new HDTSpecification(file);
    }

    public static HDT loadOrMapHDT(String hdtFileName, ProgressListener listener, HDTOptions spec) throws IOException {
        String loadingMethod = spec.get("loader.hdt.type");
        if (loadingMethod == null || loadingMethod.isEmpty() || "map".equals(loadingMethod)) {
            return HDTManagerImpl.mapHDT((String)hdtFileName, (ProgressListener)listener, (HDTOptions)spec);
        }
        if ("load".equals(loadingMethod)) {
            return HDTManagerImpl.loadHDT((String)hdtFileName, (ProgressListener)listener, (HDTOptions)spec);
        }
        throw new IllegalArgumentException("Bad loading method: " + loadingMethod);
    }

    public HDT doLoadHDT(String hdtFileName, ProgressListener listener, HDTOptions spec) throws IOException {
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromHDT(hdtFileName, listener);
        return hdt;
    }

    protected HDT doMapHDT(String hdtFileName, ProgressListener listener, HDTOptions spec) throws IOException {
        HDTImpl hdt = new HDTImpl(spec);
        hdt.mapFromHDT(new File(hdtFileName), 0L, listener);
        return hdt;
    }

    public HDT doLoadHDT(InputStream hdtFile, ProgressListener listener, HDTOptions spec) throws IOException {
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromHDT(hdtFile, listener);
        return hdt;
    }

    public HDT doLoadIndexedHDT(String hdtFileName, ProgressListener listener, HDTOptions spec) throws IOException {
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromHDT(hdtFileName, listener);
        hdt.loadOrCreateIndex(listener, spec);
        return hdt;
    }

    public HDT doMapIndexedHDT(String hdtFileName, ProgressListener listener, HDTOptions spec) throws IOException {
        HDTImpl hdt = new HDTImpl(spec);
        hdt.mapFromHDT(new File(hdtFileName), 0L, listener);
        hdt.loadOrCreateIndex(listener, spec);
        return hdt;
    }

    public HDT doLoadIndexedHDT(InputStream hdtFile, ProgressListener listener, HDTOptions spec) throws IOException {
        HDTImpl hdt = new HDTImpl(spec);
        hdt.loadFromHDT(hdtFile, listener);
        hdt.loadOrCreateIndex(listener, spec);
        return hdt;
    }

    public HDT doIndexedHDT(HDT hdt, ProgressListener listener) throws IOException {
        ((HDTPrivate)hdt).loadOrCreateIndex(listener, HDTOptions.of());
        return hdt;
    }

    private RDFFluxStop readFluxStopOrSizeLimit(HDTOptions spec) {
        return spec.getFluxStop("rdffluxstop.type", () -> {
            String loaderType = spec.get("loader.cattree.loadertype");
            if (!"disk".equals(loaderType)) {
                return RDFFluxStop.sizeLimit((long)(HDTManagerImpl.getMaxChunkSize() / 4L));
            }
            long triplesCount = HDTManagerImpl.findBestMemoryChunkDiskMapTreeCat();
            double factor = spec.getDouble("loader.cattree.memoryFaultFactor", 1.4);
            if (factor <= 0.0) {
                throw new IllegalArgumentException("loader.cattree.memoryFaultFactor can't have a negative or 0 value!");
            }
            return RDFFluxStop.countLimit((long)Math.max(128L, (long)((double)triplesCount * factor)));
        });
    }

    public HDT doGenerateHDT(String rdfFileName, String baseURI, RDFNotation rdfNotation, HDTOptions spec, ProgressListener listener) throws IOException, ParserException {
        TempHDTImporter loader;
        String loaderType = spec.get("loader.type");
        if ("disk".equals(loaderType)) {
            return this.doGenerateHDTDisk(rdfFileName, baseURI, rdfNotation, CompressionType.guess((String)rdfFileName), spec, listener);
        }
        if ("cat".equals(loaderType)) {
            return this.doHDTCatTree(this.readFluxStopOrSizeLimit(spec), HDTSupplier.fromSpec((HDTOptions)spec), rdfFileName, baseURI, rdfNotation, spec, listener);
        }
        if ("two-pass".equals(loaderType)) {
            loader = new TempHDTImporterTwoPass(spec);
        } else {
            if (loaderType != null && !"one-pass".equals(loaderType)) {
                logger.warn("Used the option {} with value {}, which isn't recognize, using default value {}", new Object[]{"loader.type", loaderType, "one-pass"});
            }
            loader = new TempHDTImporterOnePass(spec);
        }
        try (TempHDT modHdt = loader.loadFromRDF(spec, rdfFileName, baseURI, rdfNotation, listener);){
            HDTImpl hdt = new HDTImpl(spec);
            hdt.loadFromModifiableHDT(modHdt, listener);
            hdt.populateHeaderStructure(modHdt.getBaseURI());
            try {
                long originalSize = HeaderUtil.getPropertyLong((Header)modHdt.getHeader(), (String)"_:statistics", (String)"<http://purl.org/HDT/hdt#originalSize>");
                ((HeaderPrivate)hdt.getHeader()).insert("_:statistics", "<http://purl.org/HDT/hdt#originalSize>", originalSize);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            HDTImpl hDTImpl = hdt;
            return hDTImpl;
        }
    }

    public HDT doGenerateHDT(InputStream fileStream, String baseURI, RDFNotation rdfNotation, CompressionType compressionType, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        fileStream = IOUtil.asUncompressed(fileStream, compressionType);
        RDFParserCallback parser = RDFParserFactory.getParserCallback(rdfNotation);
        try (PipedCopyIterator<TripleString> iterator = RDFParserFactory.readAsIterator(parser, fileStream, baseURI, true, rdfNotation);){
            HDT hDT = this.doGenerateHDT(iterator, baseURI, hdtFormat, listener);
            return hDT;
        }
    }

    public HDT doGenerateHDT(Iterator<TripleString> triples, String baseURI, HDTOptions spec, ProgressListener listener) throws IOException {
        String loaderType = spec.get("loader.type");
        if ("disk".equals(loaderType)) {
            try {
                return this.doGenerateHDTDisk(triples, baseURI, spec, listener);
            }
            catch (ParserException e) {
                throw new RuntimeException(e);
            }
        }
        if ("cat".equals(loaderType)) {
            try {
                return this.doHDTCatTree(this.readFluxStopOrSizeLimit(spec), HDTSupplier.fromSpec((HDTOptions)spec), triples, baseURI, spec, listener);
            }
            catch (ParserException e) {
                throw new RuntimeException(e);
            }
        }
        if (loaderType != null) {
            if ("two-pass".equals(loaderType)) {
                logger.warn("Used the option {} with value {}, which isn't available for stream generation, using default value {}", new Object[]{"loader.type", loaderType, "one-pass"});
            } else if (!"one-pass".equals(loaderType)) {
                logger.warn("Used the option {} with value {}, which isn't recognize, using default value {}", new Object[]{"loader.type", loaderType, "one-pass"});
            }
        }
        TempHDTImporterOnePass loader = new TempHDTImporterOnePass(spec);
        try (TempHDT modHdt = loader.loadFromTriples(spec, triples, baseURI, listener);){
            HDTImpl hdt = new HDTImpl(spec);
            hdt.loadFromModifiableHDT(modHdt, listener);
            hdt.populateHeaderStructure(modHdt.getBaseURI());
            try {
                long originalSize = HeaderUtil.getPropertyLong((Header)modHdt.getHeader(), (String)"_:statistics", (String)"<http://purl.org/HDT/hdt#originalSize>");
                ((HeaderPrivate)hdt.getHeader()).insert("_:statistics", "<http://purl.org/HDT/hdt#originalSize>", originalSize);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            HDTImpl hDTImpl = hdt;
            return hDTImpl;
        }
    }

    public HDT doGenerateHDTDisk(String rdfFileName, String baseURI, RDFNotation rdfNotation, CompressionType compressionType, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        try (InputStream stream = IOUtil.getFileInputStream(rdfFileName, false);){
            HDT hDT = this.doGenerateHDTDisk(stream, baseURI, rdfNotation, compressionType, hdtFormat, listener);
            return hDT;
        }
    }

    public HDT doGenerateHDTDisk(InputStream fileStream, String baseURI, RDFNotation rdfNotation, CompressionType compressionType, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        fileStream = IOUtil.asUncompressed(fileStream, compressionType);
        RDFParserCallback parser = RDFParserFactory.getParserCallback(rdfNotation, hdtFormat);
        try (PipedCopyIterator<TripleString> iterator = RDFParserFactory.readAsIterator(parser, fileStream, baseURI, true, rdfNotation);){
            HDT hDT = this.doGenerateHDTDisk0(iterator, true, baseURI, hdtFormat, listener);
            return hDT;
        }
    }

    static long getMaxChunkSize() {
        Runtime runtime = Runtime.getRuntime();
        return (long)((double)(runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) * 0.85);
    }

    private static long findBestMemoryChunkDiskMapTreeCat() {
        int shift;
        Runtime runtime = Runtime.getRuntime();
        long maxRam = (long)((double)(runtime.maxMemory() - (runtime.totalMemory() - runtime.freeMemory())) * 0.85) / 3L;
        for (shift = 0; shift != 63 && (1L << shift) * (long)BitUtil.log2(1L << shift) < maxRam; ++shift) {
        }
        return maxRam / (long)shift;
    }

    public HDT doGenerateHDTDisk(Iterator<TripleString> iterator, String baseURI, HDTOptions hdtFormat, ProgressListener progressListener) throws IOException, ParserException {
        return this.doGenerateHDTDisk0(iterator, hdtFormat.getBoolean("loader.disk.noCopyIterator"), baseURI, hdtFormat, progressListener);
    }

    private HDT doGenerateHDTDisk0(Iterator<TripleString> iterator, boolean copyIterator, String baseURI, HDTOptions hdtFormat, ProgressListener progressListener) throws IOException, ParserException {
        try (HDTDiskImporter hdtDiskImporter = new HDTDiskImporter(hdtFormat, progressListener, baseURI);){
            if (copyIterator) {
                HDT hDT = hdtDiskImporter.runAllSteps(iterator);
                return hDT;
            }
            HDT hDT = hdtDiskImporter.runAllSteps(new MapIterator<TripleString, TripleString>(iterator, TripleString::tripleToString));
            return hDT;
        }
    }

    protected TripleWriter doGetHDTWriter(OutputStream out, String baseURI, HDTOptions hdtFormat) {
        return new TripleWriterHDT(baseURI, hdtFormat, out);
    }

    protected TripleWriter doGetHDTWriter(String outFile, String baseURI, HDTOptions hdtFormat) throws IOException {
        return new TripleWriterHDT(baseURI, hdtFormat, outFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HDT doHDTCat(String location, String hdtFileName1, String hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        try (HDT hdt1 = HDTManagerImpl.loadOrMapHDT(hdtFileName1, listener, hdtFormat);){
            HDTImpl hDTImpl;
            block24: {
                HDT hdt2 = HDTManagerImpl.loadOrMapHDT(hdtFileName2, listener, hdtFormat);
                try {
                    HDTImpl hdt = new HDTImpl(hdtFormat);
                    try (Profiler profiler = Profiler.createOrLoadSubSection((String)"hdtCat", (HDTOptions)hdtFormat, (boolean)false);){
                        try {
                            if (hdt1.getDictionary() instanceof MultipleSectionDictionary && hdt2.getDictionary() instanceof MultipleSectionDictionary) {
                                hdt.catCustom(location, hdt1, hdt2, listener, profiler);
                            } else {
                                hdt.cat(location, hdt1, hdt2, listener, profiler);
                            }
                        }
                        finally {
                            profiler.stop();
                            profiler.writeProfiling();
                        }
                    }
                    hDTImpl = hdt;
                    if (hdt2 == null) break block24;
                }
                catch (Throwable throwable) {
                    if (hdt2 != null) {
                        try {
                            hdt2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hdt2.close();
            }
            return hDTImpl;
        }
    }

    public HDT doHDTDiff(String hdtFileName1, String hdtFileName2, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        try (HDT hdt1 = HDTManagerImpl.loadOrMapHDT(hdtFileName1, listener, hdtFormat);){
            HDTImpl hDTImpl;
            block19: {
                HDT hdt2 = HDTManagerImpl.loadOrMapHDT(hdtFileName2, listener, hdtFormat);
                try {
                    HDTImpl hdt = new HDTImpl(hdtFormat);
                    try (Profiler profiler = Profiler.createOrLoadSubSection((String)"hdtDiff", (HDTOptions)hdtFormat, (boolean)true);){
                        hdt.diff(hdt1, hdt2, listener, profiler);
                    }
                    hDTImpl = hdt;
                    if (hdt2 == null) break block19;
                }
                catch (Throwable throwable) {
                    if (hdt2 != null) {
                        try {
                            hdt2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                hdt2.close();
            }
            return hDTImpl;
        }
    }

    protected HDT doHDTDiffBit(String location, String hdtFileName, Bitmap deleteBitmap, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        try (HDT hdtOriginal = HDTManagerImpl.loadOrMapHDT(hdtFileName, listener, hdtFormat);){
            HDTImpl hdt = new HDTImpl(hdtFormat);
            try (Profiler profiler = Profiler.createOrLoadSubSection((String)"hdtDiffBit", (HDTOptions)hdtFormat, (boolean)true);){
                hdt.diffBit(location, hdtOriginal, deleteBitmap, listener, profiler);
            }
            catch (Throwable t) {
                try {
                    throw t;
                }
                catch (Throwable throwable) {
                    hdt.close();
                    throw throwable;
                }
            }
            HDTImpl hDTImpl = hdt;
            return hDTImpl;
        }
    }

    protected HDT doHDTCatTree(RDFFluxStop fluxStop, HDTSupplier supplier, String filename, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        try (InputStream is = IOUtil.getFileInputStream(filename);){
            HDT hDT = this.doHDTCatTree(fluxStop, supplier, is, baseURI, rdfNotation, hdtFormat, listener);
            return hDT;
        }
    }

    protected HDT doHDTCatTree(RDFFluxStop fluxStop, HDTSupplier supplier, InputStream stream, String baseURI, RDFNotation rdfNotation, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        RDFParserCallback parser = RDFParserFactory.getParserCallback(rdfNotation, hdtFormat);
        try (PipedCopyIterator<TripleString> iterator = RDFParserFactory.readAsIterator(parser, stream, baseURI, true, rdfNotation);){
            HDT hDT = this.doHDTCatTree(fluxStop, supplier, iterator, baseURI, hdtFormat, listener);
            return hDT;
        }
    }

    protected HDT doHDTCatTree(RDFFluxStop fluxStop, HDTSupplier supplier, Iterator<TripleString> iterator, String baseURI, HDTOptions hdtFormat, ProgressListener listener) throws IOException, ParserException {
        try (CatTreeImpl tree = new CatTreeImpl(hdtFormat);){
            HDT hDT = tree.doGeneration(fluxStop, supplier, iterator, baseURI, listener);
            return hDT;
        }
    }

    protected HDT doHDTCat(List<String> hdtFileNames, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        if (hdtFileNames.isEmpty()) {
            return HDTFactory.createHDT(hdtFormat);
        }
        if (hdtFileNames.size() == 1) {
            return HDTManagerImpl.loadOrMapHDT(hdtFileNames.get(0), listener, hdtFormat);
        }
        try (KCatImpl kCat = new KCatImpl(hdtFileNames, hdtFormat, listener);){
            HDT hDT = kCat.cat();
            return hDT;
        }
    }

    protected HDT doHDTDiffBitCat(List<String> hdtFileNames, List<? extends Bitmap> deleteBitmaps, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        if (hdtFileNames.isEmpty()) {
            return HDTFactory.createHDT(hdtFormat);
        }
        if (hdtFileNames.size() != deleteBitmaps.size()) {
            throw new IllegalArgumentException("hdtFileNames.size() != deleteBitmaps.size()");
        }
        try (KCatImpl kCat = new KCatImpl(hdtFileNames, deleteBitmaps, hdtFormat, listener);){
            HDT hDT = kCat.cat();
            return hDT;
        }
    }

    private static class HDTFile {
        private final Path hdtFile;
        private final long chunks;

        public HDTFile(Path hdtFile, long chunks) {
            this.hdtFile = hdtFile;
            this.chunks = chunks;
        }

        public long getChunks() {
            return this.chunks;
        }

        public Path getHdtFile() {
            return this.hdtFile;
        }

        public String toString() {
            return "HDTFile{hdtFile=" + this.hdtFile + ", chunks=" + this.chunks + "}";
        }
    }
}

