/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.utilCat;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;

public class SectionUtil {
    public static final ByteString S1 = ByteString.of("S1");
    public static final ByteString S2 = ByteString.of("S2");
    public static final ByteString P1 = ByteString.of("P1");
    public static final ByteString P2 = ByteString.of("P2");
    public static final ByteString O1 = ByteString.of("O1");
    public static final ByteString O2 = ByteString.of("O2");
    public static final ByteString SH1 = ByteString.of("SH1");
    public static final ByteString SH2 = ByteString.of("SH2");
    public static final ByteString SECTION = ByteString.of("section");
    public static final ByteString SECTION_SUBJECT = ByteString.of("subject");
    public static final ByteString SECTION_PREDICATE = ByteString.of("predicate");
    public static final ByteString SECTION_OBJECT = ByteString.of("object");
    public static final ByteString SECTION_SHARED = ByteString.of("shared");
    public static final ByteString BACK = ByteString.of("back");
    private static final ByteString SUB_PREFIX = ByteString.of("sub");
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int BLOCK_PER_BUFFER = 1000000;

    public static ByteString createSub(Object next) {
        return SectionUtil.createSub(String.valueOf(next));
    }

    public static ByteString createSub(CharSequence next) {
        return SectionUtil.createSub(ByteString.of(next));
    }

    public static ByteString createSub(ByteString next) {
        return SUB_PREFIX.copyAppend(next);
    }

    public static void createSection(String location, long numEntries, int type, CatUnion itAdd, CatUnion itSkip, Map<? extends CharSequence, CatMapping> mappings, long offset, ProgressListener listener) throws IOException {
        ByteArrayOutputStream byteOut;
        SequenceLog64BigDisk blocks;
        ByteString name;
        switch (type) {
            case 2: {
                name = SECTION_SUBJECT;
                break;
            }
            case 3: {
                name = SECTION_OBJECT;
                break;
            }
            case 4: {
                name = SECTION_PREDICATE;
                break;
            }
            default: {
                name = ByteString.empty();
            }
        }
        long storedBuffersSize = 0L;
        long numBlocks = 0L;
        long numberElements = 0L;
        try (CRCOutputStream outBuffer = new CRCOutputStream(new FileOutputStream(location + "section_buffer_" + type), new CRC32());){
            blocks = new SequenceLog64BigDisk(location + "SequenceLog64BigDisk" + type, 64, numEntries / 16L);
            byteOut = new ByteArrayOutputStream(16384);
            if (numEntries > 0L) {
                ByteString previousStr = null;
                CatElement skipElement = null;
                if (itSkip.hasNext()) {
                    skipElement = itSkip.next();
                }
                while (itAdd.hasNext()) {
                    ListenerUtil.notifyCond(listener, "Analyze section " + name + " ", numberElements, numberElements, numEntries);
                    CatElement nextElement = itAdd.next();
                    if (skipElement != null && nextElement.entity.equals(skipElement.entity)) {
                        if (itSkip.hasNext()) {
                            skipElement = itSkip.next();
                            continue;
                        }
                        skipElement = null;
                        continue;
                    }
                    for (int i = 0; i < nextElement.IDs.size(); ++i) {
                        long id = nextElement.IDs.get((int)i).pos;
                        ByteString iter = nextElement.IDs.get((int)i).iter;
                        if (iter.equals(SECTION_SHARED)) {
                            mappings.get(iter).set(id - 1L, offset + numberElements + 1L, type);
                            continue;
                        }
                        mappings.get(iter).set(id - 1L, numberElements + 1L, type);
                    }
                    ByteString str = nextElement.entity;
                    if (numberElements % 16L == 0L) {
                        blocks.append(storedBuffersSize + (long)byteOut.size());
                        if ((++numBlocks - 1L) % 1000000L == 0L && (numBlocks - 1L) / 1000000L != 0L || byteOut.size() > 200000) {
                            storedBuffersSize += (long)byteOut.size();
                            byteOut.flush();
                            byte[] arr = byteOut.toByteArray();
                            IOUtil.writeBuffer(outBuffer, arr, 0, arr.length, null);
                            byteOut.close();
                            byteOut = new ByteArrayOutputStream(16384);
                        }
                        ByteStringUtil.append((OutputStream)byteOut, str, 0);
                    } else {
                        int delta = ByteStringUtil.longestCommonPrefix(previousStr, str);
                        VByte.encode(byteOut, delta);
                        ByteStringUtil.append((OutputStream)byteOut, str, delta);
                    }
                    byteOut.write(0);
                    previousStr = str;
                    ++numberElements;
                }
            }
            blocks.append(storedBuffersSize + (long)byteOut.size());
            blocks.aggressiveTrimToSize();
            byteOut.flush();
            byte[] arr = byteOut.toByteArray();
            IOUtil.writeBuffer(outBuffer, arr, 0, arr.length, null);
            outBuffer.writeCRC();
        }
        try (CRCOutputStream out = new CRCOutputStream(new FileOutputStream(location + "section" + type), new CRC8());){
            out.write(2);
            VByte.encode(out, numberElements);
            VByte.encode(out, storedBuffersSize + (long)byteOut.size());
            VByte.encode(out, 16L);
            out.writeCRC();
            blocks.save(out, null);
            blocks.close();
            Files.copy(Path.of(location + "section_buffer_" + type, new String[0]), out);
        }
        Files.deleteIfExists(Paths.get(location + "section_buffer_" + type, new String[0]));
        Files.deleteIfExists(Paths.get(location + "SequenceLog64BigDisk" + type, new String[0]));
    }
}

