/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.CountOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;

public class WriteDictionarySection
implements DictionarySectionPrivate {
    private final CloseSuppressPath tempFilename;
    private final CloseSuppressPath blockTempFilename;
    private SequenceLog64BigDisk blocks;
    private final long blockSize;
    private final int bufferSize;
    private long numberElements = 0L;
    private long byteoutSize;

    public WriteDictionarySection(HDTOptions spec, Path filename, int bufferSize) {
        this.bufferSize = bufferSize;
        String fn = filename.getFileName().toString();
        this.tempFilename = CloseSuppressPath.of(filename.resolveSibling(fn + "_temp"));
        this.blockTempFilename = CloseSuppressPath.of(filename.resolveSibling(fn + "_tempblock"));
        this.blockSize = spec.getInt("pfc.blocksize", 16L);
        if (this.blockSize < 0L) {
            throw new IllegalArgumentException("negative pfc.blocksize");
        }
    }

    @Override
    public void load(TempDictionarySection other, ProgressListener plistener) {
        this.load(other.getSortedEntries(), other.getNumberOfElements(), plistener);
    }

    public void load(Iterator<? extends CharSequence> it, long count, ProgressListener plistener) {
        MultiThreadListener listener = ListenerUtil.multiThreadListener(plistener);
        long block = count < 10L ? 1L : count / 10L;
        long currentCount = 0L;
        this.blocks = new SequenceLog64BigDisk(this.blockTempFilename.toAbsolutePath().toString(), 64, count / this.blockSize);
        listener.notifyProgress(0.0f, "Filling section");
        try (CountOutputStream out = new CountOutputStream(this.tempFilename.openOutputStream(this.bufferSize, new OpenOption[0]));){
            CRCOutputStream crcout = new CRCOutputStream(out, new CRC32());
            ByteString previousStr = null;
            while (it.hasNext()) {
                ByteString str = (ByteString)it.next();
                assert (str != null);
                if (this.numberElements % this.blockSize == 0L) {
                    this.blocks.append(out.getTotalBytes());
                    ByteStringUtil.append((OutputStream)crcout, str, 0);
                } else {
                    int delta = ByteStringUtil.longestCommonPrefix(previousStr, str);
                    VByte.encode(crcout, delta);
                    ByteStringUtil.append((OutputStream)crcout, str, delta);
                }
                crcout.write(0);
                previousStr = str;
                ++this.numberElements;
                if (currentCount % block == 0L) {
                    listener.notifyProgress((float)(currentCount * 100L / count), "Filling section");
                }
                ++currentCount;
            }
            this.byteoutSize = out.getTotalBytes();
            crcout.writeCRC();
        }
        catch (IOException e) {
            throw new RuntimeException("can't load section", e);
        }
        this.blocks.append(this.byteoutSize);
        this.blocks.aggressiveTrimToSize();
        if (this.numberElements % 100000L == 0L) {
            listener.notifyProgress(100.0f, "Completed section filling");
        }
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(2);
        VByte.encode(out, this.numberElements);
        VByte.encode(out, this.byteoutSize);
        VByte.encode(out, this.blockSize);
        out.writeCRC();
        this.blocks.save(output, listener);
        Files.copy(this.tempFilename, output);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    public long locate(CharSequence s) {
        throw new NotImplementedException();
    }

    public CharSequence extract(long pos) {
        throw new NotImplementedException();
    }

    public long size() {
        return this.numberElements;
    }

    public long getNumberOfElements() {
        return this.numberElements;
    }

    public Iterator<? extends CharSequence> getSortedEntries() {
        throw new NotImplementedException();
    }

    public void close() throws IOException {
        IOUtil.closeAll(this.blocks, this.tempFilename, this.blockTempFilename);
    }
}

