/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CharSequenceCustomComparator;
import org.rdfhdt.hdt.util.string.CompactString;

public class HashDictionarySection
implements TempDictionarySection {
    public static final int TYPE_INDEX = 1;
    private Map<ByteString, Long> map;
    private List<ByteString> list;
    private int size;
    public boolean sorted;
    final boolean isCustom;
    private final Map<ByteString, Long> literalsCounts = new HashMap<ByteString, Long>();

    public HashDictionarySection(boolean isCustom) {
        this.isCustom = isCustom;
        this.map = new HashMap<ByteString, Long>();
        this.list = new ArrayList<ByteString>();
        this.size = 0;
    }

    public HashDictionarySection() {
        this(false);
    }

    public long locate(CharSequence s) {
        Long val = this.map.get(ByteStringUtil.asByteString(s));
        if (val == null) {
            return 0L;
        }
        return val;
    }

    public ByteString extract(long pos) {
        if (pos <= 0L) {
            return null;
        }
        return this.list.get((int)(pos - 1L));
    }

    public long size() {
        return this.size;
    }

    public long getNumberOfElements() {
        return this.list.size();
    }

    public Iterator<? extends CharSequence> getSortedEntries() {
        if (!this.sorted) {
            return null;
        }
        return this.list.iterator();
    }

    @Override
    public Iterator<? extends CharSequence> getEntries() {
        return this.list.iterator();
    }

    @Override
    public long add(CharSequence entry) {
        CompactString compact = new CompactString(entry);
        return this.map.computeIfAbsent(compact, key -> {
            this.list.add(compact);
            this.size += compact.length();
            this.sorted = false;
            if (this.isCustom) {
                ByteString type = ByteString.of(LiteralsUtils.getType(compact));
                this.literalsCounts.compute(type, (key2, count) -> count == null ? 1L : count + 1L);
            }
            return this.list.size();
        });
    }

    @Override
    public void remove(CharSequence seq) {
        this.map.remove(ByteString.of(seq));
        this.sorted = false;
    }

    @Override
    public void sort() {
        this.list = new ArrayList<ByteString>(this.map.size());
        this.list.addAll(this.map.keySet());
        if (this.isCustom) {
            this.list.sort(new CharSequenceCustomComparator());
        } else {
            this.list.sort(new CharSequenceComparator());
        }
        for (long i = 1L; i <= this.getNumberOfElements(); ++i) {
            this.map.put(this.extract(i), i);
        }
        this.sorted = true;
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.map.clear();
        this.size = 0;
        this.sorted = false;
    }

    public void close() throws IOException {
        this.map = null;
        this.list = null;
    }

    public Map<ByteString, Long> getLiteralsCounts() {
        return this.literalsCounts;
    }
}

