/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.section;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionBig;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionMap;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.util.io.CountInputStream;

public class DictionarySectionFactory {
    private DictionarySectionFactory() {
    }

    public static DictionarySectionPrivate loadFrom(InputStream input, ProgressListener listener) throws IOException {
        if (!input.markSupported()) {
            throw new IllegalArgumentException("Need support for mark()/reset(). Please wrap the InputStream with a BufferedInputStream");
        }
        input.mark(64);
        int dictType = input.read();
        input.reset();
        input.mark(64);
        DictionarySectionPrivate section = null;
        switch (dictType) {
            case 2: {
                try {
                    section = new PFCDictionarySection(new HDTSpecification());
                    section.load(input, listener);
                }
                catch (IllegalArgumentException e) {
                    section = new PFCDictionarySectionBig(new HDTSpecification());
                    section.load(input, listener);
                }
                return section;
            }
        }
        throw new IOException("DictionarySection implementation not available for id " + dictType);
    }

    public static DictionarySectionPrivate loadFrom(CountInputStream input, File f, ProgressListener listener) throws IOException {
        input.mark(64);
        int dictType = input.read();
        input.reset();
        input.mark(64);
        switch (dictType) {
            case 2: {
                return new PFCDictionarySectionMap(input, f);
            }
        }
        throw new IOException("DictionarySection implementation not available for id " + dictType);
    }
}

