/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.kcat;

import java.util.Map;
import java.util.TreeMap;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryKCat;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;

public class MultipleSectionDictionaryKCat
implements DictionaryKCat {
    private final Dictionary dictionary;

    public MultipleSectionDictionaryKCat(Dictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public Map<CharSequence, DictionarySection> getSubSections() {
        TreeMap<CharSequence, DictionarySection> sections = new TreeMap<CharSequence, DictionarySection>(CharSequenceComparator.getInstance());
        this.dictionary.getAllObjects().forEach((key, section) -> {
            if (!LiteralsUtils.NO_DATATYPE.equals(key)) {
                sections.put(ByteString.of(key), (DictionarySection)section);
            }
        });
        return sections;
    }

    @Override
    public DictionarySection getSubjectSection() {
        return this.dictionary.getSubjects();
    }

    @Override
    public DictionarySection getPredicateSection() {
        return this.dictionary.getPredicates();
    }

    @Override
    public DictionarySection getObjectSection() {
        return (DictionarySection)this.dictionary.getAllObjects().get("NO_DATATYPE");
    }

    @Override
    public DictionarySection getSharedSection() {
        return this.dictionary.getShared();
    }

    @Override
    public long countSubjects() {
        return this.dictionary.getSubjects().getNumberOfElements() + this.countShared();
    }

    @Override
    public long countShared() {
        return this.dictionary.getShared().getNumberOfElements();
    }

    @Override
    public long countPredicates() {
        return this.dictionary.getPredicates().getNumberOfElements();
    }

    @Override
    public long countObjects() {
        long count = 0L;
        for (DictionarySection sec : this.dictionary.getAllObjects().values()) {
            count += sec.getNumberOfElements();
        }
        return count + this.countShared();
    }

    @Override
    public long objectShift() {
        DictionarySection section = this.getObjectSection();
        if (section == null) {
            return this.countObjects();
        }
        return this.countObjects() - section.getNumberOfElements();
    }
}

