/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.kcat;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.DictionaryFactory;
import org.rdfhdt.hdt.dictionary.DictionaryKCat;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.impl.kcat.BitmapTriple;
import org.rdfhdt.hdt.dictionary.impl.kcat.LocatedIndexedNode;
import org.rdfhdt.hdt.dictionary.impl.section.OneReadDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.WriteDictionarySection;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.MapFilterIterator;
import org.rdfhdt.hdt.iterator.utils.MapIterator;
import org.rdfhdt.hdt.iterator.utils.MergeExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.PipedCopyIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import org.rdfhdt.hdt.util.concurrent.SyncSeq;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.string.ByteString;

public class KCatMerger
implements AutoCloseable {
    private static final long SHARED_MASK = 1L;
    private static final long TYPED_MASK = 2L;
    final HDT[] hdts;
    private final ProgressListener listener;
    private final CloseSuppressPath[] locations;
    final SyncSeq[] subjectsMaps;
    final SyncSeq[] predicatesMaps;
    final SyncSeq[] objectsMaps;
    private final ExceptionThread catMergerThread;
    final boolean typedHDT;
    private final int shift;
    private final String dictionaryType;
    private final PipedCopyIterator<DuplicateBuffer> subjectPipe = new PipedCopyIterator();
    private final PipedCopyIterator<DuplicateBuffer> objectPipe = new PipedCopyIterator();
    private final PipedCopyIterator<BiDuplicateBuffer> sharedPipe = new PipedCopyIterator();
    private final ExceptionIterator<DuplicateBuffer, RuntimeException> sortedSubject;
    private final ExceptionIterator<DuplicateBuffer, RuntimeException> sortedObject;
    private final ExceptionIterator<DuplicateBuffer, RuntimeException> sortedPredicates;
    private final Map<ByteString, ExceptionIterator<DuplicateBuffer, RuntimeException>> sortedSubSections;
    private final long estimatedSizeP;
    private final AtomicLong countTyped = new AtomicLong();
    private final AtomicLong countShared = new AtomicLong();
    final AtomicLong[] countSubject;
    final AtomicLong[] countObject;
    private final WriteDictionarySection sectionSubject;
    private final WriteDictionarySection sectionShared;
    private final WriteDictionarySection sectionObject;
    private final WriteDictionarySection sectionPredicate;
    private final Map<ByteString, WriteDictionarySection> sectionSub;
    private final Map<ByteString, Integer> typeId = new HashMap<ByteString, Integer>();
    private boolean running;

    public KCatMerger(HDT[] hdts, BitmapTriple[] deletedTriple, CloseSuppressPath location, ProgressListener listener, int bufferSize, String dictionaryType, HDTOptions spec) throws IOException {
        this.hdts = hdts;
        this.listener = listener;
        this.dictionaryType = dictionaryType;
        DictionaryKCat[] cats = new DictionaryKCat[hdts.length];
        this.subjectsMaps = new SyncSeq[hdts.length];
        this.predicatesMaps = new SyncSeq[hdts.length];
        this.objectsMaps = new SyncSeq[hdts.length];
        this.locations = new CloseSuppressPath[hdts.length * 3];
        this.countSubject = (AtomicLong[])IntStream.range(0, hdts.length).mapToObj(i -> new AtomicLong()).toArray(AtomicLong[]::new);
        this.countObject = (AtomicLong[])IntStream.range(0, hdts.length).mapToObj(i -> new AtomicLong()).toArray(AtomicLong[]::new);
        long sizeS = 0L;
        long sizeP = 0L;
        long sizeO = 0L;
        long sizeONoTyped = 0L;
        long sizeShared = 0L;
        TreeMap<ByteString, PreIndexSection[]> subSections = new TreeMap<ByteString, PreIndexSection[]>();
        for (int i2 = 0; i2 < cats.length; ++i2) {
            DictionaryKCat cat = DictionaryFactory.createDictionaryKCat(hdts[i2].getDictionary());
            sizeS += cat.countSubjects();
            sizeP += cat.countPredicates();
            sizeO += cat.countObjects();
            DictionarySection objectSection = cat.getObjectSection();
            sizeONoTyped += objectSection == null ? 0L : objectSection.getNumberOfElements();
            sizeShared += cat.countShared();
            long start = 1L + cat.countShared();
            for (Map.Entry<CharSequence, DictionarySection> e : cat.getSubSections().entrySet()) {
                CharSequence key2 = e.getKey();
                DictionarySection section = e.getValue();
                PreIndexSection[] sections2 = subSections.computeIfAbsent(ByteString.of(key2), k -> new PreIndexSection[cats.length]);
                sections2[i2] = new PreIndexSection(start, section);
                start += section.getNumberOfElements();
            }
            cats[i2] = cat;
        }
        this.typedHDT = !subSections.isEmpty();
        this.shift = this.typedHDT ? 2 : 1;
        this.estimatedSizeP = sizeP;
        try {
            int numbitsS = BitUtil.log2(sizeS + 1L + sizeShared) + 1 + this.shift;
            int numbitsP = BitUtil.log2(sizeP + 1L);
            int numbitsO = BitUtil.log2(sizeO + 1L + sizeShared) + 1 + this.shift;
            for (int i3 = 0; i3 < cats.length; ++i3) {
                DictionaryKCat cat = cats[i3];
                CloseSuppressPath closeSuppressPath = location.resolve("subjectsMap_" + i3);
                this.locations[i3 * 3] = closeSuppressPath;
                this.subjectsMaps[i3] = new SyncSeq(new SequenceLog64BigDisk(closeSuppressPath.toAbsolutePath().toString(), numbitsS, cat.countSubjects() + 1L));
                CloseSuppressPath closeSuppressPath2 = location.resolve("predicatesMap_" + i3);
                this.locations[i3 * 3 + 1] = closeSuppressPath2;
                this.predicatesMaps[i3] = new SyncSeq(new SequenceLog64BigDisk(closeSuppressPath2.toAbsolutePath().toString(), numbitsP, cat.countPredicates() + 1L));
                CloseSuppressPath closeSuppressPath3 = location.resolve("objectsMap_" + i3);
                this.locations[i3 * 3 + 2] = closeSuppressPath3;
                this.objectsMaps[i3] = new SyncSeq(new SequenceLog64BigDisk(closeSuppressPath3.toAbsolutePath().toString(), numbitsO, cat.countObjects() + 1L));
            }
            this.sortedSubject = KCatMerger.mergeSection(cats, (hdtIndex, c) -> KCatMerger.createMergeIt(hdtIndex, c.getSubjectSection().getSortedEntries(), c.getSharedSection().getSortedEntries(), (Bitmap)(deletedTriple == null ? null : deletedTriple[hdtIndex].getSubjects()), c.countShared())).notif(sizeS, 20L, "Merge subjects", listener);
            this.sortedObject = KCatMerger.mergeSection(cats, (hdtIndex, c) -> {
                DictionarySection section = c.getObjectSection();
                return KCatMerger.createMergeIt(hdtIndex, (Iterator<? extends CharSequence>)(section == null ? new Iterator<CharSequence>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public CharSequence next() {
                        return null;
                    }
                } : section.getSortedEntries()), c.getSharedSection().getSortedEntries(), (Bitmap)(deletedTriple == null ? null : deletedTriple[hdtIndex].getObjects()), c.objectShift());
            }).notif(sizeONoTyped, 20L, "Merge objects", listener);
            this.sortedPredicates = KCatMerger.mergeSection(cats, (hdtIndex, c) -> {
                ExceptionIterator of = ExceptionIterator.of(c.getPredicateSection().getSortedEntries());
                if (deletedTriple != null) {
                    ModifiableBitmap deleteBitmap = deletedTriple[hdtIndex].getPredicates();
                    return of.mapFiltered((element, index) -> {
                        if (deleteBitmap.access(index + 1L)) {
                            return null;
                        }
                        return new LocatedIndexedNode(hdtIndex, index + 1L, ByteString.of(element));
                    });
                }
                return of.map((element, index) -> new LocatedIndexedNode(hdtIndex, index + 1L, ByteString.of(element)));
            }).notif(sizeP, 20L, "Merge predicates", listener);
            this.sortedSubSections = new TreeMap<ByteString, ExceptionIterator<DuplicateBuffer, RuntimeException>>();
            subSections.forEach((key, sections) -> this.sortedSubSections.put((ByteString)key, KCatMerger.mergeSection(sections, (hdtIndex, pre) -> {
                ExceptionIterator of = ExceptionIterator.of(pre.getSortedEntries());
                if (deletedTriple != null) {
                    ModifiableBitmap deleteBitmap = deletedTriple[hdtIndex].getObjects();
                    return of.mapFiltered((element, index) -> {
                        if (deleteBitmap.access(pre.getStart() + index)) {
                            return null;
                        }
                        return new LocatedIndexedNode(hdtIndex, pre.getStart() + index, ByteString.of(element));
                    });
                }
                return of.map((element, index) -> new LocatedIndexedNode(hdtIndex, pre.getStart() + index, ByteString.of(element)));
            }).notif(Arrays.stream(sections).mapToLong(s -> s == null || s.section == null ? 0L : s.section.getNumberOfElements()).sum(), 20L, "Merge typed objects", listener)));
            Iterator<ByteString> subject = this.subjectPipe.mapWithId((db, id) -> {
                long header = this.withEmptyHeader(id + 1L);
                db.stream().forEach(node -> {
                    SyncSeq map = this.subjectsMaps[node.getHdt()];
                    assert (map.get(node.getIndex()) == 0L) : "overwriting previous subject value";
                    map.set(node.getIndex(), header);
                    this.countSubject[node.getHdt()].incrementAndGet();
                });
                return db.peek();
            });
            Iterator<ByteString> object = this.objectPipe.mapWithId((db, id) -> {
                long header = this.withEmptyHeader(id + 1L);
                db.stream().forEach(node -> {
                    SyncSeq map = this.objectsMaps[node.getHdt()];
                    assert (map.get(node.getIndex()) == 0L) : "overwriting previous object value";
                    assert (node.getIndex() >= 1L && node.getIndex() <= hdts[node.getHdt()].getDictionary().getNobjects());
                    map.set(node.getIndex(), header);
                    this.countObject[node.getHdt()].incrementAndGet();
                });
                return db.peek();
            });
            Iterator<ByteString> shared = this.sharedPipe.mapWithId((bdb, id) -> {
                long header = this.withSharedHeader(id + 1L);
                this.countShared.incrementAndGet();
                bdb.getLeft().stream().forEach(node -> {
                    SyncSeq map = this.subjectsMaps[node.getHdt()];
                    assert (map.get(node.getIndex()) == 0L) : "overwriting previous subject value";
                    map.set(node.getIndex(), header);
                    this.countSubject[node.getHdt()].incrementAndGet();
                });
                bdb.getRight().stream().forEach(node -> {
                    SyncSeq map = this.objectsMaps[node.getHdt()];
                    assert (map.get(node.getIndex()) == 0L) : "overwriting previous object value";
                    assert (node.getIndex() >= 1L && node.getIndex() <= hdts[node.getHdt()].getDictionary().getNobjects());
                    map.set(node.getIndex(), header);
                    this.countObject[node.getHdt()].incrementAndGet();
                });
                return bdb.peek();
            });
            this.sectionSubject = new WriteDictionarySection(spec, location.resolve("sortedSubject"), bufferSize);
            this.sectionShared = new WriteDictionarySection(spec, location.resolve("sortedShared"), bufferSize);
            this.sectionObject = new WriteDictionarySection(spec, location.resolve("sortedObject"), bufferSize);
            this.sectionPredicate = new WriteDictionarySection(spec, location.resolve("sortedPredicate"), bufferSize);
            this.sectionSub = new TreeMap<ByteString, WriteDictionarySection>();
            this.sortedSubSections.keySet().forEach(key -> this.sectionSub.put((ByteString)key, new WriteDictionarySection(spec, location.resolve("sortedSub" + this.getTypeId((ByteString)key)), bufferSize)));
            this.catMergerThread = new ExceptionThread(this::runSharedCompute, "KCatMergerThreadShared").attach(new ExceptionThread(this::runSubSectionCompute, "KCatMergerThreadSubSection")).attach(new ExceptionThread(this.createWriter(this.sectionSubject, sizeS, subject), "KCatMergerThreadWriterS")).attach(new ExceptionThread(this.createWriter(this.sectionShared, sizeS + sizeO - sizeShared, shared), "KCatMergerThreadWriterSH")).attach(new ExceptionThread(this.createWriter(this.sectionObject, sizeO, object), "KCatMergerThreadWriterO"));
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
        }
    }

    private static ExceptionIterator<LocatedIndexedNode, RuntimeException> createMergeIt(int hdtIndex, Iterator<? extends CharSequence> subjectObject, Iterator<? extends CharSequence> shared, Bitmap deleteBitmap, long sharedCount) {
        if (deleteBitmap != null) {
            return MergeExceptionIterator.buildOfTree(List.of(MapFilterIterator.of(subjectObject, (element, index) -> {
                if (deleteBitmap.access(sharedCount + index + 1L)) {
                    return null;
                }
                return new LocatedIndexedNode(hdtIndex, sharedCount + index + 1L, ByteString.of(element));
            }).asExceptionIterator(), MapFilterIterator.of(shared, (element, index) -> {
                if (deleteBitmap.access(index + 1L)) {
                    return null;
                }
                return new LocatedIndexedNode(hdtIndex, index + 1L, ByteString.of(element));
            }).asExceptionIterator()));
        }
        return MergeExceptionIterator.buildOfTree(List.of(MapIterator.of(subjectObject, (element, index) -> new LocatedIndexedNode(hdtIndex, sharedCount + index + 1L, ByteString.of(element))).asExceptionIterator(), MapIterator.of(shared, (element, index) -> new LocatedIndexedNode(hdtIndex, index + 1L, ByteString.of(element))).asExceptionIterator()));
    }

    public static <T> DuplicateBufferIterator<RuntimeException> mergeSection(T[] sections, MergerFunction<T> mapper) {
        return new DuplicateBufferIterator<RuntimeException>(MergeExceptionIterator.buildOfTree((hdtIndex, e) -> {
            if (e == null) {
                return ExceptionIterator.empty();
            }
            return mapper.apply((int)hdtIndex, (Object)e);
        }, LocatedIndexedNode::compareTo, Arrays.asList(sections), 0, sections.length), sections.length);
    }

    public int getTypeId(ByteString str) {
        return this.typeId.computeIfAbsent(str, key -> this.typeId.size());
    }

    public long withTypedHeader(long value) {
        assert (value != 0L) : "value can't be 0!";
        return value << this.shift | 2L;
    }

    public long withSharedHeader(long value) {
        assert (value != 0L) : "value can't be 0!";
        return value << this.shift | 1L;
    }

    public long withEmptyHeader(long value) {
        assert (value != 0L) : "value can't be 0!";
        return value << this.shift;
    }

    boolean assertReadCorrectly() {
        for (int i = 0; i < this.hdts.length; ++i) {
            HDT hdt = this.hdts[i];
            assert (this.countObject[i].get() == hdt.getDictionary().getNobjects());
            assert (this.countSubject[i].get() == hdt.getDictionary().getNsubjects());
        }
        return true;
    }

    public boolean isShared(long headerValue) {
        return (headerValue & 1L) != 0L;
    }

    public boolean isTyped(long headerValue) {
        return this.typedHDT && (headerValue & 2L) != 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DictionaryPrivate buildDictionary() throws InterruptedException {
        KCatMerger kCatMerger = this;
        synchronized (kCatMerger) {
            if (!this.running) {
                this.startMerger();
            }
        }
        this.catMergerThread.joinAndCrashIfRequired();
        return DictionaryFactory.createWriteDictionary(this.dictionaryType, null, this.getSectionSubject(), this.getSectionPredicate(), this.getSectionObject(), this.getSectionShared(), this.getSectionSub());
    }

    private void runSharedCompute() {
        try {
            block2: while (this.sortedObject.hasNext() && this.sortedSubject.hasNext()) {
                DuplicateBuffer newSubject = this.sortedSubject.next();
                DuplicateBuffer newObject = this.sortedObject.next();
                int comp = newSubject.compareTo(newObject);
                while (comp != 0) {
                    if (comp < 0) {
                        this.subjectPipe.addElement(newSubject.trim());
                        if (!this.sortedSubject.hasNext()) {
                            this.objectPipe.addElement(newObject.trim());
                            break block2;
                        }
                        newSubject = this.sortedSubject.next();
                    } else {
                        this.objectPipe.addElement(newObject.trim());
                        if (!this.sortedObject.hasNext()) {
                            this.subjectPipe.addElement(newSubject.trim());
                            break block2;
                        }
                        newObject = this.sortedObject.next();
                    }
                    comp = newSubject.compareTo(newObject);
                }
                this.sharedPipe.addElement(newSubject.trim().asBi(newObject.trim()));
            }
            this.sharedPipe.closePipe();
            while (this.sortedSubject.hasNext()) {
                this.subjectPipe.addElement(this.sortedSubject.next().trim());
            }
            this.subjectPipe.closePipe();
            while (this.sortedObject.hasNext()) {
                this.objectPipe.addElement(this.sortedObject.next().trim());
            }
            this.objectPipe.closePipe();
        }
        catch (Throwable t) {
            this.objectPipe.closePipe(t);
            this.subjectPipe.closePipe(t);
            this.sharedPipe.closePipe(t);
            throw t;
        }
    }

    private void runSubSectionCompute() {
        this.sectionPredicate.load(new OneReadDictionarySection(this.sortedPredicates.map((db, id) -> {
            db.stream().forEach(node -> {
                SyncSeq map = this.predicatesMaps[node.getHdt()];
                assert (map.get(node.getIndex()) == 0L) : "overwriting previous predicate value";
                map.set(node.getIndex(), id + 1L);
            });
            return db.peek();
        }).asIterator(), this.estimatedSizeP), null);
        long shift = 1L;
        for (Map.Entry<ByteString, WriteDictionarySection> e : this.sectionSub.entrySet()) {
            ByteString key = e.getKey();
            WriteDictionarySection section = e.getValue();
            ExceptionIterator<DuplicateBuffer, RuntimeException> bufferIterator = this.sortedSubSections.get(key);
            long currentShift = shift;
            section.load(new OneReadDictionarySection(bufferIterator.map((db, id) -> {
                long headerID = this.withTypedHeader(id + currentShift);
                this.countTyped.incrementAndGet();
                db.stream().forEach(node -> {
                    SyncSeq map = this.objectsMaps[node.getHdt()];
                    assert (map.get(node.getIndex()) == 0L) : "overwriting previous object value";
                    assert (node.getIndex() >= 1L && node.getIndex() <= this.hdts[node.getHdt()].getDictionary().getNobjects());
                    map.set(node.getIndex(), headerID);
                    this.countObject[node.getHdt()].incrementAndGet();
                });
                return db.peek();
            }).asIterator(), this.estimatedSizeP), null);
            shift += section.getNumberOfElements();
        }
    }

    private ExceptionThread.ExceptionRunnable createWriter(DictionarySectionPrivate sect, long size, Iterator<ByteString> iterator) {
        return () -> sect.load(new OneReadDictionarySection(iterator, size), this.listener);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.catMergerThread != null) {
                this.catMergerThread.joinAndCrashIfRequired();
            }
        }
        catch (InterruptedException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Closer.closeAll(this.sectionSubject, this.sectionPredicate, this.sectionObject, this.sectionShared, this.sectionSub, this.subjectsMaps, this.predicatesMaps, this.objectsMaps, this.locations);
                throw throwable;
            }
        }
        Closer.closeAll(this.sectionSubject, this.sectionPredicate, this.sectionObject, this.sectionShared, this.sectionSub, this.subjectsMaps, this.predicatesMaps, this.objectsMaps, this.locations);
    }

    public long removeHeader(long headerID) {
        return headerID >>> this.shift;
    }

    public long extractSubject(int hdtIndex, long oldID) {
        long headerID = this.subjectsMaps[hdtIndex].get(oldID);
        if (this.isShared(headerID)) {
            return headerID >>> this.shift;
        }
        return (headerID >>> this.shift) + this.countShared.get();
    }

    public long extractPredicate(int hdtIndex, long oldID) {
        return this.predicatesMaps[hdtIndex].get(oldID);
    }

    public long extractObject(int hdtIndex, long oldID) {
        long headerID = this.objectsMaps[hdtIndex].get(oldID);
        if (this.isShared(headerID)) {
            return headerID >>> this.shift;
        }
        if (this.isTyped(headerID)) {
            return (headerID >>> this.shift) + this.countShared.get();
        }
        return (headerID >>> this.shift) + this.countShared.get() + this.countTyped.get();
    }

    public TripleID extractMapped(int hdtIndex, TripleID id) {
        TripleID mapped = new TripleID(this.extractSubject(hdtIndex, id.getSubject()), this.extractPredicate(hdtIndex, id.getPredicate()), this.extractObject(hdtIndex, id.getObject()));
        assert (mapped.isValid()) : "mapped to empty triples! " + id + " => " + mapped;
        return mapped;
    }

    public long getCountShared() {
        return this.countShared.get();
    }

    public DictionarySectionPrivate getSectionSubject() {
        return this.sectionSubject;
    }

    public DictionarySectionPrivate getSectionShared() {
        return this.sectionShared;
    }

    public DictionarySectionPrivate getSectionObject() {
        return this.sectionObject;
    }

    public DictionarySectionPrivate getSectionPredicate() {
        return this.sectionPredicate;
    }

    public TreeMap<ByteString, DictionarySectionPrivate> getSectionSub() {
        TreeMap<ByteString, DictionarySectionPrivate> sub = new TreeMap<ByteString, DictionarySectionPrivate>(this.sectionSub);
        sub.put(LiteralsUtils.NO_DATATYPE, (WriteDictionarySection)this.getSectionObject());
        return sub;
    }

    public synchronized void startMerger() {
        if (this.running) {
            throw new IllegalArgumentException("KCatMerger is already running!");
        }
        this.running = true;
        this.catMergerThread.startAll();
    }

    private static class PreIndexSection {
        long start;
        DictionarySection section;

        public PreIndexSection(long start, DictionarySection section) {
            this.start = start;
            this.section = section;
        }

        public long getStart() {
            return this.start;
        }

        public DictionarySection getSection() {
            return this.section;
        }

        public Iterator<? extends CharSequence> getSortedEntries() {
            return this.getSection().getSortedEntries();
        }
    }

    private static interface MergerFunction<T> {
        public ExceptionIterator<LocatedIndexedNode, RuntimeException> apply(int var1, T var2);
    }

    static class DuplicateBufferIterator<E extends Exception>
    implements ExceptionIterator<DuplicateBuffer, E> {
        private final ExceptionIterator<LocatedIndexedNode, E> iterator;
        private final DuplicateBuffer buffer;
        private LocatedIndexedNode last;
        private DuplicateBuffer next;

        public DuplicateBufferIterator(ExceptionIterator<LocatedIndexedNode, E> iterator, int bufferSize) {
            this.iterator = iterator;
            this.buffer = new DuplicateBuffer(bufferSize);
        }

        @Override
        public boolean hasNext() throws E {
            if (this.next != null) {
                return true;
            }
            this.buffer.clear();
            while (true) {
                if (this.last == null) {
                    if (!this.iterator.hasNext()) {
                        if (!this.buffer.isEmpty()) break;
                        return false;
                    }
                    this.last = this.iterator.next();
                }
                if (!this.buffer.add(this.last)) break;
                this.last = null;
            }
            this.next = this.buffer.trim();
            return true;
        }

        @Override
        public DuplicateBuffer next() throws E {
            if (!this.hasNext()) {
                return null;
            }
            try {
                DuplicateBuffer duplicateBuffer = this.next;
                return duplicateBuffer;
            }
            finally {
                this.next = null;
            }
        }
    }

    static class DuplicateBuffer
    implements Comparable<DuplicateBuffer> {
        private final LocatedIndexedNode[] buffer;
        private int used;

        public DuplicateBuffer(int bufferSize) {
            this.buffer = new LocatedIndexedNode[bufferSize];
        }

        private boolean add(LocatedIndexedNode node) {
            if (this.isEmpty() || this.buffer[0].getNode().equals(node.getNode())) {
                this.buffer[this.used++] = node;
                return true;
            }
            return false;
        }

        public BiDuplicateBuffer asBi(DuplicateBuffer other) {
            return new BiDuplicateBuffer(this, other);
        }

        public boolean isEmpty() {
            return this.used == 0;
        }

        public void clear() {
            for (int i = 0; i < this.used; ++i) {
                this.buffer[i] = null;
            }
            this.used = 0;
        }

        public Stream<LocatedIndexedNode> stream() {
            return Arrays.stream(this.buffer, 0, this.used);
        }

        @Override
        public int compareTo(DuplicateBuffer o) {
            if (this.isEmpty() || o.isEmpty()) {
                throw new IllegalArgumentException("Can't compare empty buffers");
            }
            return this.buffer[0].compareTo(o.buffer[0]);
        }

        public DuplicateBuffer trim() {
            DuplicateBuffer other = new DuplicateBuffer(this.used);
            System.arraycopy(this.buffer, 0, other.buffer, 0, this.used);
            other.used = this.used;
            return other;
        }

        public ByteString peek() {
            if (this.isEmpty()) {
                return null;
            }
            return this.buffer[0].getNode();
        }

        public int size() {
            return this.used;
        }
    }

    static class BiDuplicateBuffer
    implements Comparable<BiDuplicateBuffer> {
        private final DuplicateBuffer left;
        private final DuplicateBuffer right;

        public BiDuplicateBuffer(DuplicateBuffer left, DuplicateBuffer right) {
            this.left = Objects.requireNonNull(left, "left buffer can't be null!");
            this.right = Objects.requireNonNull(right, "right buffer can't be null!");
            assert (left.isEmpty() || right.isEmpty() || left.peek().equals(right.peek())) : "Can't have heterogeneous bi dupe buffer";
        }

        public DuplicateBuffer getLeft() {
            return this.left;
        }

        public DuplicateBuffer getRight() {
            return this.right;
        }

        public boolean isEmpty() {
            return this.getLeft().isEmpty() && this.getRight().isEmpty();
        }

        public ByteString peek() {
            if (!this.left.isEmpty()) {
                return this.left.peek();
            }
            if (!this.right.isEmpty()) {
                return this.right.peek();
            }
            return null;
        }

        @Override
        public int compareTo(BiDuplicateBuffer o) {
            return this.peek().compareTo(o.peek());
        }
    }
}

