/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.kcat;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.Bitmap64Big;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.compact.bitmap.NegBitmap;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.impl.kcat.BitmapTriple;
import org.rdfhdt.hdt.dictionary.impl.kcat.GroupBySubjectMapIterator;
import org.rdfhdt.hdt.dictionary.impl.kcat.KCatMerger;
import org.rdfhdt.hdt.enums.TripleComponentOrder;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.hdt.HDTManager;
import org.rdfhdt.hdt.hdt.HDTManagerImpl;
import org.rdfhdt.hdt.hdt.impl.HDTBase;
import org.rdfhdt.hdt.hdt.impl.WriteHDTImpl;
import org.rdfhdt.hdt.hdt.impl.diskimport.MapOnCallHDT;
import org.rdfhdt.hdt.header.HeaderFactory;
import org.rdfhdt.hdt.header.HeaderPrivate;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;
import org.rdfhdt.hdt.triples.Triples;
import org.rdfhdt.hdt.triples.impl.BitmapTriples;
import org.rdfhdt.hdt.triples.impl.OneReadTempTriples;
import org.rdfhdt.hdt.triples.impl.WriteBitmapTriples;
import org.rdfhdt.hdt.util.Profiler;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class KCatImpl
implements Closeable {
    private final String baseURI;
    private final List<? extends Bitmap> deleteBitmaps;
    final HDT[] hdts;
    final BitmapTriple[] deleteBitmapTriples;
    final CloseSuppressPath diffLocation;
    private final CloseSuppressPath location;
    private final Path futureLocation;
    private final boolean futureMap;
    private final boolean clearLocation;
    private final MultiThreadListener listener;
    private final String dictionaryType;
    private final int bufferSize;
    private final HDTOptions hdtFormat;
    private final TripleComponentOrder order;
    private final long rawSize;
    private final Profiler profiler;

    private static TripleComponentOrder getOrder(HDT hdt) {
        Triples triples = hdt.getTriples();
        if (!(triples instanceof BitmapTriples)) {
            throw new IllegalArgumentException("HDT Triples can't be BitmapTriples");
        }
        BitmapTriples bt = (BitmapTriples)triples;
        return bt.getOrder();
    }

    public KCatImpl(List<String> hdtFileNames, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        this(hdtFileNames, null, hdtFormat, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KCatImpl(List<String> hdtFileNames, List<? extends Bitmap> deleteBitmaps, HDTOptions hdtFormat, ProgressListener listener) throws IOException {
        this.listener = ListenerUtil.multiThreadListener(listener);
        this.hdts = new HDT[hdtFileNames.size()];
        this.hdtFormat = hdtFormat;
        this.deleteBitmaps = deleteBitmaps;
        BitmapTriple[] bitmapTripleArray = this.deleteBitmapTriples = deleteBitmaps != null ? new BitmapTriple[this.hdts.length] : null;
        if (deleteBitmaps != null && deleteBitmaps.size() != hdtFileNames.size()) {
            throw new IllegalArgumentException("deleteBitmaps.size() != hdtFileNames.size()");
        }
        long bufferSizeLong = hdtFormat.getInt("loader.disk.fileBufferSize", 8192L);
        if (bufferSizeLong > 0x7FFFFFFAL || bufferSizeLong <= 0L) {
            throw new IllegalArgumentException("Buffer size can't be negative or bigger than the size of an array!");
        }
        this.bufferSize = (int)bufferSizeLong;
        this.profiler = Profiler.createOrLoadSubSection((String)"doHDTCatk", (HDTOptions)hdtFormat, (boolean)true);
        try {
            HDT firstHDT;
            ListIterator<String> it = hdtFileNames.listIterator();
            int firstIndex = it.nextIndex();
            String firstHDTFile = it.next();
            this.hdts[firstIndex] = firstHDT = HDTManagerImpl.loadOrMapHDT(firstHDTFile, listener, hdtFormat);
            this.dictionaryType = firstHDT.getDictionary().getType();
            this.baseURI = firstHDT.getBaseURI();
            this.order = KCatImpl.getOrder(firstHDT);
            long rawSize = HDTBase.getRawSize(firstHDT.getHeader());
            IntermediateListener iListener = new IntermediateListener(listener);
            iListener.setRange(0.0f, deleteBitmaps == null ? 10.0f : 5.0f);
            while (it.hasNext()) {
                int index = it.nextIndex();
                String hdtFile = it.next();
                boolean hasBitmap = deleteBitmaps != null && deleteBitmaps.get(index) != null;
                iListener.notifyProgress((float)index * 100.0f / (float)hdtFileNames.size(), "map hdt (" + (index + 1) + "/" + hdtFileNames.size() + ")");
                HDT hdt = HDTManagerImpl.loadOrMapHDT(hdtFile, listener, hdtFormat);
                rawSize = rawSize == -1L || hasBitmap ? -1L : rawSize + HDTBase.getRawSize(hdt.getHeader());
                this.hdts[index] = hdt;
                if (!this.dictionaryType.equals(hdt.getDictionary().getType())) {
                    throw new IllegalArgumentException("Trying to cat hdt with different type, type(hdt0) [" + this.dictionaryType + "] != type(hdt" + index + ") [" + hdt.getDictionary().getType() + "]");
                }
                TripleComponentOrder order = KCatImpl.getOrder(hdt);
                if (order.equals((Object)this.order)) continue;
                throw new IllegalArgumentException("Trying to cat hdt with different order, order(hdt0) [" + this.order + "] != type(hdt" + index + ") [" + order + "]");
            }
            this.rawSize = rawSize;
            String hdtcatLocationOpt = hdtFormat.get("hdtcat.location");
            if (hdtcatLocationOpt == null || hdtcatLocationOpt.isEmpty()) {
                this.location = CloseSuppressPath.of(Files.createTempDirectory("hdtCat", new FileAttribute[0]));
                this.clearLocation = true;
            } else {
                this.location = CloseSuppressPath.of(hdtcatLocationOpt, new String[0]);
                Files.createDirectories(this.location, new FileAttribute[0]);
                this.clearLocation = hdtFormat.getBoolean("hdtcat.deleteLocation", true);
            }
            if (deleteBitmaps != null) {
                iListener.setRange(5.0f, 10.0f);
                this.diffLocation = this.location.resolve("diff");
                this.diffLocation.closeWithDeleteRecurse();
                this.diffLocation.mkdirs();
                ListIterator<? extends Bitmap> dit = deleteBitmaps.listIterator();
                this.profiler.pushSection("diffbitmaps");
                while (dit.hasNext()) {
                    int index = dit.nextIndex();
                    Bitmap deleteBitmap = dit.next();
                    HDT hdt = this.hdts[index];
                    ModifiableBitmap bs = NegBitmap.of(Bitmap64Big.disk(this.diffLocation.resolve("d" + index + "s"), hdt.getDictionary().getNsubjects() + 1L));
                    ModifiableBitmap bp = NegBitmap.of(Bitmap64Big.disk(this.diffLocation.resolve("d" + index + "p"), hdt.getDictionary().getNpredicates() + 1L));
                    ModifiableBitmap bo = NegBitmap.of(Bitmap64Big.disk(this.diffLocation.resolve("d" + index + "o"), hdt.getDictionary().getNobjects() + 1L));
                    this.deleteBitmapTriples[index] = new BitmapTriple(bs, bp, bo);
                    IteratorTripleID searchAll = hdt.getTriples().searchAll();
                    long numberOfElements = hdt.getTriples().getNumberOfElements();
                    long c = 0L;
                    while (searchAll.hasNext()) {
                        TripleID tripleID = (TripleID)searchAll.next();
                        iListener.notifyProgress((float)(c++ * 10000L / numberOfElements) / 100.0f, "building diff bitmaps " + c + "/" + numberOfElements + " (hdt " + index + "/" + this.hdts.length + ")");
                        if (deleteBitmap.access(searchAll.getLastTriplePosition())) continue;
                        bs.set(tripleID.getSubject(), false);
                        bp.set(tripleID.getPredicate(), false);
                        bo.set(tripleID.getObject(), false);
                    }
                }
                this.profiler.popSection();
            } else {
                this.diffLocation = null;
            }
            String hdtcatFutureLocationOpt = hdtFormat.get("hdtcat.location.future");
            if (hdtcatFutureLocationOpt == null || hdtcatFutureLocationOpt.isEmpty()) {
                this.futureLocation = this.location.resolve("gen.hdt");
                this.futureMap = false;
            } else {
                this.futureLocation = Path.of(hdtcatFutureLocationOpt, new String[0]);
                this.futureMap = true;
            }
            this.location.closeWithDeleteRecurse();
        }
        catch (Throwable t) {
            try {
                throw t;
            }
            catch (Throwable throwable) {
                try {
                    Closer.closeAll(this.deleteBitmapTriples);
                }
                finally {
                    for (HDT hdt : this.hdts) {
                        IOUtil.closeQuietly((Closeable)hdt);
                    }
                    this.profiler.close();
                }
                throw throwable;
            }
        }
    }

    KCatMerger createMerger(ProgressListener listener) throws IOException {
        return new KCatMerger(this.hdts, this.deleteBitmapTriples, this.location, listener, this.bufferSize, this.dictionaryType, this.hdtFormat);
    }

    public HDT cat() throws IOException {
        HDT hdt;
        IntermediateListener il = new IntermediateListener((ProgressListener)this.listener);
        String futureLocationStr = this.futureLocation.toAbsolutePath().toString();
        il.setRange(0.0f, 40.0f);
        il.setPrefix("Merge Dict: ");
        try (KCatMerger merger = this.createMerger(il);){
            this.profiler.pushSection("dict");
            try (DictionaryPrivate dictionary = merger.buildDictionary();){
                this.profiler.popSection();
                assert (this.deleteBitmaps != null || merger.assertReadCorrectly());
                this.listener.unregisterAllThreads();
                this.profiler.pushSection("triples");
                Iterator<TripleID> tripleIterator = GroupBySubjectMapIterator.fromHDTs(merger, this.hdts, this.deleteBitmaps);
                try (WriteBitmapTriples triples = new WriteBitmapTriples(this.hdtFormat, this.location.resolve("triples"), this.bufferSize);){
                    long count = Arrays.stream(this.hdts).mapToLong(h -> h.getTriples().getNumberOfElements()).sum();
                    il.setRange(40.0f, 80.0f);
                    il.setPrefix("Merge triples: ");
                    il.notifyProgress(0.0f, "start");
                    triples.load(new OneReadTempTriples(tripleIterator, this.order, count), il);
                    this.profiler.popSection();
                    WriteHDTImpl writeHDT = new WriteHDTImpl(this.hdtFormat, this.location, dictionary, triples, HeaderFactory.createHeader(this.hdtFormat));
                    this.profiler.pushSection("header");
                    writeHDT.populateHeaderStructure(this.baseURI);
                    if (this.rawSize != -1L) {
                        ((HeaderPrivate)writeHDT.getHeader()).insert("_:statistics", "<http://purl.org/HDT/hdt#originalSize>", String.valueOf(this.rawSize));
                    }
                    this.profiler.popSection();
                    this.profiler.pushSection("save");
                    il.setRange(80.0f, 90.0f);
                    il.setPrefix("Save HDT: ");
                    il.notifyProgress(0.0f, "save to " + futureLocationStr);
                    writeHDT.saveToHDT(futureLocationStr, (ProgressListener)il);
                    this.profiler.popSection();
                }
            }
            this.listener.unregisterAllThreads();
        }
        catch (InterruptedException e) {
            throw new IOException("Interruption", e);
        }
        il.setRange(90.0f, 100.0f);
        if (this.futureMap) {
            il.notifyProgress(0.0f, "map hdt");
            hdt = new MapOnCallHDT(this.futureLocation);
        } else {
            il.notifyProgress(0.0f, "load hdt");
            hdt = HDTManager.loadHDT((String)futureLocationStr, (ProgressListener)il);
            Files.deleteIfExists(this.futureLocation);
        }
        il.notifyProgress(100.0f, "cat done.");
        return hdt;
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                try {
                    this.profiler.stop();
                    this.profiler.writeProfiling();
                }
                finally {
                    this.profiler.close();
                }
            }
            catch (Throwable throwable) {
                Closer.closeAll(this.hdts, this.deleteBitmapTriples, this.diffLocation);
                throw throwable;
            }
            Closer.closeAll(this.hdts, this.deleteBitmapTriples, this.diffLocation);
        }
        finally {
            if (this.clearLocation) {
                this.location.close();
            }
        }
    }
}

