/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl.kcat;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.dictionary.impl.kcat.KCatMerger;
import org.rdfhdt.hdt.hdt.HDT;
import org.rdfhdt.hdt.iterator.utils.CombinedIterator;
import org.rdfhdt.hdt.iterator.utils.ExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.MapFilterIterator;
import org.rdfhdt.hdt.iterator.utils.MapIterator;
import org.rdfhdt.hdt.iterator.utils.MergeExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.PeekIterator;
import org.rdfhdt.hdt.triples.IteratorTripleID;
import org.rdfhdt.hdt.triples.TripleID;

public class GroupBySubjectMapIterator
implements Iterator<TripleID> {
    private final PeekIterator<TripleID> mergeIterator;
    private final List<TripleID> groupList = new ArrayList<TripleID>();
    private Iterator<TripleID> groupListIterator;
    private TripleID next;

    private GroupBySubjectMapIterator(Iterator<TripleID> mergeIterator) {
        this.mergeIterator = new PeekIterator<TripleID>(mergeIterator);
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.groupListIterator != null) {
            if (this.groupListIterator.hasNext()) {
                this.next = this.groupListIterator.next();
                return true;
            }
            this.groupList.clear();
            this.groupListIterator = null;
        }
        if (!this.mergeIterator.hasNext()) {
            return false;
        }
        TripleID peek = this.mergeIterator.peek();
        long subject = peek.getSubject();
        long predicate = peek.getPredicate();
        do {
            this.groupList.add(this.mergeIterator.next().clone());
        } while (this.mergeIterator.hasNext() && this.mergeIterator.peek().getSubject() == subject && this.mergeIterator.peek().getPredicate() == predicate);
        this.groupList.sort(Comparator.comparingLong(TripleID::getObject));
        this.groupListIterator = this.groupList.iterator();
        if (this.groupListIterator.hasNext()) {
            this.next = this.groupListIterator.next();
            return true;
        }
        throw new AssertionError((Object)"Empty groupList iterator of non empty list");
    }

    @Override
    public TripleID next() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            TripleID tripleID = this.next;
            return tripleID;
        }
        finally {
            this.next = null;
        }
    }

    private static long firstSubjectTripleId(HDT hdt) {
        if (hdt.getDictionary().getSubjects().getNumberOfElements() == 0L) {
            return -1L;
        }
        IteratorTripleID it = hdt.getTriples().search(new TripleID(hdt.getDictionary().getNshared() + 1L, 0L, 0L));
        if (it.hasNext()) {
            it.next();
            return it.getLastTriplePosition();
        }
        return -1L;
    }

    public static Iterator<TripleID> fromHDTs(KCatMerger merger, HDT[] hdts, List<? extends Bitmap> deleteBitmaps) {
        long shared = merger.getCountShared();
        List sharedSubjectIterators = IntStream.range(0, hdts.length).mapToObj(hdtIndex -> {
            ExceptionIterator subjectIteratorMapped;
            Bitmap deleteBitmap;
            HDT hdt = hdts[hdtIndex];
            Bitmap bitmap = deleteBitmap = deleteBitmaps == null ? null : (Bitmap)deleteBitmaps.get(hdtIndex);
            if (hdt.getTriples().getNumberOfElements() == 0L) {
                return ExceptionIterator.empty();
            }
            long firstSubjectTripleId = GroupBySubjectMapIterator.firstSubjectTripleId(hdt);
            if (firstSubjectTripleId == -1L) {
                subjectIteratorMapped = ExceptionIterator.empty();
            } else {
                IteratorTripleID subjectIterator = hdt.getTriples().searchAll();
                subjectIterator.goTo(firstSubjectTripleId);
                subjectIteratorMapped = ExceptionIterator.of(new SharedOnlyIterator(GroupBySubjectMapIterator.createIdMapper(merger, hdtIndex, hdt, (Iterator<TripleID>)subjectIterator, firstSubjectTripleId, deleteBitmap), shared));
            }
            if (shared == 0L) {
                return subjectIteratorMapped;
            }
            SharedStopIterator sharedIterator = new SharedStopIterator((Iterator<TripleID>)hdt.getTriples().searchAll(), hdt.getDictionary().getNshared());
            SharedOnlyIterator sharedIteratorMapped = new SharedOnlyIterator(GroupBySubjectMapIterator.createIdMapper(merger, hdtIndex, hdt, sharedIterator, 0L, deleteBitmap), shared);
            return new MergeExceptionIterator(subjectIteratorMapped, ExceptionIterator.of(sharedIteratorMapped), TripleID::compareTo);
        }).collect(Collectors.toList());
        List subjectIterators = IntStream.range(0, hdts.length).mapToObj(hdtIndex -> {
            ExceptionIterator subjectIteratorMapped;
            Bitmap deleteBitmap;
            HDT hdt = hdts[hdtIndex];
            Bitmap bitmap = deleteBitmap = deleteBitmaps == null ? null : (Bitmap)deleteBitmaps.get(hdtIndex);
            if (hdt.getTriples().getNumberOfElements() == 0L) {
                return ExceptionIterator.empty();
            }
            long firstSubjectTripleId = GroupBySubjectMapIterator.firstSubjectTripleId(hdt);
            if (firstSubjectTripleId == -1L) {
                subjectIteratorMapped = ExceptionIterator.empty();
            } else {
                IteratorTripleID subjectIterator = hdt.getTriples().searchAll();
                subjectIterator.goTo(firstSubjectTripleId);
                subjectIteratorMapped = ExceptionIterator.of(new NoSharedIterator(GroupBySubjectMapIterator.createIdMapper(merger, hdtIndex, hdt, (Iterator<TripleID>)subjectIterator, firstSubjectTripleId, deleteBitmap), shared));
            }
            if (shared == 0L || deleteBitmap == null) {
                return subjectIteratorMapped;
            }
            long sharedCount = hdt.getDictionary().getNshared();
            SharedStopIterator sharedIterator = new SharedStopIterator((Iterator<TripleID>)hdt.getTriples().searchAll(), sharedCount);
            NoSharedIterator sharedIteratorMapped = new NoSharedIterator(GroupBySubjectMapIterator.createIdMapper(merger, hdtIndex, hdt, sharedIterator, 0L, deleteBitmap), shared);
            return new MergeExceptionIterator(subjectIteratorMapped, ExceptionIterator.of(sharedIteratorMapped), TripleID::compareTo);
        }).collect(Collectors.toList());
        return new GroupBySubjectMapIterator(new NoDupeTripleIDIterator(CombinedIterator.combine(List.of(MergeExceptionIterator.buildOfTree(Function.identity(), GroupBySubjectMapIterator::compareSP, sharedSubjectIterators, 0, sharedSubjectIterators.size()).asIterator(), MergeExceptionIterator.buildOfTree(Function.identity(), GroupBySubjectMapIterator::compareSP, subjectIterators, 0, subjectIterators.size()).asIterator()))));
    }

    private static Iterator<TripleID> createIdMapper(KCatMerger merger, int hdtIndex, HDT hdt, Iterator<TripleID> it, long start, Bitmap deleteBitmap) {
        if (deleteBitmap == null) {
            return new MapIterator<TripleID, TripleID>(it, tid -> {
                assert (GroupBySubjectMapIterator.inHDT(tid, hdt));
                return merger.extractMapped(hdtIndex, (TripleID)tid);
            });
        }
        return MapFilterIterator.of(it, (tid, index) -> {
            if (deleteBitmap.access(index + start)) {
                return null;
            }
            assert (GroupBySubjectMapIterator.inHDT(tid, hdt));
            return merger.extractMapped(hdtIndex, (TripleID)tid);
        });
    }

    private static int compareSP(TripleID t1, TripleID t2) {
        int compare = Long.compare(t1.getSubject(), t2.getSubject());
        if (compare != 0) {
            return compare;
        }
        return Long.compare(t1.getPredicate(), t2.getPredicate());
    }

    private static boolean inHDT(TripleID id, HDT hdt) {
        long s = id.getSubject();
        long p = id.getPredicate();
        long o = id.getObject();
        return s >= 1L && s <= hdt.getDictionary().getNsubjects() && p >= 1L && p <= hdt.getDictionary().getNpredicates() && o >= 1L && o <= hdt.getDictionary().getNobjects();
    }

    private static class NoSharedIterator
    implements Iterator<TripleID> {
        private final Iterator<TripleID> it;
        private final long shared;
        private TripleID next;

        private NoSharedIterator(Iterator<TripleID> it, long shared) {
            this.it = it;
            this.shared = shared;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.it.hasNext()) {
                TripleID next = this.it.next();
                if (next.getSubject() <= this.shared) continue;
                this.next = next;
                return true;
            }
            return false;
        }

        @Override
        public TripleID next() {
            if (!this.hasNext()) {
                return null;
            }
            try {
                TripleID tripleID = this.next;
                return tripleID;
            }
            finally {
                this.next = null;
            }
        }
    }

    private static class SharedOnlyIterator
    implements Iterator<TripleID> {
        private final Iterator<TripleID> it;
        private final long shared;
        private TripleID next;

        private SharedOnlyIterator(Iterator<TripleID> it, long shared) {
            this.it = it;
            this.shared = shared;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            while (this.it.hasNext()) {
                TripleID next = this.it.next();
                if (next.getSubject() > this.shared) continue;
                this.next = next;
                return true;
            }
            return false;
        }

        @Override
        public TripleID next() {
            if (!this.hasNext()) {
                return null;
            }
            try {
                TripleID tripleID = this.next;
                return tripleID;
            }
            finally {
                this.next = null;
            }
        }
    }

    private static class SharedStopIterator
    implements Iterator<TripleID> {
        private final Iterator<TripleID> it;
        private final long shared;
        private TripleID next;

        private SharedStopIterator(Iterator<TripleID> it, long shared) {
            this.it = it;
            this.shared = shared;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return this.next.getSubject() <= this.shared;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.next = this.it.next();
            return this.next.getSubject() <= this.shared;
        }

        @Override
        public TripleID next() {
            if (!this.hasNext()) {
                return null;
            }
            try {
                TripleID tripleID = this.next;
                return tripleID;
            }
            finally {
                this.next = null;
            }
        }
    }

    private static class NoDupeTripleIDIterator
    implements Iterator<TripleID> {
        private TripleID next;
        private final PeekIterator<TripleID> it;

        public NoDupeTripleIDIterator(Iterator<TripleID> it) {
            this.it = new PeekIterator<TripleID>(it);
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.next = this.it.next();
            assert (this.next.isValid()) : "Can't have empty tripleID";
            while (this.it.hasNext() && this.it.peek().equals((Object)this.next)) {
                this.it.next();
            }
            return true;
        }

        @Override
        public TripleID next() {
            if (!this.hasNext()) {
                return null;
            }
            try {
                TripleID tripleID = this.next;
                return tripleID;
            }
            finally {
                this.next = null;
            }
        }
    }
}

