/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleBaseDictionary;
import org.rdfhdt.hdt.dictionary.impl.section.WriteDictionarySection;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.iterator.utils.PeekIterator;
import org.rdfhdt.hdt.iterator.utils.PipedCopyIterator;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.rdfhdt.hdt.util.string.ByteString;

public class WriteMultipleSectionDictionary
extends MultipleBaseDictionary {
    private final Path filename;
    private final int bufferSize;

    public WriteMultipleSectionDictionary(HDTOptions spec, Path filename, int bufferSize) {
        super(spec);
        this.filename = filename;
        this.bufferSize = bufferSize;
        String name = filename.getFileName().toString();
        this.subjects = new WriteDictionarySection(spec, filename.resolveSibling(name + "SU"), bufferSize);
        this.predicates = new WriteDictionarySection(spec, filename.resolveSibling(name + "PR"), bufferSize);
        this.objects = new TreeMap();
        this.shared = new WriteDictionarySection(spec, filename.resolveSibling(name + "SH"), bufferSize);
    }

    public WriteMultipleSectionDictionary(HDTOptions spec, DictionarySectionPrivate subjects, DictionarySectionPrivate predicates, DictionarySectionPrivate shared, TreeMap<ByteString, DictionarySectionPrivate> objects) {
        super(spec);
        this.filename = null;
        this.bufferSize = 0;
        this.subjects = subjects;
        this.predicates = predicates;
        this.objects = objects;
        this.shared = shared;
    }

    public long getNAllObjects() {
        return this.objects.values().stream().mapToLong(DictionarySection::getNumberOfElements).sum();
    }

    private ExceptionThread fillSection(Iterator<? extends CharSequence> objects, long count, ProgressListener listener) {
        PipedCopyIterator datatypeIterator = new PipedCopyIterator();
        String name = this.filename.getFileName().toString();
        Map theObjects = Collections.synchronizedMap(this.objects);
        return new ExceptionThread(() -> WriteMultipleSectionDictionary.lambda$fillSection$0(count, objects, listener, datatypeIterator), "MultiSecSAsyncObjectReader").attach(new ExceptionThread(() -> {
            PeekIterator<TypedByteString> dataTypePeekIt = new PeekIterator<TypedByteString>(datatypeIterator);
            HashMap<ByteString, Long> sectionIds = new HashMap<ByteString, Long>();
            while (dataTypePeekIt.hasNext()) {
                ByteString type = ((TypedByteString)dataTypePeekIt.peek()).getType();
                Long sid = (Long)sectionIds.get(type);
                if (sid != null) {
                    throw new IllegalArgumentException("type " + type + " is already defined");
                }
                long sidNew = 1L + (long)sectionIds.size();
                sectionIds.put(type, sidNew);
                WriteDictionarySection section = new WriteDictionarySection(this.spec, this.filename.resolveSibling(name + "type" + sidNew), this.bufferSize);
                theObjects.put(type, section);
                section.load(dataTypePeekIt.map(TypedByteString::getNode), count, null);
                ((PipedCopyIterator)dataTypePeekIt.getWrappedIterator()).reset();
            }
        }, "MultiSecSAsyncObjectDatatypeWriter"));
    }

    @Override
    public void loadAsync(TempDictionary other, ProgressListener listener) throws InterruptedException {
        MultiThreadListener ml = ListenerUtil.multiThreadListener(listener);
        ml.unregisterAllThreads();
        ExceptionThread.async("MultiSecSAsyncReader", () -> this.predicates.load(other.getPredicates(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Predicate: ")), () -> this.subjects.load(other.getSubjects(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Subjects:  ")), () -> this.shared.load(other.getShared(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Shared:    "))).attach(this.fillSection(other.getObjects().getEntries(), other.getObjects().getNumberOfElements(), new IntermediateListener((ProgressListener)ml, "Objects:   "))).startAll().joinAndCrashIfRequired();
        ml.unregisterAllThreads();
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(this.getType());
        ci.setInt("elements", this.getNumberOfElements());
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        iListener.setRange(0.0f, 25.0f);
        iListener.setPrefix("Save shared: ");
        this.shared.save(output, iListener);
        iListener.setRange(25.0f, 50.0f);
        iListener.setPrefix("Save subjects: ");
        this.subjects.save(output, iListener);
        iListener.setRange(50.0f, 75.0f);
        iListener.setPrefix("Save predicates: ");
        this.predicates.save(output, iListener);
        iListener.setRange(75.0f, 100.0f);
        iListener.setPrefix("Save objects: ");
        VByte.encode(output, this.objects.size());
        for (Map.Entry entry : this.objects.entrySet()) {
            IOUtil.writeSizedBuffer(output, (ByteString)entry.getKey(), listener);
        }
        for (Map.Entry entry : this.objects.entrySet()) {
            ((DictionarySectionPrivate)entry.getValue()).save(output, iListener);
        }
    }

    public void close() throws IOException {
        try {
            IOUtil.closeAll(new Closeable[]{this.shared, this.subjects, this.predicates});
        }
        finally {
            IOUtil.closeAll(this.objects.values());
        }
    }

    public void populateHeader(Header header, String rootNode) {
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarynumSharedSubjectObject>", this.getNshared());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarysizeStrings>", this.size());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#dictionaryMult>";
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void load(TempDictionary other, ProgressListener listener) {
        throw new NotImplementedException();
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$fillSection$0(long count, Iterator objects, ProgressListener listener, PipedCopyIterator datatypeIterator) throws Exception {
        try {
            oldType = null;
            block = count < 10L ? 1L : count / 10L;
            currentCount = 0L;
            while (objects.hasNext()) {
                next = (ByteString)objects.next();
                lit = (ByteString)LiteralsUtils.prefToLit(next);
                type = (ByteString)LiteralsUtils.getType(lit);
                if (currentCount % block == 0L) {
                    listener.notifyProgress((float)(currentCount * 100L / count), "Filling section");
                }
                if (oldType == null) ** GOTO lbl16
                if (oldType.equals(type)) {
                    datatypeIterator.addElement(new TypedByteString(oldType, (ByteString)LiteralsUtils.removeType(lit)));
                } else {
                    datatypeIterator.closePipe();
lbl16:
                    // 2 sources

                    oldType = type;
                    datatypeIterator.addElement(new TypedByteString(oldType, (ByteString)LiteralsUtils.removeType(lit)));
                }
                ++currentCount;
            }
            datatypeIterator.closePipe();
            datatypeIterator.closePipe();
        }
        catch (Throwable e) {
            try {
                throw e;
            }
            catch (Throwable var13_11) {
                datatypeIterator.closePipe(e);
                throw var13_11;
            }
        }
    }

    private static class TypedByteString {
        private final ByteString type;
        private final ByteString node;

        public TypedByteString(ByteString type, ByteString node) {
            this.type = type;
            this.node = node;
        }

        public ByteString getNode() {
            return this.node;
        }

        public ByteString getType() {
            return this.type;
        }
    }
}

