/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.BaseDictionary;
import org.rdfhdt.hdt.dictionary.impl.section.WriteDictionarySection;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.listener.ListenerUtil;

public class WriteFourSectionDictionary
extends BaseDictionary {
    public WriteFourSectionDictionary(HDTOptions spec, Path filename, int bufferSize) {
        super(spec);
        String name = filename.getFileName().toString();
        this.subjects = new WriteDictionarySection(spec, filename.resolveSibling(name + "SU"), bufferSize);
        this.predicates = new WriteDictionarySection(spec, filename.resolveSibling(name + "PR"), bufferSize);
        this.objects = new WriteDictionarySection(spec, filename.resolveSibling(name + "OB"), bufferSize);
        this.shared = new WriteDictionarySection(spec, filename.resolveSibling(name + "SH"), bufferSize);
    }

    public WriteFourSectionDictionary(HDTOptions spec, DictionarySectionPrivate subjects, DictionarySectionPrivate predicates, DictionarySectionPrivate objects, DictionarySectionPrivate shared) {
        super(spec);
        this.subjects = subjects;
        this.predicates = predicates;
        this.objects = objects;
        this.shared = shared;
    }

    @Override
    public void loadAsync(TempDictionary other, ProgressListener listener) throws InterruptedException {
        MultiThreadListener ml = ListenerUtil.multiThreadListener(listener);
        ml.unregisterAllThreads();
        ExceptionThread.async("FourSecSAsyncReader", () -> this.predicates.load(other.getPredicates(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Predicate: ")), () -> this.subjects.load(other.getSubjects(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Subjects:  ")), () -> this.shared.load(other.getShared(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Shared:    ")), () -> this.objects.load(other.getObjects(), (ProgressListener)new IntermediateListener((ProgressListener)ml, "Object:    "))).startAll().joinAndCrashIfRequired();
        ml.unregisterAllThreads();
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    @Override
    public void load(TempDictionary other, ProgressListener listener) {
        throw new NotImplementedException();
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(this.getType());
        ci.setInt("elements", this.getNumberOfElements());
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        iListener.setRange(0.0f, 25.0f);
        iListener.setPrefix("Save shared: ");
        this.shared.save(output, iListener);
        iListener.setRange(25.0f, 50.0f);
        iListener.setPrefix("Save subjects: ");
        this.subjects.save(output, iListener);
        iListener.setRange(50.0f, 75.0f);
        iListener.setPrefix("Save predicates: ");
        this.predicates.save(output, iListener);
        iListener.setRange(75.0f, 100.0f);
        iListener.setPrefix("Save objects: ");
        this.objects.save(output, iListener);
    }

    public void populateHeader(Header header, String rootNode) {
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarynumSharedSubjectObject>", this.getNshared());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarysizeStrings>", this.size());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#dictionaryFour>";
    }

    public void close() throws IOException {
        IOUtil.closeAll(new Closeable[]{this.shared, this.subjects, this.predicates, this.objects});
    }
}

