/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIntersection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.dictionary.impl.utilCat.SectionUtil;
import org.rdfhdt.hdt.dictionary.impl.utilDiff.DiffWrapper;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.string.ByteString;

public class MultipleSectionDictionaryDiff
implements DictionaryDiff {
    private final String location;
    private final Map<ByteString, CatMapping> allMappings = new HashMap<ByteString, CatMapping>();
    private CatMapping mappingBack;
    public long numShared;

    public MultipleSectionDictionaryDiff(String location) {
        this.location = location;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtil.closeAll(this.allMappings.values());
        }
        catch (Throwable throwable) {
            IOUtil.closeAll(this.mappingBack);
            throw throwable;
        }
        IOUtil.closeAll(this.mappingBack);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void diff(Dictionary dictionary, Map<CharSequence, ModifiableBitmap> bitmaps, ProgressListener listener) throws IOException {
        this.allMappings.put(SectionUtil.SECTION_PREDICATE, new CatMapping(this.location, SectionUtil.SECTION_PREDICATE, dictionary.getPredicates().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SECTION_SUBJECT, new CatMapping(this.location, SectionUtil.SECTION_SUBJECT, dictionary.getSubjects().getNumberOfElements()));
        int countSubSection = 0;
        for (Map.Entry next : dictionary.getAllObjects().entrySet()) {
            ByteString subPrefix = ((CharSequence)next.getKey()).equals(LiteralsUtils.NO_DATATYPE) ? LiteralsUtils.NO_DATATYPE : SectionUtil.createSub(countSubSection);
            this.allMappings.put(subPrefix, new CatMapping(this.location, subPrefix, ((DictionarySection)next.getValue()).getNumberOfElements()));
            ++countSubSection;
        }
        this.allMappings.put(SectionUtil.SECTION_OBJECT, new CatMapping(this.location, SectionUtil.SECTION_OBJECT, dictionary.getNAllObjects()));
        this.allMappings.put(SectionUtil.SECTION_SHARED, new CatMapping(this.location, SectionUtil.SECTION_SHARED, dictionary.getShared().getNumberOfElements()));
        Bitmap predicatesBitMap = (Bitmap)bitmaps.get("P");
        Iterator predicates = dictionary.getPredicates().getSortedEntries();
        DiffWrapper itSkipPreds = new DiffWrapper(predicates, predicatesBitMap, SectionUtil.SECTION_PREDICATE);
        ArrayList<Iterator<CatElement>> listSkipPred = new ArrayList<Iterator<CatElement>>();
        listSkipPred.add(itSkipPreds);
        long numPreds = predicatesBitMap.countOnes();
        SectionUtil.createSection(this.location, numPreds, 3, new CatUnion(listSkipPred), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap subjectsBitMap = (Bitmap)bitmaps.get("S");
        Iterator subjects = dictionary.getSubjects().getSortedEntries();
        DiffWrapper itSkipSubs = new DiffWrapper(subjects, subjectsBitMap, SectionUtil.SECTION_SUBJECT);
        ArrayList<Iterator<CatElement>> listSkipSubj = new ArrayList<Iterator<CatElement>>();
        listSkipSubj.add(itSkipSubs);
        SharedWrapper sharedWrapper = new SharedWrapper(0, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        long numNewSubj = sharedWrapper.count();
        sharedWrapper = new SharedWrapper(0, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        listSkipSubj.add(sharedWrapper);
        long numSubj = subjectsBitMap.countOnes() + numNewSubj;
        SectionUtil.createSection(this.location, numSubj, 2, new CatUnion(listSkipSubj), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        ArrayList<ByteString> dataTypes = new ArrayList<ByteString>();
        HashMap<ByteString, Long> offsets = new HashMap<ByteString, Long>();
        int countSection = 0;
        long totalObjects = 0L;
        for (Map.Entry next : dictionary.getAllObjects().entrySet()) {
            int type = 4 + dataTypes.size();
            ByteString key = ByteString.of((CharSequence)next.getKey());
            if (key.equals(LiteralsUtils.NO_DATATYPE)) {
                long numNoDataType = this.createNoDataTypeSection(bitmaps, dictionary, totalObjects, type);
                if (numNoDataType > 0L) {
                    dataTypes.add(LiteralsUtils.NO_DATATYPE);
                    offsets.put(LiteralsUtils.NO_DATATYPE, totalObjects);
                    totalObjects += numNoDataType;
                }
            } else {
                Bitmap objectsBitMap = (Bitmap)bitmaps.get(key);
                Iterator objects = ((DictionarySection)dictionary.getAllObjects().get(key)).getSortedEntries();
                ByteString subPrefix = SectionUtil.createSub(countSection);
                DiffWrapper itSkipObjs = new DiffWrapper(objects, objectsBitMap, subPrefix);
                ArrayList<Iterator<CatElement>> listSkipObjs = new ArrayList<Iterator<CatElement>>();
                listSkipObjs.add(itSkipObjs);
                long numObject = objectsBitMap.countOnes();
                if (numObject > 0L) {
                    dataTypes.add(key);
                    offsets.put(key, totalObjects);
                }
                totalObjects += numObject;
                SectionUtil.createSection(this.location, numObject, type, new CatUnion(listSkipObjs), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, null);
            }
            ++countSection;
        }
        Bitmap sharedSubjBitMap = (Bitmap)bitmaps.get("SH_S");
        Bitmap sharedObjBitMap = (Bitmap)bitmaps.get("SH_O");
        Iterator shared = dictionary.getShared().getSortedEntries();
        DiffWrapper sharedSubj = new DiffWrapper(shared, sharedSubjBitMap, SectionUtil.SECTION_SHARED);
        shared = dictionary.getShared().getSortedEntries();
        DiffWrapper sharedObj = new DiffWrapper(shared, sharedObjBitMap, SectionUtil.SECTION_SHARED);
        ArrayList<Iterator<CatElement>> listShared = new ArrayList<Iterator<CatElement>>();
        listShared.add(new CatIntersection(sharedSubj, sharedObj));
        CatUnion union = new CatUnion(listShared);
        while (union.hasNext()) {
            union.next();
            ++this.numShared;
        }
        listShared = new ArrayList();
        sharedSubj = new DiffWrapper(dictionary.getShared().getSortedEntries(), sharedSubjBitMap, SectionUtil.SECTION_SHARED);
        sharedObj = new DiffWrapper(dictionary.getShared().getSortedEntries(), sharedObjBitMap, SectionUtil.SECTION_SHARED);
        listShared.add(new CatIntersection(sharedSubj, sharedObj));
        SectionUtil.createSection(this.location, this.numShared, 1, new CatUnion(listShared), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(dictionary.getType());
        ci.setInt("elements", numSubj + numPreds + totalObjects + this.numShared);
        try (FileOutputStream out = new FileOutputStream(this.location + "dictionary");){
            ci.save(out);
            for (int i = 1; i <= 3; ++i) {
                Files.copy(Path.of(this.location + "section" + i, new String[0]), out);
                Files.delete(Path.of(this.location + "section" + i, new String[0]));
            }
            VByte.encode(out, dataTypes.size());
            for (ByteString byteString : dataTypes) {
                IOUtil.writeSizedBuffer((OutputStream)out, byteString.getBuffer(), listener);
            }
            for (int i = 0; i < dataTypes.size(); ++i) {
                Files.copy(Path.of(this.location + "section" + (4 + i), new String[0]), out);
                Files.delete(Path.of(this.location + "section" + (4 + i), new String[0]));
            }
        }
        long oldId = 0L;
        countSection = 0;
        for (CharSequence dataType : dictionary.getAllObjects().keySet()) {
            ByteString dataTypeB = ByteString.of(dataType);
            ByteString subPrefix = dataTypeB.equals(LiteralsUtils.NO_DATATYPE) ? LiteralsUtils.NO_DATATYPE : SectionUtil.createSub(countSection);
            if (this.allMappings.containsKey(subPrefix)) {
                CatMapping mapping = this.allMappings.get(subPrefix);
                int i = 0;
                while ((long)i < mapping.getSize()) {
                    Long offset;
                    long newId = mapping.getMapping(i);
                    if (mapping.getType(i) != 1L && (offset = (Long)offsets.get(dataTypeB)) != null) {
                        newId += offset.longValue();
                    }
                    this.allMappings.get(SectionUtil.SECTION_OBJECT).set(oldId, newId, (int)mapping.getType(i));
                    ++oldId;
                    ++i;
                }
            }
            ++countSection;
        }
        this.mappingBack = new CatMapping(this.location, SectionUtil.BACK, numSubj + this.numShared);
        if (this.mappingBack.getSize() > 0L) {
            void var35_45;
            void var35_43;
            boolean bl = false;
            while ((long)var35_43 < this.allMappings.get(SectionUtil.SECTION_SHARED).getSize()) {
                long type = this.allMappings.get(SectionUtil.SECTION_SHARED).getType((long)var35_43);
                if (type == 1L) {
                    this.mappingBack.set(this.allMappings.get(SectionUtil.SECTION_SHARED).getMapping((long)var35_43) - 1L, (long)(var35_43 + true), 1);
                } else if (type == 2L) {
                    this.mappingBack.set(this.allMappings.get(SectionUtil.SECTION_SHARED).getMapping((long)var35_43) + this.numShared - 1L, (long)(var35_43 + true), 2);
                }
                ++var35_43;
            }
            boolean bl2 = false;
            while ((long)var35_45 < this.allMappings.get(SectionUtil.SECTION_SUBJECT).getSize()) {
                long type = this.allMappings.get(SectionUtil.SECTION_SUBJECT).getType((long)var35_45);
                if (type == 1L) {
                    this.mappingBack.set(this.allMappings.get(SectionUtil.SECTION_SUBJECT).getMapping((long)var35_45) - 1L, (long)(var35_45 + true + (int)dictionary.getNshared()), 1);
                } else if (type == 2L) {
                    this.mappingBack.set(this.allMappings.get(SectionUtil.SECTION_SUBJECT).getMapping((long)var35_45) + this.numShared - 1L, (long)(var35_45 + true + (int)dictionary.getNshared()), 2);
                }
                ++var35_45;
            }
        }
    }

    private long createNoDataTypeSection(Map<CharSequence, ModifiableBitmap> bitmaps, Dictionary dictionary, long numObjectsAlreadyAdded, int type) throws IOException {
        Bitmap objectsBitMap = (Bitmap)bitmaps.get(LiteralsUtils.NO_DATATYPE);
        Iterator objects = ((DictionarySection)dictionary.getAllObjects().get(LiteralsUtils.NO_DATATYPE)).getSortedEntries();
        DiffWrapper itSkipObjs = new DiffWrapper(objects, objectsBitMap, LiteralsUtils.NO_DATATYPE);
        ArrayList<Iterator<CatElement>> listSkipObjs = new ArrayList<Iterator<CatElement>>();
        listSkipObjs.add(itSkipObjs);
        SharedWrapper sharedWrapper = new SharedWrapper(1, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        long numNewObj = sharedWrapper.count();
        sharedWrapper = new SharedWrapper(1, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        listSkipObjs.add(sharedWrapper);
        long numObject = objectsBitMap.countOnes() + numNewObj;
        SectionUtil.createSection(this.location, numObject, type, new CatUnion(listSkipObjs), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, numObjectsAlreadyAdded, null);
        return numObject;
    }

    @Override
    public Map<ByteString, CatMapping> getAllMappings() {
        return this.allMappings;
    }

    @Override
    public CatMapping getMappingBack() {
        return this.mappingBack;
    }

    @Override
    public long getNumShared() {
        return this.numShared;
    }

    private static class SharedWrapper
    implements Iterator<CatElement> {
        private final Bitmap bitmapSub;
        private final Bitmap bitmapObj;
        private final Iterator<? extends CharSequence> sectionIter;
        private final int flag;
        CatElement next;
        long count = 0L;

        public SharedWrapper(int flag, Bitmap bitmapSub, Bitmap bitmapObj, Iterator<? extends CharSequence> sectionIter) {
            this.bitmapSub = bitmapSub;
            this.bitmapObj = bitmapObj;
            this.sectionIter = sectionIter;
            this.flag = flag;
        }

        @Override
        public boolean hasNext() {
            while (this.sectionIter.hasNext()) {
                ByteString element = ByteString.of(this.sectionIter.next());
                if (this.flag == 0 && this.bitmapSub.access(this.count) && !this.bitmapObj.access(this.count) || this.flag == 1 && this.bitmapObj.access(this.count) && !this.bitmapSub.access(this.count)) {
                    ArrayList<CatElement.IteratorPlusPosition> IDs = new ArrayList<CatElement.IteratorPlusPosition>();
                    IDs.add(new CatElement.IteratorPlusPosition(SectionUtil.SECTION_SHARED, this.count + 1L));
                    this.next = new CatElement(element, IDs);
                    ++this.count;
                    return true;
                }
                ++this.count;
            }
            return false;
        }

        @Override
        public CatElement next() {
            return this.next;
        }

        public int count() {
            int i = 0;
            while (this.hasNext()) {
                ++i;
            }
            return i;
        }
    }
}

