/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64BigDisk;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryCat;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIntersection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMappingBack;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatWrapper;
import org.rdfhdt.hdt.dictionary.impl.utilCat.SectionUtil;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.ListenerUtil;
import org.rdfhdt.hdt.util.listener.PrefixListener;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;

public class MultipleSectionDictionaryCat
implements DictionaryCat {
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int BLOCK_PER_BUFFER = 1000000;
    private static final ByteString NO_DT_OBJECTS = LiteralsUtils.NO_DATATYPE;
    private static final ByteString NO_DT_OBJECTS_1 = NO_DT_OBJECTS.copyAppend("1");
    private static final ByteString NO_DT_OBJECTS_2 = NO_DT_OBJECTS.copyAppend("2");
    private final String location;
    private long numShared;
    private final HashMap<ByteString, CatMapping> allMappings = new HashMap();
    private CatMappingBack mappingS;

    public MultipleSectionDictionaryCat(String location) {
        this.location = location;
    }

    @Override
    public void cat(Dictionary dictionary1, Dictionary dictionary2, ProgressListener listener) throws IOException {
        long newId;
        int i;
        CatMapping mapping;
        ByteString prefix;
        ByteString dataType;
        CatIntersection i2;
        Comparator<CharSequence> comparator = CharSequenceComparator.getInstance();
        this.allMappings.put(SectionUtil.P1, new CatMapping(this.location, SectionUtil.P1, dictionary1.getPredicates().getNumberOfElements()));
        this.allMappings.put(SectionUtil.P2, new CatMapping(this.location, SectionUtil.P2, dictionary2.getPredicates().getNumberOfElements()));
        this.allMappings.put(SectionUtil.S1, new CatMapping(this.location, SectionUtil.S1, dictionary1.getSubjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.S2, new CatMapping(this.location, SectionUtil.S2, dictionary2.getSubjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.O1, new CatMapping(this.location, SectionUtil.O1, dictionary1.getNAllObjects()));
        this.allMappings.put(SectionUtil.O2, new CatMapping(this.location, SectionUtil.O2, dictionary2.getNAllObjects()));
        this.allMappings.put(SectionUtil.SH1, new CatMapping(this.location, SectionUtil.SH1, dictionary1.getShared().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SH2, new CatMapping(this.location, SectionUtil.SH2, dictionary2.getShared().getNumberOfElements()));
        Map allObjects1 = dictionary1.getAllObjects();
        Iterator hmIterator1 = allObjects1.entrySet().iterator();
        int countSubSections1 = 0;
        int countSubSections2 = 0;
        while (hmIterator1.hasNext()) {
            Map.Entry entry = hmIterator1.next();
            ByteString prefix2 = ((CharSequence)entry.getKey()).equals(NO_DT_OBJECTS) ? NO_DT_OBJECTS : SectionUtil.createSub(countSubSections1);
            prefix2 = prefix2.copyAppend("1");
            this.allMappings.put(prefix2, new CatMapping(this.location, prefix2, ((DictionarySection)entry.getValue()).getNumberOfElements()));
            ++countSubSections1;
        }
        Map allObjects2 = dictionary2.getAllObjects();
        for (Map.Entry entry : allObjects2.entrySet()) {
            ByteString prefix3 = ((CharSequence)entry.getKey()).equals(NO_DT_OBJECTS) ? NO_DT_OBJECTS : SectionUtil.createSub(countSubSections2);
            prefix3 = prefix3.copyAppend("2");
            this.allMappings.put(prefix3, new CatMapping(this.location, prefix3, ((DictionarySection)entry.getValue()).getNumberOfElements()));
            ++countSubSections2;
        }
        PrefixListener iListener = PrefixListener.of("Generate predicates: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        int numCommonPredicates = 0;
        CatIntersection commonP1P2 = new CatIntersection(new CatWrapper(dictionary1.getPredicates().getSortedEntries(), SectionUtil.P1), new CatWrapper(dictionary2.getPredicates().getSortedEntries(), SectionUtil.P2));
        while (commonP1P2.hasNext()) {
            commonP1P2.next();
            ++numCommonPredicates;
        }
        long numPredicates = dictionary1.getPredicates().getNumberOfElements() + dictionary2.getPredicates().getNumberOfElements() - (long)numCommonPredicates;
        ArrayList<Iterator<CatElement>> addPredicatesList = new ArrayList<Iterator<CatElement>>();
        addPredicatesList.add(new CatWrapper(dictionary1.getPredicates().getSortedEntries(), SectionUtil.P1));
        addPredicatesList.add(new CatWrapper(dictionary2.getPredicates().getSortedEntries(), SectionUtil.P2));
        CatUnion itAddPredicates = new CatUnion(addPredicatesList);
        this.catSection(numPredicates, 3, itAddPredicates, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, iListener);
        iListener = PrefixListener.of("Generate subjects: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        ArrayList<Iterator<CatElement>> skipSubjectList = new ArrayList<Iterator<CatElement>>();
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        if (allObjects2.containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2)));
        }
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        if (allObjects1.containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1)));
        }
        CatUnion skipSubject = new CatUnion(skipSubjectList);
        int numSkipSubjects = 0;
        while (skipSubject.hasNext()) {
            skipSubject.next();
            ++numSkipSubjects;
        }
        int numCommonSubjects = 0;
        CatIntersection commonS1S2 = new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2));
        while (commonS1S2.hasNext()) {
            commonS1S2.next();
            ++numCommonSubjects;
        }
        long numSubjects = dictionary1.getSubjects().getNumberOfElements() + dictionary2.getSubjects().getNumberOfElements() - (long)numCommonSubjects - (long)numSkipSubjects;
        skipSubjectList = new ArrayList();
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        if (allObjects2.containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2)));
        }
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        if (allObjects1.containsKey(NO_DT_OBJECTS)) {
            skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1)));
        }
        skipSubject = new CatUnion(skipSubjectList);
        ArrayList<Iterator<CatElement>> addSubjectsList = new ArrayList<Iterator<CatElement>>();
        addSubjectsList.add(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1));
        addSubjectsList.add(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2));
        CatUnion itAddSubjects = new CatUnion(addSubjectsList);
        this.catSection(numSubjects, 2, itAddSubjects, skipSubject, this.allMappings, iListener);
        iListener = PrefixListener.of("Generate objects: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        ArrayList<Iterator<CatElement>> skipObjectsList = new ArrayList<Iterator<CatElement>>();
        if (allObjects1.containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2)));
        }
        if (allObjects2.containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2), new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1)));
        }
        CatUnion skipObject = new CatUnion(skipObjectsList);
        int numSkipObjects = 0;
        while (skipObject.hasNext()) {
            skipObject.next();
            ++numSkipObjects;
        }
        int numCommonObjects = 0;
        ArrayList<Iterator<CatElement>> commonObjectsList = new ArrayList<Iterator<CatElement>>();
        hmIterator1 = allObjects1.entrySet().iterator();
        Iterator hmIterator2 = allObjects2.entrySet().iterator();
        boolean skip1 = false;
        boolean skip2 = false;
        ByteString dataType1 = CompactString.EMPTY;
        ByteString dataType2 = CompactString.EMPTY;
        DictionarySection section1 = null;
        DictionarySection section2 = null;
        while (hmIterator1.hasNext() || hmIterator2.hasNext()) {
            if (hmIterator1.hasNext() && !skip1) {
                Map.Entry entry1 = hmIterator1.next();
                section1 = (DictionarySection)entry1.getValue();
                dataType1 = ByteString.of((CharSequence)entry1.getKey());
            }
            if (hmIterator2.hasNext() && !skip2) {
                Map.Entry entry2 = hmIterator2.next();
                section2 = (DictionarySection)entry2.getValue();
                dataType2 = ByteString.of((CharSequence)entry2.getKey());
            }
            if (section1 != null && section2 != null && dataType1.equals(dataType2)) {
                commonObjectsList.add(new CatIntersection(new CatWrapper(section1.getSortedEntries(), dataType1.copyAppend("_1")), new CatWrapper(section2.getSortedEntries(), dataType2.copyAppend("_2"))));
                continue;
            }
            int comp = comparator.compare(dataType1, dataType2);
            if (comp > 0) {
                skip1 = true;
                skip2 = false;
            } else if (comp < 0) {
                skip1 = false;
                skip2 = true;
            }
            if (!hmIterator2.hasNext()) {
                skip1 = false;
            }
            if (hmIterator1.hasNext()) continue;
            skip2 = false;
        }
        CatUnion commonO1O2 = new CatUnion(commonObjectsList);
        while (commonO1O2.hasNext()) {
            commonO1O2.next();
            ++numCommonObjects;
        }
        skipObjectsList = new ArrayList();
        if (allObjects1.containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2)));
        }
        if (allObjects2.containsKey(NO_DT_OBJECTS)) {
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
            skipObjectsList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2), new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1)));
        }
        skipObject = new CatUnion(skipObjectsList);
        long numObject = dictionary1.getNAllObjects() + dictionary2.getNAllObjects() - (long)numCommonObjects - (long)numSkipObjects;
        hmIterator1 = allObjects1.entrySet().iterator();
        hmIterator2 = allObjects2.entrySet().iterator();
        int type = 4;
        ArrayList<ByteString> dataTypes = new ArrayList<ByteString>();
        countSubSections1 = 0;
        countSubSections2 = 0;
        HashMap<ByteString, Long> offsets = new HashMap<ByteString, Long>();
        long total = 0L;
        skip1 = false;
        skip2 = false;
        dataType1 = ByteString.empty();
        dataType2 = ByteString.empty();
        section1 = null;
        section2 = null;
        ByteString prefix1 = ByteString.empty();
        ByteString prefix2 = ByteString.empty();
        while (hmIterator1.hasNext() || hmIterator2.hasNext()) {
            Map.Entry entry;
            ArrayList<Iterator<CatElement>> addObjectsList = new ArrayList<Iterator<CatElement>>();
            ArrayList<Iterator<CatElement>> countObjectsList = new ArrayList<Iterator<CatElement>>();
            if (hmIterator1.hasNext() && !skip1) {
                entry = hmIterator1.next();
                dataType1 = ByteString.of((CharSequence)entry.getKey());
                section1 = (DictionarySection)entry.getValue();
                prefix1 = dataType1.equals(NO_DT_OBJECTS) ? NO_DT_OBJECTS : SectionUtil.createSub(countSubSections1);
                ++countSubSections1;
            }
            if (hmIterator2.hasNext() && !skip2) {
                entry = hmIterator2.next();
                dataType2 = ByteString.of((CharSequence)entry.getKey());
                section2 = (DictionarySection)entry.getValue();
                prefix2 = dataType2.equals(NO_DT_OBJECTS) ? NO_DT_OBJECTS : SectionUtil.createSub(countSubSections2);
                ++countSubSections2;
            }
            ByteString dataType3 = CompactString.EMPTY;
            if (section1 != null && section2 != null && dataType1.equals(dataType2)) {
                dataType3 = dataType1;
                addObjectsList.add(new CatWrapper(section1.getSortedEntries(), prefix1.copyAppend("1")));
                countObjectsList.add(new CatWrapper(section1.getSortedEntries(), prefix1.copyAppend("1")));
                addObjectsList.add(new CatWrapper(section2.getSortedEntries(), prefix2.copyAppend("2")));
                countObjectsList.add(new CatWrapper(section2.getSortedEntries(), prefix2.copyAppend("2")));
                skip1 = false;
                skip2 = false;
                if (!hmIterator1.hasNext()) {
                    section1 = null;
                    dataType1 = ByteString.empty();
                } else if (!hmIterator2.hasNext()) {
                    section2 = null;
                    dataType2 = ByteString.empty();
                }
            } else {
                boolean fromOne = false;
                boolean fromTwo = false;
                if (dataType1.length() == 0) {
                    fromTwo = true;
                } else if (dataType2.length() == 0) {
                    fromOne = true;
                }
                int comp = comparator.compare(dataType1, dataType2);
                if (comp < 0) {
                    fromOne = true;
                }
                if (comp > 0) {
                    fromTwo = true;
                }
                if (section1 != null && fromOne) {
                    dataType3 = dataType1;
                    addObjectsList.add(new CatWrapper(section1.getSortedEntries(), prefix1.copyAppend("1")));
                    countObjectsList.add(new CatWrapper(section1.getSortedEntries(), prefix1.copyAppend("1")));
                    if (!hmIterator1.hasNext()) {
                        section1 = null;
                        dataType1 = ByteString.empty();
                        skip2 = false;
                    } else {
                        skip1 = false;
                        skip2 = true;
                    }
                } else if (section2 != null && fromTwo) {
                    dataType3 = dataType2;
                    addObjectsList.add(new CatWrapper(section2.getSortedEntries(), prefix2.copyAppend("2")));
                    countObjectsList.add(new CatWrapper(section2.getSortedEntries(), prefix2.copyAppend("2")));
                    if (!hmIterator2.hasNext()) {
                        section2 = null;
                        dataType2 = ByteString.empty();
                        skip1 = false;
                    } else {
                        skip1 = true;
                        skip2 = false;
                    }
                }
            }
            long numberElts = 0L;
            CatUnion itCountObjects = new CatUnion(countObjectsList);
            while (itCountObjects.hasNext()) {
                ++numberElts;
                itCountObjects.next();
            }
            CatUnion itAddObjects = new CatUnion(addObjectsList);
            if (dataType3.equals(NO_DT_OBJECTS)) {
                this.catSection(numberElts -= (long)numSkipObjects, type, itAddObjects, skipObject, this.allMappings, iListener);
            } else {
                this.catSection(numberElts, type, itAddObjects, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, iListener);
            }
            if (numberElts > 0L) {
                dataTypes.add(dataType3);
                offsets.put(dataType3, total);
            }
            total += numberElts;
            ++type;
        }
        iListener = PrefixListener.of("Generate shared: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        int numCommonS1O2 = 0;
        if (allObjects2.containsKey(NO_DT_OBJECTS)) {
            CatIntersection i22 = new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2));
            while (i22.hasNext()) {
                i22.next();
                ++numCommonS1O2;
            }
        }
        int numCommonO1S2 = 0;
        if (allObjects1.containsKey(NO_DT_OBJECTS)) {
            i2 = new CatIntersection(new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2));
            while (i2.hasNext()) {
                i2.next();
                ++numCommonO1S2;
            }
        }
        i2 = new CatIntersection(new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2));
        int numCommonSh1Sh2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonSh1Sh2;
        }
        this.numShared = dictionary1.getShared().getNumberOfElements() + dictionary2.getShared().getNumberOfElements() - (long)numCommonSh1Sh2 + (long)numCommonS1O2 + (long)numCommonO1S2;
        ArrayList<Iterator<CatElement>> addSharedList = new ArrayList<Iterator<CatElement>>();
        addSharedList.add(new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1));
        addSharedList.add(new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2));
        if (allObjects1.containsKey(NO_DT_OBJECTS)) {
            addSharedList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
            addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(((DictionarySection)allObjects1.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_1)));
        }
        if (allObjects2.containsKey(NO_DT_OBJECTS)) {
            addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2)));
            addSharedList.add(new CatIntersection(new CatWrapper(((DictionarySection)allObjects2.get(NO_DT_OBJECTS)).getSortedEntries(), NO_DT_OBJECTS_2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        }
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        CatUnion itAddShared = new CatUnion(addSharedList);
        this.catSection(this.numShared, 1, itAddShared, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, iListener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat("<http://purl.org/HDT/hdt#dictionaryFour>");
        ci.setInt("elements", numSubjects + numPredicates + numObject + this.numShared);
        try (FileOutputStream outFinal = new FileOutputStream(this.location + "dictionary");){
            ci.save(outFinal);
            for (int i3 = 1; i3 <= 3; ++i3) {
                Files.copy(Path.of(this.location + "section" + i3, new String[0]), outFinal);
                Files.delete(Path.of(this.location + "section" + i3, new String[0]));
            }
            VByte.encode(outFinal, dataTypes.size());
            for (ByteString datatype : dataTypes) {
                String datatypeStr = datatype.toString();
                byte[] bytes = datatypeStr.getBytes();
                IOUtil.writeSizedBuffer(outFinal, bytes, 0, bytes.length, iListener);
            }
            for (int i4 = 0; i4 < dataTypes.size(); ++i4) {
                Files.copy(Path.of(this.location + "section" + (4 + i4), new String[0]), outFinal);
                Files.delete(Path.of(this.location + "section" + (4 + i4), new String[0]));
            }
        }
        long oldId = 0L;
        hmIterator1 = allObjects1.entrySet().iterator();
        countSubSections1 = 0;
        countSubSections2 = 0;
        while (hmIterator1.hasNext()) {
            Map.Entry entry = hmIterator1.next();
            dataType = ByteString.of((CharSequence)entry.getKey());
            prefix = dataType.equals(NO_DT_OBJECTS) ? NO_DT_OBJECTS : SectionUtil.createSub(countSubSections1);
            if (this.allMappings.containsKey(prefix = prefix.copyAppend("1"))) {
                mapping = this.allMappings.get(prefix);
                i = 0;
                while ((long)i < mapping.getSize()) {
                    newId = mapping.getMapping(i);
                    if (mapping.getType(i) != 1L && offsets.containsKey(dataType)) {
                        newId += ((Long)offsets.get(dataType)).longValue();
                    }
                    this.allMappings.get(SectionUtil.O1).set(oldId, newId, (int)mapping.getType(i));
                    ++oldId;
                    ++i;
                }
            }
            ++countSubSections1;
        }
        oldId = 0L;
        for (Map.Entry entry : allObjects2.entrySet()) {
            dataType = ByteString.of((CharSequence)entry.getKey());
            prefix = dataType.equals(NO_DT_OBJECTS) ? NO_DT_OBJECTS : SectionUtil.createSub(countSubSections2);
            mapping = this.allMappings.get(prefix = prefix.copyAppend("2"));
            if (mapping == null) continue;
            ++countSubSections2;
            i = 0;
            while ((long)i < mapping.getSize()) {
                newId = mapping.getMapping(i);
                long mappingType = mapping.getType(i);
                Long offset = (Long)offsets.get(dataType);
                if (mappingType != 1L && offset != null) {
                    newId += offset.longValue();
                }
                this.allMappings.get(SectionUtil.O2).set(oldId, newId, (int)mappingType);
                ++oldId;
                ++i;
            }
        }
        this.mappingS = new CatMappingBack(this.location, numSubjects + this.numShared);
        int i5 = 0;
        while ((long)i5 < this.allMappings.get(SectionUtil.SH1).getSize()) {
            this.mappingS.set(this.allMappings.get(SectionUtil.SH1).getMapping(i5), i5 + 1, 1);
            ++i5;
        }
        i5 = 0;
        while ((long)i5 < this.allMappings.get(SectionUtil.SH2).getSize()) {
            this.mappingS.set(this.allMappings.get(SectionUtil.SH2).getMapping(i5), i5 + 1, 2);
            ++i5;
        }
        i5 = 0;
        while ((long)i5 < this.allMappings.get(SectionUtil.S1).getSize()) {
            if (this.allMappings.get(SectionUtil.S1).getType(i5) == 1L) {
                this.mappingS.set(this.allMappings.get(SectionUtil.S1).getMapping(i5), i5 + 1 + (int)dictionary1.getNshared(), 1);
            } else {
                this.mappingS.set(this.allMappings.get(SectionUtil.S1).getMapping(i5) + (long)((int)this.numShared), i5 + 1 + (int)dictionary1.getNshared(), 1);
            }
            ++i5;
        }
        i5 = 0;
        while ((long)i5 < this.allMappings.get(SectionUtil.S2).getSize()) {
            if (this.allMappings.get(SectionUtil.S2).getType(i5) == 1L) {
                this.mappingS.set(this.allMappings.get(SectionUtil.S2).getMapping(i5), i5 + 1 + (int)dictionary2.getNshared(), 2);
            } else {
                this.mappingS.set(this.allMappings.get(SectionUtil.S2).getMapping(i5) + (long)((int)this.numShared), i5 + 1 + (int)dictionary2.getNshared(), 2);
            }
            ++i5;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtil.closeAll(this.allMappings.values());
        }
        catch (Throwable throwable) {
            IOUtil.closeAll(this.mappingS);
            throw throwable;
        }
        IOUtil.closeAll(this.mappingS);
    }

    private void catSection(long numEntries, int type, CatUnion itAdd, CatUnion itSkip, Map<ByteString, CatMapping> mappings, ProgressListener listener) throws IOException {
        ByteArrayOutputStream byteOut;
        SequenceLog64BigDisk blocks;
        ByteString name;
        long numberElements = 0L;
        switch (type) {
            case 2: {
                name = SectionUtil.SECTION_SUBJECT;
                break;
            }
            case 3: {
                name = SectionUtil.SECTION_OBJECT;
                break;
            }
            case 4: {
                name = SectionUtil.SECTION_PREDICATE;
                break;
            }
            default: {
                name = CompactString.EMPTY;
            }
        }
        long storedBuffersSize = 0L;
        long numBlocks = 0L;
        try (CRCOutputStream outBuffer = new CRCOutputStream(new FileOutputStream(this.location + "section_buffer_" + type), new CRC32());){
            blocks = new SequenceLog64BigDisk(this.location + "SequenceLog64BigDisk" + type, 64, numEntries / 16L);
            byteOut = new ByteArrayOutputStream(16384);
            if (numEntries > 0L) {
                ByteString previousStr = null;
                CatElement skipElement = null;
                if (itSkip.hasNext()) {
                    skipElement = itSkip.next();
                }
                while (itAdd.hasNext()) {
                    ListenerUtil.notifyCond(listener, "Analyze section " + name + " ", numberElements, numberElements, numEntries);
                    CatElement nextElement = itAdd.next();
                    if (skipElement != null && nextElement.entity.equals(skipElement.entity)) {
                        if (itSkip.hasNext()) {
                            skipElement = itSkip.next();
                            continue;
                        }
                        skipElement = null;
                        continue;
                    }
                    for (int i = 0; i < nextElement.IDs.size(); ++i) {
                        long id = nextElement.IDs.get((int)i).pos;
                        ByteString iter = nextElement.IDs.get((int)i).iter;
                        mappings.get(iter).set(id - 1L, numberElements + 1L, type);
                    }
                    ByteString str = nextElement.entity;
                    if (numberElements % 16L == 0L) {
                        blocks.append(storedBuffersSize + (long)byteOut.size());
                        if ((++numBlocks - 1L) % 1000000L == 0L && (numBlocks - 1L) / 1000000L != 0L || byteOut.size() > 200000) {
                            storedBuffersSize += (long)byteOut.size();
                            byteOut.flush();
                            byte[] array = byteOut.toByteArray();
                            IOUtil.writeBuffer(outBuffer, array, 0, array.length, null);
                            byteOut.close();
                            byteOut = new ByteArrayOutputStream(16384);
                        }
                        ByteStringUtil.append((OutputStream)byteOut, str, 0);
                    } else {
                        int delta = ByteStringUtil.longestCommonPrefix(previousStr, str);
                        VByte.encode(byteOut, delta);
                        ByteStringUtil.append((OutputStream)byteOut, str, delta);
                    }
                    byteOut.write(0);
                    previousStr = str;
                    ++numberElements;
                }
            }
            blocks.append(storedBuffersSize + (long)byteOut.size());
            blocks.aggressiveTrimToSize();
            byteOut.flush();
            byte[] bytes = byteOut.toByteArray();
            IOUtil.writeBuffer(outBuffer, bytes, 0, bytes.length, null);
            outBuffer.writeCRC();
        }
        try (CRCOutputStream out = new CRCOutputStream(new FileOutputStream(this.location + "section" + type), new CRC8());){
            out.write(2);
            VByte.encode(out, numberElements);
            VByte.encode(out, storedBuffersSize + (long)byteOut.size());
            VByte.encode(out, 16L);
            out.writeCRC();
            blocks.save(out, null);
            blocks.close();
            Files.copy(Path.of(this.location + "section_buffer_" + type, new String[0]), out);
        }
        Files.deleteIfExists(Paths.get(this.location + "section_buffer_" + type, new String[0]));
        Files.deleteIfExists(Paths.get(this.location + "SequenceLog64BigDisk" + type, new String[0]));
    }

    @Override
    public CatMappingBack getMappingS() {
        return this.mappingS;
    }

    @Override
    public Map<ByteString, CatMapping> getAllMappings() {
        return this.allMappings;
    }

    @Override
    public long getNumShared() {
        return this.numShared;
    }
}

