/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleBaseDictionary;
import org.rdfhdt.hdt.dictionary.impl.section.DictionarySectionFactory;
import org.rdfhdt.hdt.dictionary.impl.section.HashDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.PFCDictionarySectionBig;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.header.Header;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.CustomIterator;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import org.rdfhdt.hdt.util.io.CountInputStream;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.IntermediateListener;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;

public class MultipleSectionDictionaryBig
extends MultipleBaseDictionary {
    public MultipleSectionDictionaryBig(HDTOptions spec) {
        super(spec);
        this.subjects = new PFCDictionarySectionBig(spec);
        this.predicates = new PFCDictionarySectionBig(spec);
        this.objects = new TreeMap(CharSequenceComparator.getInstance());
        this.shared = new PFCDictionarySectionBig(spec);
    }

    @Override
    public void load(TempDictionary other, ProgressListener listener) {
        IntermediateListener iListener = new IntermediateListener(listener);
        this.subjects.load(other.getSubjects(), (ProgressListener)iListener);
        this.predicates.load(other.getPredicates(), (ProgressListener)iListener);
        Iterator<? extends CharSequence> iter = other.getObjects().getEntries();
        Map<ByteString, Long> literalsCounts = ((HashDictionarySection)other.getObjects()).getLiteralsCounts();
        literalsCounts.computeIfPresent(LiteralsUtils.NO_DATATYPE, (key, value) -> value - other.getShared().getNumberOfElements());
        CustomIterator customIterator = new CustomIterator(iter, literalsCounts);
        while (customIterator.hasNext()) {
            PFCDictionarySectionBig section = new PFCDictionarySectionBig(this.spec);
            ByteString type = (ByteString)LiteralsUtils.getType(customIterator.prev);
            long numEntries = literalsCounts.get(type);
            section.load(customIterator, numEntries, listener);
            this.objects.put(type, section);
        }
        this.shared.load(other.getShared(), (ProgressListener)iListener);
    }

    @Override
    public void loadAsync(TempDictionary other, ProgressListener listener) throws InterruptedException {
        IntermediateListener iListener = new IntermediateListener(null);
        new ExceptionThread(() -> this.predicates.load(other.getPredicates(), (ProgressListener)iListener), "MultiSecSAsyncReaderP").attach(new ExceptionThread(() -> this.subjects.load(other.getSubjects(), (ProgressListener)iListener), "MultiSecSAsyncReaderS"), new ExceptionThread(() -> this.shared.load(other.getShared(), (ProgressListener)iListener), "MultiSecSAsyncReaderSh"), new ExceptionThread(() -> {
            Iterator<? extends CharSequence> iter = other.getObjects().getEntries();
            HashMap<? extends ByteString, Long> literalsCounts = new HashMap<ByteString, Long>(other.getObjects().getLiteralsCounts());
            literalsCounts.computeIfPresent(LiteralsUtils.NO_DATATYPE, (key, value) -> value - other.getShared().getNumberOfElements());
            CustomIterator customIterator = new CustomIterator(iter, literalsCounts);
            while (customIterator.hasNext()) {
                PFCDictionarySection section = new PFCDictionarySection(this.spec);
                ByteString type = ByteString.of(LiteralsUtils.getType(customIterator.prev));
                long numEntries = (Long)literalsCounts.get(type);
                section.load(customIterator, numEntries, listener);
                section.locate(new CompactString("\"\ud83c\uddeb\ud83c\uddf7\"@ro"));
                this.objects.put(type, section);
            }
        }, "MultiSecSAsyncReaderO")).startAll().joinAndCrashIfRequired();
    }

    @Override
    public void save(OutputStream output, ControlInfo ci, ProgressListener listener) throws IOException {
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(this.getType());
        ci.setInt("elements", this.getNumberOfElements());
        ci.save(output);
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared.save(output, iListener);
        this.subjects.save(output, iListener);
        this.predicates.save(output, iListener);
        this.writeLiteralsMap(output, iListener);
    }

    private void writeLiteralsMap(OutputStream output, ProgressListener listener) throws IOException {
        int numberOfTypes = this.objects.size();
        VByte.encode(output, numberOfTypes);
        ArrayList<ByteString> types = new ArrayList<ByteString>();
        for (ByteString uriKey : this.objects.keySet()) {
            IOUtil.writeSizedBuffer(output, uriKey.toString().getBytes(), listener);
            types.add(uriKey);
        }
        for (ByteString type : types) {
            ((DictionarySectionPrivate)this.objects.get(type)).save(output, listener);
        }
    }

    private void readLiteralsMap(InputStream input, ProgressListener listener) throws IOException {
        int numberOfTypes = (int)VByte.decode(input);
        ArrayList<CompactString> types = new ArrayList<CompactString>();
        for (int i = 0; i < numberOfTypes; ++i) {
            types.add(new CompactString(IOUtil.readSizedBuffer(input, listener)));
        }
        for (ByteString byteString : types) {
            this.objects.put(byteString, DictionarySectionFactory.loadFrom(input, listener));
        }
    }

    private void mapLiteralsMap(CountInputStream input, File f, ProgressListener listener) throws IOException {
        int numberOfTypes = (int)VByte.decode(input);
        ArrayList<CompactString> types = new ArrayList<CompactString>();
        for (int i = 0; i < numberOfTypes; ++i) {
            types.add(new CompactString(IOUtil.readSizedBuffer(input, listener)));
        }
        for (ByteString byteString : types) {
            this.objects.put(byteString, DictionarySectionFactory.loadFrom(input, f, listener));
        }
    }

    @Override
    public void load(InputStream input, ControlInfo ci, ProgressListener listener) throws IOException {
        if (ci.getType() != ControlInfo.Type.DICTIONARY) {
            throw new IllegalFormatException("Trying to read a dictionary section, but was not dictionary.");
        }
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared = DictionarySectionFactory.loadFrom(input, iListener);
        this.subjects = DictionarySectionFactory.loadFrom(input, iListener);
        this.predicates = DictionarySectionFactory.loadFrom(input, iListener);
        this.readLiteralsMap(input, listener);
    }

    @Override
    public void mapFromFile(CountInputStream in, File f, ProgressListener listener) throws IOException {
        ControlInformation ci = new ControlInformation();
        ci.load(in);
        if (ci.getType() != ControlInfo.Type.DICTIONARY) {
            throw new IllegalFormatException("Trying to read a dictionary section, but was not dictionary.");
        }
        IntermediateListener iListener = new IntermediateListener(listener);
        this.shared = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.subjects = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.predicates = DictionarySectionFactory.loadFrom(in, f, iListener);
        this.mapLiteralsMap(in, f, listener);
    }

    public long getNAllObjects() {
        return this.objects.values().stream().mapToLong(DictionarySection::getNumberOfElements).sum();
    }

    @Override
    public Map<? extends CharSequence, DictionarySection> getAllObjects() {
        return new TreeMap(this.objects);
    }

    public void populateHeader(Header header, String rootNode) {
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/dc/terms/format>", (CharSequence)this.getType());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarynumSharedSubjectObject>", this.getNshared());
        header.insert((CharSequence)rootNode, (CharSequence)"<http://purl.org/HDT/hdt#dictionarysizeStrings>", this.size());
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#dictionaryMult>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.shared.close();
        }
        finally {
            try {
                this.subjects.close();
            }
            finally {
                try {
                    this.predicates.close();
                }
                finally {
                    IOUtil.closeAll(this.objects.values());
                }
            }
        }
    }
}

