/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.DictionarySection;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.impl.utilCat.SectionUtil;
import org.rdfhdt.hdt.enums.DictionarySectionRole;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.util.LiteralsUtils;
import org.rdfhdt.hdt.util.string.ByteString;
import org.rdfhdt.hdt.util.string.ByteStringUtil;

public abstract class MultipleBaseDictionary
implements DictionaryPrivate {
    protected final HDTOptions spec;
    protected DictionarySectionPrivate subjects;
    protected DictionarySectionPrivate predicates;
    protected TreeMap<ByteString, DictionarySectionPrivate> objects;
    protected DictionarySectionPrivate shared;

    public MultipleBaseDictionary(HDTOptions spec) {
        this.spec = spec;
    }

    protected long getGlobalId(long id, DictionarySectionRole position, CharSequence str) {
        switch (position) {
            case SUBJECT: {
                return id + this.shared.getNumberOfElements();
            }
            case OBJECT: {
                Iterator<Map.Entry<ByteString, DictionarySectionPrivate>> iter = this.objects.entrySet().iterator();
                int count = 0;
                ByteString type = (ByteString)LiteralsUtils.getType(ByteStringUtil.asByteString(str));
                while (iter.hasNext()) {
                    Map.Entry<ByteString, DictionarySectionPrivate> entry = iter.next();
                    count = (int)((long)count + entry.getValue().getNumberOfElements());
                    if (!type.equals(entry.getKey())) continue;
                    count = (int)((long)count - entry.getValue().getNumberOfElements());
                    break;
                }
                return this.shared.getNumberOfElements() + (long)count + id;
            }
            case PREDICATE: 
            case SHARED: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    protected long getLocalId(long id, TripleComponentRole position) {
        switch (position) {
            case SUBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return id;
                }
                return id - this.shared.getNumberOfElements();
            }
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return id;
                }
                Iterator<Map.Entry<ByteString, DictionarySectionPrivate>> hmIterator = this.objects.entrySet().iterator();
                long count = 0L;
                while (hmIterator.hasNext()) {
                    Map.Entry<ByteString, DictionarySectionPrivate> entry = hmIterator.next();
                    long numElts = entry.getValue().getNumberOfElements();
                    if (id > this.shared.getNumberOfElements() + (count += numElts)) continue;
                    count -= numElts;
                    break;
                }
                return id - count - this.shared.getNumberOfElements();
            }
            case PREDICATE: {
                return id;
            }
        }
        throw new IllegalArgumentException();
    }

    public long stringToId(CharSequence sstr, TripleComponentRole position) {
        if (sstr == null || sstr.length() == 0) {
            return 0L;
        }
        ByteString str = ByteString.of(sstr);
        switch (position) {
            case SUBJECT: {
                long ret = this.shared.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED, str);
                }
                ret = this.subjects.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SUBJECT, str);
                }
                return -1L;
            }
            case PREDICATE: {
                long ret = this.predicates.locate(str);
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.PREDICATE, str);
                }
                return -1L;
            }
            case OBJECT: {
                long ret;
                if (str.charAt(0) != '\"' && (ret = this.shared.locate(str)) != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.SHARED, str);
                }
                DictionarySectionPrivate subSection = this.getSubSection(str);
                if (subSection == null) {
                    return -1L;
                }
                ret = subSection.locate(LiteralsUtils.removeType(str));
                if (ret != 0L) {
                    return this.getGlobalId(ret, DictionarySectionRole.OBJECT, str);
                }
                return -1L;
            }
        }
        throw new IllegalArgumentException();
    }

    private long getNumberObjectsAllSections() {
        return this.objects.values().stream().mapToLong(DictionarySection::getNumberOfElements).sum();
    }

    public long getNumberOfElements() {
        return this.subjects.getNumberOfElements() + this.predicates.getNumberOfElements() + this.getNumberObjectsAllSections() + this.shared.getNumberOfElements();
    }

    public long size() {
        return this.subjects.size() + this.predicates.size() + this.objects.values().stream().mapToLong(DictionarySection::size).sum() + this.shared.size();
    }

    public long getNsubjects() {
        return this.subjects.getNumberOfElements() + this.shared.getNumberOfElements();
    }

    public long getNpredicates() {
        return this.predicates.getNumberOfElements();
    }

    public long getNobjects() {
        return this.getNumberObjectsAllSections() + this.shared.getNumberOfElements();
    }

    public long getNshared() {
        return this.shared.getNumberOfElements();
    }

    public DictionarySection getSubjects() {
        return this.subjects;
    }

    public DictionarySection getPredicates() {
        return this.predicates;
    }

    public Map<? extends CharSequence, DictionarySection> getAllObjects() {
        return new TreeMap<ByteString, DictionarySection>((SortedMap<ByteString, DictionarySection>)this.objects);
    }

    public DictionarySection getObjects() {
        throw new NotImplementedException();
    }

    public DictionarySection getShared() {
        return this.shared;
    }

    private AbstractMap.SimpleEntry<CharSequence, DictionarySectionPrivate> getSection(long id, TripleComponentRole role) {
        switch (role) {
            case SUBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return new AbstractMap.SimpleEntry<CharSequence, DictionarySectionPrivate>(SectionUtil.SECTION, this.shared);
                }
                return new AbstractMap.SimpleEntry<CharSequence, DictionarySectionPrivate>(SectionUtil.SECTION, this.subjects);
            }
            case PREDICATE: {
                return new AbstractMap.SimpleEntry<CharSequence, DictionarySectionPrivate>(SectionUtil.SECTION, this.predicates);
            }
            case OBJECT: {
                if (id <= this.shared.getNumberOfElements()) {
                    return new AbstractMap.SimpleEntry<CharSequence, DictionarySectionPrivate>(SectionUtil.SECTION, this.shared);
                }
                Iterator<Map.Entry<ByteString, DictionarySectionPrivate>> hmIterator = this.objects.entrySet().iterator();
                DictionarySectionPrivate desiredSection = null;
                ByteString type = ByteString.empty();
                int count = 0;
                while (hmIterator.hasNext()) {
                    Map.Entry<ByteString, DictionarySectionPrivate> entry = hmIterator.next();
                    DictionarySectionPrivate subSection = entry.getValue();
                    count = (int)((long)count + subSection.getNumberOfElements());
                    if (id > this.shared.getNumberOfElements() + (long)count) continue;
                    desiredSection = subSection;
                    type = entry.getKey();
                    break;
                }
                return new AbstractMap.SimpleEntry<ByteString, Object>(type, desiredSection);
            }
        }
        throw new IllegalArgumentException();
    }

    public CharSequence idToString(long id, TripleComponentRole role) {
        AbstractMap.SimpleEntry<CharSequence, DictionarySectionPrivate> section = this.getSection(id, role);
        long localId = this.getLocalId(id, role);
        if (section.getKey().equals(LiteralsUtils.NO_DATATYPE) || section.getKey().equals(SectionUtil.SECTION)) {
            return section.getValue().extract(localId);
        }
        if (section.getValue() == null) {
            System.out.println("Error couldn't find the section for the given ID: [" + id + "]");
            return null;
        }
        CharSequence label = section.getValue().extract(localId);
        CharSequence dType = section.getKey();
        if (LiteralsUtils.containsLanguage(label)) {
            return label;
        }
        return label + "^^" + dType;
    }

    private DictionarySectionPrivate getSubSection(ByteString str) {
        return this.objects.get((ByteString)LiteralsUtils.getType(str));
    }

    public CharSequence dataTypeOfId(long id) {
        return this.getSection(id, TripleComponentRole.OBJECT).getKey();
    }

    public AbstractMap.SimpleEntry<Long, Long> getDataTypeRange(CharSequence dataType) {
        ByteString seq = LiteralsUtils.embed(ByteStringUtil.asByteString(dataType));
        if (this.objects.containsKey(seq)) {
            Iterator<Map.Entry<ByteString, DictionarySectionPrivate>> iter = this.objects.entrySet().iterator();
            int count = 0;
            while (iter.hasNext()) {
                Map.Entry<ByteString, DictionarySectionPrivate> entry = iter.next();
                count = (int)((long)count + entry.getValue().getNumberOfElements());
                if (!seq.equals(entry.getKey())) continue;
                count = (int)((long)count - entry.getValue().getNumberOfElements());
                break;
            }
            long offset = this.shared.getNumberOfElements() + (long)count;
            long size = offset + this.objects.get(seq).getNumberOfElements();
            return new AbstractMap.SimpleEntry<Long, Long>(offset + 1L, size);
        }
        return new AbstractMap.SimpleEntry<Long, Long>(0L, 0L);
    }
}

