/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.IOException;
import java.util.Iterator;
import org.rdfhdt.hdt.dictionary.impl.BaseTempDictionary;
import org.rdfhdt.hdt.dictionary.impl.DictionaryIDMapping;
import org.rdfhdt.hdt.dictionary.impl.section.HashDictionarySection;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.util.StopWatch;

public class HashDictionary
extends BaseTempDictionary {
    boolean isCustom;

    public HashDictionary(HDTOptions spec, boolean isCustom) {
        super(spec);
        this.isCustom = isCustom;
        this.subjects = new HashDictionarySection();
        this.predicates = new HashDictionarySection();
        this.objects = new HashDictionarySection(isCustom);
        this.shared = new HashDictionarySection();
    }

    @Override
    public void reorganize(TempTriples triples) {
        long j;
        DictionaryIDMapping mapSubj = new DictionaryIDMapping(this.subjects.getNumberOfElements());
        DictionaryIDMapping mapPred = new DictionaryIDMapping(this.predicates.getNumberOfElements());
        DictionaryIDMapping mapObj = new DictionaryIDMapping(this.objects.getNumberOfElements());
        StopWatch st = new StopWatch();
        Iterator<? extends CharSequence> itSubj = this.subjects.getEntries();
        while (itSubj.hasNext()) {
            CharSequence str = itSubj.next();
            mapSubj.add(str);
            if (str.length() <= 0 || str.charAt(0) == '\"' || this.objects.locate(str) == 0L) continue;
            this.shared.add(str);
        }
        st.reset();
        Iterator<? extends CharSequence> itPred = this.predicates.getEntries();
        while (itPred.hasNext()) {
            CharSequence str = itPred.next();
            mapPred.add(str);
        }
        Iterator<? extends CharSequence> itObj = this.objects.getEntries();
        while (itObj.hasNext()) {
            CharSequence str = itObj.next();
            mapObj.add(str);
        }
        Iterator<? extends CharSequence> itShared = this.shared.getEntries();
        while (itShared.hasNext()) {
            CharSequence sharedStr = itShared.next();
            this.subjects.remove(sharedStr);
            this.objects.remove(sharedStr);
        }
        st.reset();
        this.subjects.sort();
        this.predicates.sort();
        long startTime = System.currentTimeMillis();
        this.objects.sort();
        long endTime = System.currentTimeMillis();
        this.shared.sort();
        st.reset();
        for (j = 0L; j < mapSubj.size(); ++j) {
            mapSubj.setNewID(j, this.stringToId(mapSubj.getString(j), TripleComponentRole.SUBJECT));
        }
        for (j = 0L; j < mapPred.size(); ++j) {
            mapPred.setNewID(j, this.stringToId(mapPred.getString(j), TripleComponentRole.PREDICATE));
        }
        for (j = 0L; j < mapObj.size(); ++j) {
            mapObj.setNewID(j, this.stringToId(mapObj.getString(j), TripleComponentRole.OBJECT));
        }
        triples.replaceAllIds(mapSubj, mapPred, mapObj);
        this.isOrganized = true;
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void endProcessing() {
    }

    @Override
    public void close() throws IOException {
    }
}

