/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIntersection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.dictionary.impl.utilCat.SectionUtil;
import org.rdfhdt.hdt.dictionary.impl.utilDiff.DiffWrapper;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.string.ByteString;

public class FourSectionDictionaryDiff
implements DictionaryDiff {
    private final String location;
    private final Map<ByteString, CatMapping> allMappings = new HashMap<ByteString, CatMapping>();
    private CatMapping mappingBack;
    public long numShared;

    public FourSectionDictionaryDiff(String location) {
        this.location = location;
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtil.closeAll(this.allMappings.values());
        }
        catch (Throwable throwable) {
            IOUtil.closeAll(this.mappingBack);
            throw throwable;
        }
        IOUtil.closeAll(this.mappingBack);
    }

    @Override
    public void diff(Dictionary dictionary, Map<CharSequence, ModifiableBitmap> bitmaps, ProgressListener listener) throws IOException {
        int i;
        this.allMappings.put(SectionUtil.SECTION_PREDICATE, new CatMapping(this.location, SectionUtil.SECTION_PREDICATE, dictionary.getPredicates().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SECTION_SUBJECT, new CatMapping(this.location, SectionUtil.SECTION_SUBJECT, dictionary.getSubjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SECTION_OBJECT, new CatMapping(this.location, SectionUtil.SECTION_OBJECT, dictionary.getObjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SECTION_SHARED, new CatMapping(this.location, SectionUtil.SECTION_SHARED, dictionary.getShared().getNumberOfElements()));
        Bitmap predicatesBitMap = (Bitmap)bitmaps.get("P");
        Iterator predicates = dictionary.getPredicates().getSortedEntries();
        DiffWrapper itSkipPreds = new DiffWrapper(predicates, predicatesBitMap, SectionUtil.SECTION_PREDICATE);
        ArrayList<Iterator<CatElement>> listSkipPred = new ArrayList<Iterator<CatElement>>();
        listSkipPred.add(itSkipPreds);
        long numPreds = predicatesBitMap.countOnes();
        SectionUtil.createSection(this.location, numPreds, 4, new CatUnion(listSkipPred), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap subjectsBitMap = (Bitmap)bitmaps.get("S");
        Iterator subjects = dictionary.getSubjects().getSortedEntries();
        DiffWrapper itSkipSubs = new DiffWrapper(subjects, subjectsBitMap, SectionUtil.SECTION_SUBJECT);
        ArrayList<Iterator<CatElement>> listSkipSubj = new ArrayList<Iterator<CatElement>>();
        listSkipSubj.add(itSkipSubs);
        SharedWrapper sharedWrapper = new SharedWrapper(0, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        long numNewSubj = sharedWrapper.count();
        sharedWrapper = new SharedWrapper(0, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        listSkipSubj.add(sharedWrapper);
        long numSubj = subjectsBitMap.countOnes() + numNewSubj;
        SectionUtil.createSection(this.location, numSubj, 2, new CatUnion(listSkipSubj), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap objectsBitMap = (Bitmap)bitmaps.get("O");
        Iterator objects = dictionary.getObjects().getSortedEntries();
        DiffWrapper itSkipObjs = new DiffWrapper(objects, objectsBitMap, SectionUtil.SECTION_OBJECT);
        ArrayList<Iterator<CatElement>> listSkipObjs = new ArrayList<Iterator<CatElement>>();
        listSkipObjs.add(itSkipObjs);
        sharedWrapper = new SharedWrapper(1, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        long numNewObj = sharedWrapper.count();
        sharedWrapper = new SharedWrapper(1, (Bitmap)bitmaps.get("SH_S"), (Bitmap)bitmaps.get("SH_O"), dictionary.getShared().getSortedEntries());
        listSkipObjs.add(sharedWrapper);
        long numObject = objectsBitMap.countOnes() + numNewObj;
        SectionUtil.createSection(this.location, numObject, 3, new CatUnion(listSkipObjs), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        Bitmap sharedSubjBitMap = (Bitmap)bitmaps.get("SH_S");
        Bitmap sharedObjBitMap = (Bitmap)bitmaps.get("SH_O");
        Iterator shared = dictionary.getShared().getSortedEntries();
        DiffWrapper sharedSubj = new DiffWrapper(shared, sharedSubjBitMap, SectionUtil.SECTION_SHARED);
        shared = dictionary.getShared().getSortedEntries();
        DiffWrapper sharedObj = new DiffWrapper(shared, sharedObjBitMap, SectionUtil.SECTION_SHARED);
        ArrayList<Iterator<CatElement>> listShared = new ArrayList<Iterator<CatElement>>();
        listShared.add(new CatIntersection(sharedSubj, sharedObj));
        CatUnion union = new CatUnion(listShared);
        while (union.hasNext()) {
            union.next();
            ++this.numShared;
        }
        listShared = new ArrayList();
        sharedSubj = new DiffWrapper(dictionary.getShared().getSortedEntries(), sharedSubjBitMap, SectionUtil.SECTION_SHARED);
        sharedObj = new DiffWrapper(dictionary.getShared().getSortedEntries(), sharedObjBitMap, SectionUtil.SECTION_SHARED);
        listShared.add(new CatIntersection(sharedSubj, sharedObj));
        SectionUtil.createSection(this.location, this.numShared, 1, new CatUnion(listShared), new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, listener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat(dictionary.getType());
        ci.setInt("elements", numSubj + numPreds + numObject + this.numShared);
        try (FileOutputStream outFinal = new FileOutputStream(this.location + "dictionary");){
            ci.save(outFinal);
            for (i = 1; i <= 4; ++i) {
                int j = i;
                if (i == 4) {
                    j = 3;
                } else if (j == 3) {
                    j = 4;
                }
                Files.copy(Path.of(this.location + "section" + j, new String[0]), outFinal);
                Files.delete(Paths.get(this.location + "section" + j, new String[0]));
            }
        }
        this.mappingBack = new CatMapping(this.location, SectionUtil.BACK, numSubj + this.numShared);
        if (this.mappingBack.getSize() > 0L) {
            CatMapping sharedMapping = this.allMappings.get(SectionUtil.SECTION_SHARED);
            i = 0;
            while ((long)i < sharedMapping.getSize()) {
                long type = sharedMapping.getType(i);
                if (type == 1L) {
                    this.mappingBack.set(sharedMapping.getMapping(i) - 1L, i + 1, 1);
                } else if (type == 2L) {
                    this.mappingBack.set(sharedMapping.getMapping(i) + this.numShared - 1L, i + 1, 2);
                }
                ++i;
            }
            CatMapping subjectMapping = this.allMappings.get(SectionUtil.SECTION_SUBJECT);
            int i2 = 0;
            while ((long)i2 < subjectMapping.getSize()) {
                long type = subjectMapping.getType(i2);
                if (type == 1L) {
                    this.mappingBack.set(subjectMapping.getMapping(i2) - 1L, i2 + 1 + (int)dictionary.getNshared(), 1);
                } else if (type == 2L) {
                    this.mappingBack.set(subjectMapping.getMapping(i2) + this.numShared - 1L, i2 + 1 + (int)dictionary.getNshared(), 2);
                }
                ++i2;
            }
        }
    }

    @Override
    public Map<ByteString, CatMapping> getAllMappings() {
        return this.allMappings;
    }

    @Override
    public CatMapping getMappingBack() {
        return this.mappingBack;
    }

    @Override
    public long getNumShared() {
        return this.numShared;
    }

    private static class SharedWrapper
    implements Iterator<CatElement> {
        private final Bitmap bitmapSub;
        private final Bitmap bitmapObj;
        private final Iterator<? extends CharSequence> sectionIter;
        private final int flag;
        private CatElement next;
        private long count = 0L;

        public SharedWrapper(int flag, Bitmap bitmapSub, Bitmap bitmapObj, Iterator<? extends CharSequence> sectionIter) {
            this.bitmapSub = bitmapSub;
            this.bitmapObj = bitmapObj;
            this.sectionIter = sectionIter;
            this.flag = flag;
        }

        @Override
        public boolean hasNext() {
            while (this.sectionIter.hasNext()) {
                ByteString element = ByteString.of(this.sectionIter.next());
                if (this.flag == 0 && this.bitmapSub.access(this.count) && !this.bitmapObj.access(this.count) || this.flag == 1 && this.bitmapObj.access(this.count) && !this.bitmapSub.access(this.count)) {
                    ArrayList<CatElement.IteratorPlusPosition> IDs = new ArrayList<CatElement.IteratorPlusPosition>();
                    IDs.add(new CatElement.IteratorPlusPosition(SectionUtil.SECTION_SHARED, this.count + 1L));
                    this.next = new CatElement(element, IDs);
                    ++this.count;
                    return true;
                }
                ++this.count;
            }
            return false;
        }

        @Override
        public CatElement next() {
            return this.next;
        }

        public int count() {
            int i = 0;
            while (this.hasNext()) {
                ++i;
            }
            return i;
        }
    }
}

