/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryCat;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatElement;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatIntersection;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMapping;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatMappingBack;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatUnion;
import org.rdfhdt.hdt.dictionary.impl.utilCat.CatWrapper;
import org.rdfhdt.hdt.dictionary.impl.utilCat.SectionUtil;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.ControlInformation;
import org.rdfhdt.hdt.util.io.IOUtil;
import org.rdfhdt.hdt.util.listener.PrefixListener;
import org.rdfhdt.hdt.util.string.ByteString;

public class FourSectionDictionaryCat
implements DictionaryCat {
    private final Map<ByteString, CatMapping> allMappings = new HashMap<ByteString, CatMapping>();
    private final String location;
    private long numShared;
    private CatMappingBack mappingS;

    public FourSectionDictionaryCat(String location) {
        this.location = location;
    }

    @Override
    public void cat(Dictionary dictionary1, Dictionary dictionary2, ProgressListener listener) throws IOException {
        this.allMappings.put(SectionUtil.P1, new CatMapping(this.location, SectionUtil.P1, dictionary1.getPredicates().getNumberOfElements()));
        this.allMappings.put(SectionUtil.P2, new CatMapping(this.location, SectionUtil.P2, dictionary2.getPredicates().getNumberOfElements()));
        this.allMappings.put(SectionUtil.S1, new CatMapping(this.location, SectionUtil.S1, dictionary1.getSubjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.S2, new CatMapping(this.location, SectionUtil.S2, dictionary2.getSubjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.O1, new CatMapping(this.location, SectionUtil.O1, dictionary1.getObjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.O2, new CatMapping(this.location, SectionUtil.O2, dictionary2.getObjects().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SH1, new CatMapping(this.location, SectionUtil.SH1, dictionary1.getShared().getNumberOfElements()));
        this.allMappings.put(SectionUtil.SH2, new CatMapping(this.location, SectionUtil.SH2, dictionary2.getShared().getNumberOfElements()));
        PrefixListener iListener = PrefixListener.of("Generate predicates: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        int numCommonPredicates = 0;
        CatIntersection commonP1P2 = new CatIntersection(new CatWrapper(dictionary1.getPredicates().getSortedEntries(), SectionUtil.P1), new CatWrapper(dictionary2.getPredicates().getSortedEntries(), SectionUtil.P2));
        while (commonP1P2.hasNext()) {
            commonP1P2.next();
            ++numCommonPredicates;
        }
        long numPredicates = dictionary1.getPredicates().getNumberOfElements() + dictionary2.getPredicates().getNumberOfElements() - (long)numCommonPredicates;
        ArrayList<Iterator<CatElement>> addPredicatesList = new ArrayList<Iterator<CatElement>>();
        addPredicatesList.add(new CatWrapper(dictionary1.getPredicates().getSortedEntries(), SectionUtil.P1));
        addPredicatesList.add(new CatWrapper(dictionary2.getPredicates().getSortedEntries(), SectionUtil.P2));
        CatUnion itAddPredicates = new CatUnion(addPredicatesList);
        SectionUtil.createSection(this.location, numPredicates, 4, itAddPredicates, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, iListener);
        iListener = PrefixListener.of("Generate subjects: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        ArrayList<Iterator<CatElement>> skipSubjectList = new ArrayList<Iterator<CatElement>>();
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2)));
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1)));
        CatUnion skipSubject = new CatUnion(skipSubjectList);
        int numSkipSubjects = 0;
        while (skipSubject.hasNext()) {
            skipSubject.next();
            ++numSkipSubjects;
        }
        int numCommonSubjects = 0;
        CatIntersection commonS1S2 = new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2));
        while (commonS1S2.hasNext()) {
            commonS1S2.next();
            ++numCommonSubjects;
        }
        long numSubjects = dictionary1.getSubjects().getNumberOfElements() + dictionary2.getSubjects().getNumberOfElements() - (long)numCommonSubjects - (long)numSkipSubjects;
        skipSubjectList = new ArrayList();
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2)));
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        skipSubjectList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1)));
        skipSubject = new CatUnion(skipSubjectList);
        ArrayList<Iterator<CatElement>> addSubjectsList = new ArrayList<Iterator<CatElement>>();
        addSubjectsList.add(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1));
        addSubjectsList.add(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2));
        CatUnion itAddSubjects = new CatUnion(addSubjectsList);
        SectionUtil.createSection(this.location, numSubjects, 2, itAddSubjects, skipSubject, this.allMappings, 0L, iListener);
        iListener = PrefixListener.of("Generate objects: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        ArrayList<Iterator<CatElement>> skipObjectsList = new ArrayList<Iterator<CatElement>>();
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2)));
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2), new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1)));
        CatUnion skipObject = new CatUnion(skipObjectsList);
        int numSkipObjects = 0;
        while (skipObject.hasNext()) {
            skipObject.next();
            ++numSkipObjects;
        }
        int numCommonObjects = 0;
        CatIntersection commonO1O2 = new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2));
        while (commonO1O2.hasNext()) {
            commonO1O2.next();
            ++numCommonObjects;
        }
        skipObjectsList = new ArrayList();
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2)));
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        skipObjectsList.add(new CatIntersection(new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2), new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1)));
        skipObject = new CatUnion(skipObjectsList);
        long numObject = dictionary1.getObjects().getNumberOfElements() + dictionary2.getObjects().getNumberOfElements() - (long)numCommonObjects - (long)numSkipObjects;
        ArrayList<Iterator<CatElement>> addObjectsList = new ArrayList<Iterator<CatElement>>();
        addObjectsList.add(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1));
        addObjectsList.add(new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2));
        CatUnion itAddObjects = new CatUnion(addObjectsList);
        SectionUtil.createSection(this.location, numObject, 3, itAddObjects, skipObject, this.allMappings, 0L, iListener);
        iListener = PrefixListener.of("Generate shared: ", listener);
        if (iListener != null) {
            iListener.notifyProgress(0.0f, "start");
        }
        CatIntersection i2 = new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2));
        int numCommonS1O2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonS1O2;
        }
        i2 = new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2));
        int numCommonO1S2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonO1S2;
        }
        i2 = new CatIntersection(new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2));
        int numCommonSh1Sh2 = 0;
        while (i2.hasNext()) {
            i2.next();
            ++numCommonSh1Sh2;
        }
        this.numShared = dictionary1.getShared().getNumberOfElements() + dictionary2.getShared().getNumberOfElements() - (long)numCommonSh1Sh2 + (long)numCommonS1O2 + (long)numCommonO1S2;
        ArrayList<Iterator<CatElement>> addSharedList = new ArrayList<Iterator<CatElement>>();
        addSharedList.add(new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1));
        addSharedList.add(new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2)));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getSubjects().getSortedEntries(), SectionUtil.S1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1)));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getSubjects().getSortedEntries(), SectionUtil.S2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary1.getObjects().getSortedEntries(), SectionUtil.O1), new CatWrapper(dictionary2.getShared().getSortedEntries(), SectionUtil.SH2)));
        addSharedList.add(new CatIntersection(new CatWrapper(dictionary2.getObjects().getSortedEntries(), SectionUtil.O2), new CatWrapper(dictionary1.getShared().getSortedEntries(), SectionUtil.SH1)));
        CatUnion itAddShared = new CatUnion(addSharedList);
        SectionUtil.createSection(this.location, this.numShared, 1, itAddShared, new CatUnion(new ArrayList<Iterator<CatElement>>()), this.allMappings, 0L, iListener);
        ControlInformation ci = new ControlInformation();
        ci.setType(ControlInfo.Type.DICTIONARY);
        ci.setFormat("<http://purl.org/HDT/hdt#dictionaryFour>");
        ci.setInt("elements", numSubjects + numPredicates + numObject + this.numShared);
        try (FileOutputStream outFinal = new FileOutputStream(this.location + "dictionary");){
            ci.save(outFinal);
            for (int i = 1; i <= 4; ++i) {
                int j = i;
                if (i == 4) {
                    j = 3;
                } else if (j == 3) {
                    j = 4;
                }
                Files.copy(Path.of(this.location + "section" + j, new String[0]), outFinal);
                Files.delete(Paths.get(this.location + "section" + j, new String[0]));
            }
        }
        this.mappingS = new CatMappingBack(this.location, numSubjects + this.numShared);
        int i = 0;
        while ((long)i < this.allMappings.get(SectionUtil.SH1).getSize()) {
            this.mappingS.set(this.allMappings.get(SectionUtil.SH1).getMapping(i), i + 1, 1);
            ++i;
        }
        i = 0;
        while ((long)i < this.allMappings.get(SectionUtil.SH2).getSize()) {
            this.mappingS.set(this.allMappings.get(SectionUtil.SH2).getMapping(i), i + 1, 2);
            ++i;
        }
        i = 0;
        while ((long)i < this.allMappings.get(SectionUtil.S1).getSize()) {
            if (this.allMappings.get(SectionUtil.S1).getType(i) == 1L) {
                this.mappingS.set(this.allMappings.get(SectionUtil.S1).getMapping(i), i + 1 + (int)dictionary1.getNshared(), 1);
            } else {
                this.mappingS.set(this.allMappings.get(SectionUtil.S1).getMapping(i) + (long)((int)this.numShared), i + 1 + (int)dictionary1.getNshared(), 1);
            }
            ++i;
        }
        i = 0;
        while ((long)i < this.allMappings.get(SectionUtil.S2).getSize()) {
            if (this.allMappings.get(SectionUtil.S2).getType(i) == 1L) {
                this.mappingS.set(this.allMappings.get(SectionUtil.S2).getMapping(i), i + 1 + (int)dictionary2.getNshared(), 2);
            } else {
                this.mappingS.set(this.allMappings.get(SectionUtil.S2).getMapping(i) + (long)((int)this.numShared), i + 1 + (int)dictionary2.getNshared(), 2);
            }
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtil.closeAll(this.allMappings.values());
        }
        catch (Throwable throwable) {
            IOUtil.closeAll(this.mappingS);
            throw throwable;
        }
        IOUtil.closeAll(this.mappingS);
    }

    @Override
    public CatMappingBack getMappingS() {
        return this.mappingS;
    }

    @Override
    public Map<ByteString, CatMapping> getAllMappings() {
        return this.allMappings;
    }

    @Override
    public long getNumShared() {
        return this.numShared;
    }
}

