/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.function.Consumer;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.TempDictionarySection;
import org.rdfhdt.hdt.dictionary.impl.section.OneReadDictionarySection;
import org.rdfhdt.hdt.enums.TripleComponentRole;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.hdt.impl.diskimport.CompressionResult;
import org.rdfhdt.hdt.iterator.utils.MapIterator;
import org.rdfhdt.hdt.iterator.utils.NotificationExceptionIterator;
import org.rdfhdt.hdt.iterator.utils.PipedCopyIterator;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.triples.IndexedNode;
import org.rdfhdt.hdt.triples.TempTriples;
import org.rdfhdt.hdt.util.concurrent.ExceptionThread;
import org.rdfhdt.hdt.util.io.compress.CompressUtil;
import org.rdfhdt.hdt.util.string.CharSequenceComparator;
import org.rdfhdt.hdt.util.string.CompactString;
import org.rdfhdt.hdt.utils.DebugOrderNodeIterator;

public class CompressFourSectionDictionary
implements TempDictionary {
    private final ExceptionThread cfsdThread;
    private final TempDictionarySection subject;
    private final TempDictionarySection predicate;
    private final TempDictionarySection object;
    private final TempDictionarySection shared;

    private static void sendPiped(IndexedNode node, long index, PipedCopyIterator<CharSequence> pipe, CompressUtil.DuplicatedIterator it, NodeConsumerMethod method) {
        it.setLastHeader(index);
        method.consume(node.getIndex(), index);
        pipe.addElement(new CompactString(node.getNode()));
    }

    public CompressFourSectionDictionary(CompressionResult compressionResult, NodeConsumer nodeConsumer, ProgressListener listener, boolean debugOrder) {
        long splits = Math.max(20L, compressionResult.getTripleCount() / 10000L);
        Consumer<IndexedNode> debugOrderCheckerS = DebugOrderNodeIterator.of(debugOrder, "Subject");
        Consumer<IndexedNode> debugOrderCheckerO = DebugOrderNodeIterator.of(debugOrder, "Object");
        CompressUtil.DuplicatedIterator sortedSubject = CompressUtil.asNoDupeCharSequenceIterator(new NotificationExceptionIterator<IndexedNode, IOException>(compressionResult.getSubjects(), compressionResult.getTripleCount(), splits, "Subject section filling", listener), (originalIndex, duplicatedIndex, lastHeader) -> nodeConsumer.onSubject(duplicatedIndex, lastHeader));
        CompressUtil.DuplicatedIterator sortedPredicate = CompressUtil.asNoDupeCharSequenceIterator(new NotificationExceptionIterator<IndexedNode, IOException>(compressionResult.getPredicates(), compressionResult.getTripleCount(), splits, "Predicate section filling", listener), (originalIndex, duplicatedIndex, lastHeader) -> nodeConsumer.onPredicate(duplicatedIndex, lastHeader));
        CompressUtil.DuplicatedIterator sortedObject = CompressUtil.asNoDupeCharSequenceIterator(new NotificationExceptionIterator<IndexedNode, IOException>(compressionResult.getObjects(), compressionResult.getTripleCount(), splits, "Object section filling", listener), (originalIndex, duplicatedIndex, lastHeader) -> nodeConsumer.onObject(duplicatedIndex, lastHeader));
        long subjects = compressionResult.getSubjectsCount();
        long predicates = compressionResult.getPredicatesCount();
        long objects = compressionResult.getObjectsCount();
        long shareds = compressionResult.getSharedCount();
        PipedCopyIterator subject = new PipedCopyIterator();
        PipedCopyIterator object = new PipedCopyIterator();
        PipedCopyIterator shared = new PipedCopyIterator();
        Comparator<CharSequence> comparator = CharSequenceComparator.getInstance();
        this.cfsdThread = new ExceptionThread(() -> {
            try {
                IndexedNode next;
                long sharedId = 1L;
                long subjectId = 1L;
                long objectId = 1L;
                block2: while (sortedObject.hasNext() && sortedSubject.hasNext()) {
                    IndexedNode newSubject = sortedSubject.next();
                    IndexedNode newObject = sortedObject.next();
                    debugOrderCheckerS.accept(newSubject);
                    debugOrderCheckerO.accept(newObject);
                    int comp = comparator.compare(newSubject.getNode(), newObject.getNode());
                    while (comp != 0) {
                        if (comp < 0) {
                            long l = subjectId++;
                            CompressFourSectionDictionary.sendPiped(newSubject, CompressUtil.getHeaderId(l), subject, sortedSubject, nodeConsumer::onSubject);
                            if (!sortedSubject.hasNext()) {
                                long l2 = objectId++;
                                CompressFourSectionDictionary.sendPiped(newObject, CompressUtil.getHeaderId(l2), object, sortedObject, nodeConsumer::onObject);
                                break block2;
                            }
                            newSubject = sortedSubject.next();
                            debugOrderCheckerS.accept(newSubject);
                        } else {
                            long l = objectId++;
                            CompressFourSectionDictionary.sendPiped(newObject, CompressUtil.getHeaderId(l), object, sortedObject, nodeConsumer::onObject);
                            if (!sortedObject.hasNext()) {
                                long l3 = subjectId++;
                                CompressFourSectionDictionary.sendPiped(newSubject, CompressUtil.getHeaderId(l3), subject, sortedSubject, nodeConsumer::onSubject);
                                break block2;
                            }
                            newObject = sortedObject.next();
                            debugOrderCheckerO.accept(newObject);
                        }
                        comp = comparator.compare(newSubject.getNode(), newObject.getNode());
                    }
                    long shid = CompressUtil.asShared(sharedId++);
                    sortedSubject.setLastHeader(shid);
                    sortedObject.setLastHeader(shid);
                    nodeConsumer.onSubject(newSubject.getIndex(), shid);
                    nodeConsumer.onObject(newObject.getIndex(), shid);
                    shared.addElement(new CompactString(newSubject.getNode()));
                }
                shared.closePipe();
                while (sortedSubject.hasNext()) {
                    next = sortedSubject.next();
                    debugOrderCheckerS.accept(next);
                    long l = subjectId++;
                    CompressFourSectionDictionary.sendPiped(next, CompressUtil.getHeaderId(l), subject, sortedSubject, nodeConsumer::onSubject);
                }
                subject.closePipe();
                while (sortedObject.hasNext()) {
                    next = sortedObject.next();
                    debugOrderCheckerO.accept(next);
                    long l = objectId++;
                    CompressFourSectionDictionary.sendPiped(next, CompressUtil.getHeaderId(l), object, sortedObject, nodeConsumer::onObject);
                }
                object.closePipe();
            }
            catch (Throwable t) {
                object.closePipe(t);
                subject.closePipe(t);
                shared.closePipe(t);
                throw t;
            }
        }, "CFSDPipeBuilder").startAll();
        this.subject = new OneReadDictionarySection(subject, subjects);
        this.predicate = new OneReadDictionarySection(new MapIterator<IndexedNode, CompactString>(sortedPredicate, (node, index) -> {
            long header = CompressUtil.getHeaderId(index + 1L);
            sortedPredicate.setLastHeader(header);
            nodeConsumer.onPredicate(node.getIndex(), header);
            return new CompactString(node.getNode());
        }), predicates);
        this.object = new OneReadDictionarySection(object, objects);
        this.shared = new OneReadDictionarySection(shared, shareds);
    }

    @Override
    public TempDictionarySection getSubjects() {
        return this.subject;
    }

    @Override
    public TempDictionarySection getPredicates() {
        return this.predicate;
    }

    @Override
    public TempDictionarySection getObjects() {
        return this.object;
    }

    @Override
    public TempDictionarySection getShared() {
        return this.shared;
    }

    @Override
    public void startProcessing() {
    }

    @Override
    public void endProcessing() {
    }

    @Override
    public long insert(CharSequence str, TripleComponentRole position) {
        throw new NotImplementedException();
    }

    @Override
    public void reorganize() {
    }

    @Override
    public void reorganize(TempTriples triples) {
    }

    @Override
    public boolean isOrganized() {
        return true;
    }

    @Override
    public void clear() {
    }

    @Override
    public long stringToId(CharSequence subject, TripleComponentRole role) {
        throw new NotImplementedException();
    }

    @Override
    public void close() throws IOException {
        try {
            this.cfsdThread.interrupt();
            this.cfsdThread.joinAndCrashIfRequired();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static interface NodeConsumerMethod {
        public void consume(long var1, long var3);
    }

    public static interface NodeConsumer {
        public void onSubject(long var1, long var3);

        public void onPredicate(long var1, long var3);

        public void onObject(long var1, long var3);
    }
}

