/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.dictionary;

import java.nio.file.Path;
import java.util.TreeMap;
import org.rdfhdt.hdt.dictionary.Dictionary;
import org.rdfhdt.hdt.dictionary.DictionaryDiff;
import org.rdfhdt.hdt.dictionary.DictionaryKCat;
import org.rdfhdt.hdt.dictionary.DictionaryPrivate;
import org.rdfhdt.hdt.dictionary.DictionarySectionPrivate;
import org.rdfhdt.hdt.dictionary.TempDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionaryBig;
import org.rdfhdt.hdt.dictionary.impl.FourSectionDictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.HashDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.MultipleSectionDictionaryDiff;
import org.rdfhdt.hdt.dictionary.impl.PSFCFourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.PSFCTempDictionary;
import org.rdfhdt.hdt.dictionary.impl.WriteFourSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.WriteMultipleSectionDictionary;
import org.rdfhdt.hdt.dictionary.impl.kcat.FourSectionDictionaryKCat;
import org.rdfhdt.hdt.dictionary.impl.kcat.MultipleSectionDictionaryKCat;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.hdt.impl.diskimport.MultiSectionSectionCompressor;
import org.rdfhdt.hdt.hdt.impl.diskimport.SectionCompressor;
import org.rdfhdt.hdt.iterator.utils.AsyncIteratorFetcher;
import org.rdfhdt.hdt.listener.MultiThreadListener;
import org.rdfhdt.hdt.options.ControlInfo;
import org.rdfhdt.hdt.options.HDTOptions;
import org.rdfhdt.hdt.options.HDTSpecification;
import org.rdfhdt.hdt.triples.TripleString;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.string.ByteString;

public class DictionaryFactory {
    @Deprecated
    public static final String MOD_DICT_IMPL_HASH = "hash";
    @Deprecated
    public static final String MOD_DICT_IMPL_MULT_HASH = "multHash";
    @Deprecated
    public static final String MOD_DICT_IMPL_HASH_PSFC = "hashPsfc";
    @Deprecated
    public static final String DICTIONARY_TYPE_FOUR_SECTION_BIG = "dictionaryFourBig";
    @Deprecated
    public static final String DICTIONARY_TYPE_MULTI_OBJECTS = "dictionaryMultiObj";

    private DictionaryFactory() {
    }

    public static Dictionary createDefaultDictionary() throws IllegalArgumentException {
        return new FourSectionDictionary(new HDTSpecification());
    }

    public static TempDictionary createTempDictionary(HDTOptions spec) {
        String name;
        switch (name = spec.get("tempDictionary.impl", "")) {
            case "": 
            case "hash": {
                return new HashDictionary(spec, false);
            }
            case "hashPsfc": {
                return new PSFCTempDictionary(new HashDictionary(spec, false));
            }
            case "multHash": {
                return new HashDictionary(spec, true);
            }
        }
        throw new IllegalFormatException("Implementation of triples not found for " + name);
    }

    public static DictionaryPrivate createDictionary(HDTOptions spec) {
        String name;
        switch (name = spec.get("dictionary.type", "")) {
            case "": 
            case "<http://purl.org/HDT/hdt#dictionaryFour>": {
                return new FourSectionDictionary(spec);
            }
            case "<http://purl.org/HDT/hdt#dictionaryFourPsfc>": {
                return new PSFCFourSectionDictionary(spec);
            }
            case "dictionaryFourBig": {
                return new FourSectionDictionaryBig(spec);
            }
            case "dictionaryMultiObj": {
                return new MultipleSectionDictionary(spec);
            }
        }
        throw new IllegalFormatException("Implementation of dictionary not found for " + name);
    }

    public static DictionaryPrivate createWriteDictionary(HDTOptions spec, Path location, int bufferSize) {
        String name;
        switch (name = spec.get("dictionary.type", "")) {
            case "": 
            case "<http://purl.org/HDT/hdt#dictionaryFour>": 
            case "dictionaryFourBig": {
                return new WriteFourSectionDictionary(spec, location, bufferSize);
            }
            case "dictionaryMultiObj": {
                return new WriteMultipleSectionDictionary(spec, location, bufferSize);
            }
        }
        throw new IllegalFormatException("Implementation of write dictionary not found for " + name);
    }

    public static DictionaryPrivate createWriteDictionary(String name, HDTOptions spec, Path location, int bufferSize) {
        switch (name) {
            case "": 
            case "<http://purl.org/HDT/hdt#dictionaryFour>": {
                return new WriteFourSectionDictionary(spec, location, bufferSize);
            }
            case "<http://purl.org/HDT/hdt#dictionaryMult>": {
                return new WriteMultipleSectionDictionary(spec, location, bufferSize);
            }
        }
        throw new IllegalFormatException("Implementation of write dictionary not found for " + name);
    }

    public static SectionCompressor createSectionCompressor(HDTOptions spec, CloseSuppressPath baseFileName, AsyncIteratorFetcher<TripleString> source, MultiThreadListener listener, int bufferSize, long chunkSize, int k, boolean debugSleepKwayDict) {
        String name;
        switch (name = spec.get("dictionary.type", "")) {
            case "": 
            case "<http://purl.org/HDT/hdt#dictionaryFour>": 
            case "dictionaryFourBig": {
                return new SectionCompressor(baseFileName, source, listener, bufferSize, chunkSize, k, debugSleepKwayDict);
            }
            case "dictionaryMultiObj": {
                return new MultiSectionSectionCompressor(baseFileName, source, listener, bufferSize, chunkSize, k, debugSleepKwayDict);
            }
        }
        throw new IllegalFormatException("Implementation of section compressor not found for " + name);
    }

    public static DictionaryPrivate createDictionary(ControlInfo ci) {
        String name;
        switch (name = ci.getFormat()) {
            case "<http://purl.org/HDT/hdt#dictionaryFour>": {
                return new FourSectionDictionary(new HDTSpecification());
            }
            case "<http://purl.org/HDT/hdt#dictionaryFourPsfc>": {
                return new PSFCFourSectionDictionary(new HDTSpecification());
            }
            case "<http://purl.org/HDT/hdt#dictionaryMult>": {
                return new MultipleSectionDictionary(new HDTSpecification());
            }
        }
        throw new IllegalFormatException("Implementation of dictionary not found for " + name);
    }

    public static DictionaryDiff createDictionaryDiff(Dictionary dictionary, String location) {
        String type;
        switch (type = dictionary.getType()) {
            case "<http://purl.org/HDT/hdt#dictionaryFour>": 
            case "<http://purl.org/HDT/hdt#dictionaryFourPsfc>": {
                return new FourSectionDictionaryDiff(location);
            }
            case "<http://purl.org/HDT/hdt#dictionaryMult>": {
                return new MultipleSectionDictionaryDiff(location);
            }
        }
        throw new IllegalFormatException("Implementation of DictionaryDiff not found for " + type);
    }

    public static DictionaryKCat createDictionaryKCat(Dictionary dictionary) {
        String type;
        switch (type = dictionary.getType()) {
            case "<http://purl.org/HDT/hdt#dictionaryFour>": {
                return new FourSectionDictionaryKCat(dictionary);
            }
            case "<http://purl.org/HDT/hdt#dictionaryMult>": {
                return new MultipleSectionDictionaryKCat(dictionary);
            }
        }
        throw new IllegalArgumentException("Implementation of DictionaryKCat not found for " + type);
    }

    public static DictionaryPrivate createWriteDictionary(String type, HDTOptions spec, DictionarySectionPrivate subject, DictionarySectionPrivate predicate, DictionarySectionPrivate object, DictionarySectionPrivate shared, TreeMap<ByteString, DictionarySectionPrivate> sub) {
        switch (type) {
            case "<http://purl.org/HDT/hdt#dictionaryFour>": 
            case "<http://purl.org/HDT/hdt#dictionaryFourPsfc>": {
                return new WriteFourSectionDictionary(spec, subject, predicate, object, shared);
            }
            case "<http://purl.org/HDT/hdt#dictionaryMult>": {
                return new WriteMultipleSectionDictionary(spec, subject, predicate, shared, sub);
            }
        }
        throw new IllegalArgumentException("Unknown dictionary type " + type);
    }
}

