/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.compact.sequence.DynamicSequence;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.disk.LongArrayDisk;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SequenceLog64BigDisk
implements DynamicSequence,
Closeable {
    private static final byte W = 64;
    private static final int INDEX = 0x40000000;
    LongArray data;
    private int numbits;
    private long numentries = 0L;
    private long maxvalue;

    public SequenceLog64BigDisk(String location) {
        this(location, 64);
    }

    public SequenceLog64BigDisk(String location, int numbits) {
        this(location, numbits, 0L);
    }

    public SequenceLog64BigDisk(String location, int numbits, long capacity) {
        this(location, numbits, capacity, false);
    }

    public SequenceLog64BigDisk(String location, int numbits, long capacity, boolean initialize) {
        this(Path.of(location, new String[0]), numbits, capacity, initialize);
    }

    public SequenceLog64BigDisk(Path location) {
        this(location, 64);
    }

    public SequenceLog64BigDisk(Path location, int numbits) {
        this(location, numbits, 0L);
    }

    public SequenceLog64BigDisk(Path location, int numbits, long capacity) {
        this(location, numbits, capacity, false);
    }

    public SequenceLog64BigDisk(Path location, int numbits, long capacity, boolean initialize) {
        this(location, numbits, capacity, initialize, true);
    }

    public SequenceLog64BigDisk(Path location, int numbits, long capacity, boolean initialize, boolean overwrite) {
        this.numbits = numbits;
        this.maxvalue = BitUtil.maxVal(numbits);
        long size = SequenceLog64BigDisk.numWordsFor(numbits, capacity);
        this.data = new LongArrayDisk(location, Math.max(size, 1L), overwrite);
        if (initialize) {
            this.numentries = capacity;
        }
    }

    public static long numWordsFor(int bitsField, long total) {
        return ((long)bitsField * total + 63L) / 64L;
    }

    public static long lastWordNumBits(int bitsField, long total) {
        long totalBits = (long)bitsField * total;
        if (totalBits == 0L) {
            return 0L;
        }
        return (totalBits - 1L) % 64L + 1L;
    }

    public static long lastWordNumBytes(int bitsField, long total) {
        return (SequenceLog64BigDisk.lastWordNumBits(bitsField, total) - 1L) / 8L + 1L;
    }

    public static long numBytesFor(int bitsField, long total) {
        return ((long)bitsField * total + 7L) / 8L;
    }

    private static long getField(LongArray data, int bitsField, long index) {
        long result;
        if (bitsField == 0) {
            return 0L;
        }
        long bitPos = index * (long)bitsField;
        long i = bitPos / 64L;
        long j = bitPos % 64L;
        if (j + (long)bitsField <= 64L) {
            result = data.get(i) << (int)(64L - j - (long)bitsField) >>> 64 - bitsField;
        } else {
            result = data.get(i) >>> (int)j;
            result |= data.get(i + 1L) << (int)(128L - j - (long)bitsField) >>> 64 - bitsField;
        }
        return result;
    }

    private static void setField(LongArray data, int bitsField, long index, long value) {
        if (bitsField == 0) {
            return;
        }
        long bitPos = index * (long)bitsField;
        long i = bitPos / 64L;
        long j = bitPos % 64L;
        long mask = (-1L << bitsField ^ 0xFFFFFFFFFFFFFFFFL) << (int)j;
        data.set(i, data.get(i) & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value << (int)j);
        if (j + (long)bitsField > 64L) {
            mask = -1L << (int)((long)bitsField + j - 64L);
            data.set(i + 1L, data.get(i + 1L) & mask | value >>> (int)(64L - j));
        }
    }

    private void resizeArray(long size) throws IOException {
        this.data.resize(size);
    }

    @Override
    public void add(Iterator<Long> elements) {
    }

    public void addIntegers(ArrayList<Integer> elements) {
    }

    @Override
    public long get(long position) {
        if (position < 0L || SequenceLog64BigDisk.numWordsFor(this.numbits, position) > this.data.length()) {
            throw new IndexOutOfBoundsException(position + " < 0 || " + position + " > " + this.data.length() * 64L / (long)this.numbits);
        }
        return SequenceLog64BigDisk.getField(this.data, this.numbits, position);
    }

    @Override
    public void set(long position, long value) {
        if (value < 0L || value > this.maxvalue) {
            throw new IllegalArgumentException("Value exceeds the maximum for this data structure " + value + " > " + this.maxvalue);
        }
        SequenceLog64BigDisk.setField(this.data, this.numbits, position, value);
    }

    @Override
    public int sizeOf() {
        return this.numbits;
    }

    @Override
    public void append(long value) {
        long neededSize = SequenceLog64BigDisk.numWordsFor(this.numbits, this.numentries + 1L);
        if (this.data.length() < neededSize) {
            try {
                this.resizeArray(this.data.length() * 2L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.set(this.numentries, value);
        ++this.numentries;
    }

    @Override
    public void aggressiveTrimToSize() {
        long max = 0L;
        for (long i = 0L; i < this.numentries; ++i) {
            long value = this.get(i);
            if (value <= max) continue;
            max = value;
        }
        int newbits = BitUtil.log2(max);
        assert (newbits <= this.numbits);
        if (newbits != this.numbits) {
            for (long i = 0L; i < this.numentries; ++i) {
                long value = SequenceLog64BigDisk.getField(this.data, this.numbits, i);
                SequenceLog64BigDisk.setField(this.data, newbits, i, value);
            }
            this.numbits = newbits;
            this.maxvalue = BitUtil.maxVal(this.numbits);
            long totalSize = SequenceLog64BigDisk.numWordsFor(this.numbits, this.numentries);
            if (totalSize != this.data.length()) {
                try {
                    this.resizeArray(totalSize);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void trimToSize() {
        try {
            this.resizeArray(SequenceLog64BigDisk.numWordsFor(this.numbits, this.numentries));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resize(long numentries) {
        this.numentries = numentries;
        try {
            this.resizeArray(SequenceLog64BigDisk.numWordsFor(this.numbits, numentries));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public long getNumberOfElements() {
        return this.numentries;
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        out.write(this.numbits);
        VByte.encode(out, this.numentries);
        out.writeCRC();
        out.setCRC(new CRC32());
        long numwords = SequenceLog64BigDisk.numWordsFor(this.numbits, this.numentries);
        for (long i = 0L; i < numwords - 1L; ++i) {
            IOUtil.writeLong(out, this.data.get(i));
        }
        if (numwords > 0L) {
            long lastWordUsedBits = SequenceLog64BigDisk.lastWordNumBits(this.numbits, this.numentries);
            BitUtil.writeLowerBitsByteAligned(this.data.get(numwords - 1L), lastWordUsedBits, out);
        }
        out.writeCRC();
    }

    @Override
    public void load(InputStream input, ProgressListener listener) {
    }

    @Override
    public long size() {
        return SequenceLog64BigDisk.numBytesFor(this.numbits, this.numentries);
    }

    public long getRealSize() {
        return this.data.length() * 8L;
    }

    public int getNumBits() {
        return this.numbits;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#seqLog>";
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeObject(this.data);
        this.data = null;
    }
}

