/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.sequence;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.compact.sequence.SequenceInt32;
import org.rdfhdt.hdt.compact.sequence.SequenceInt64;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Big;
import org.rdfhdt.hdt.compact.sequence.SequenceLog64Map;
import org.rdfhdt.hdt.exceptions.IllegalFormatException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.util.io.CountInputStream;

public class SequenceFactory {
    public static final byte TYPE_SEQLOG = 1;
    public static final byte TYPE_SEQ32 = 2;
    public static final byte TYPE_SEQ64 = 3;

    private SequenceFactory() {
    }

    public static Sequence createStream(String name) {
        if (name == null) {
            return new SequenceLog64Big();
        }
        if (name.equals("<http://purl.org/HDT/hdt#seqInt32>")) {
            return new SequenceInt32();
        }
        if (name.equals("<http://purl.org/HDT/hdt#seqInt64>")) {
            return new SequenceInt64();
        }
        if (name.equals("<http://purl.org/HDT/hdt#seqLog>")) {
            return new SequenceLog64Big();
        }
        return new SequenceLog64Big();
    }

    public static Sequence createStream(InputStream input) throws IOException {
        input.mark(1);
        int type = input.read();
        input.reset();
        switch (type) {
            case 1: {
                return new SequenceLog64Big();
            }
            case 2: {
                return new SequenceInt32();
            }
            case 3: {
                return new SequenceLog64Big();
            }
        }
        throw new IllegalFormatException("Implementation not found for Sequence with code " + type);
    }

    public static Sequence createStream(CountInputStream input, File f) throws IOException {
        input.mark(1);
        int type = input.read();
        input.reset();
        switch (type) {
            case 1: {
                return new SequenceLog64Map(input, f);
            }
            case 2: 
            case 3: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalFormatException("Implementation not found for Sequence with code " + type);
    }
}

