/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.integer;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.rdfhdt.hdt.util.Mutable;
import org.rdfhdt.hdt.util.io.BigByteBuffer;
import org.rdfhdt.hdt.util.io.BigMappedByteBuffer;

public class VByte {
    private VByte() {
    }

    public static void encodeSigned(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            VByte.encode(out, value << 1 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            VByte.encode(out, value << 1);
        }
    }

    public static long decodeSigned(InputStream in) throws IOException {
        long decode = VByte.decode(in);
        if ((decode & 1L) == 0L) {
            return decode >>> 1;
        }
        return decode >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static void encode(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            throw new IllegalArgumentException("Only can encode VByte of positive values");
        }
        while (value > 127L) {
            out.write((int)(value & 0x7FL));
            value >>>= 7;
        }
        out.write((int)(value | 0x80L));
    }

    public static long decode(InputStream in) throws IOException {
        long out = 0L;
        int shift = 0;
        long readbyte = in.read();
        if (readbyte == -1L) {
            throw new EOFException();
        }
        while ((readbyte & 0x80L) == 0L) {
            if (shift >= 50) {
                throw new IllegalArgumentException("Read more bytes than required to load the max long");
            }
            out |= (readbyte & 0x7FL) << shift;
            readbyte = in.read();
            if (readbyte == -1L) {
                throw new EOFException();
            }
            shift += 7;
        }
        return out |= (readbyte & 0x7FL) << shift;
    }

    public static long decode(ByteBuffer in) throws IOException {
        long out = 0L;
        int shift = 0;
        if (!in.hasRemaining()) {
            throw new EOFException();
        }
        byte readbyte = in.get();
        while ((readbyte & 0x80) == 0) {
            if (shift >= 50) {
                throw new IllegalArgumentException("Read more bytes than required to load the max long");
            }
            out |= ((long)readbyte & 0x7FL) << shift;
            if (!in.hasRemaining()) {
                throw new EOFException();
            }
            readbyte = in.get();
            shift += 7;
        }
        return out |= ((long)readbyte & 0x7FL) << shift;
    }

    public static long decode(BigMappedByteBuffer in) throws IOException {
        long out = 0L;
        int shift = 0;
        if (!in.hasRemaining()) {
            throw new EOFException();
        }
        byte readbyte = in.get();
        while ((readbyte & 0x80) == 0) {
            if (shift >= 50) {
                throw new IllegalArgumentException("Read more bytes than required to load the max long");
            }
            out |= ((long)readbyte & 0x7FL) << shift;
            if (!in.hasRemaining()) {
                throw new EOFException();
            }
            readbyte = in.get();
            shift += 7;
        }
        return out |= ((long)readbyte & 0x7FL) << shift;
    }

    public static int encode(byte[] data, int offset, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Only can encode VByte of positive values");
        }
        int i = 0;
        while (value > 127) {
            data[offset + i] = (byte)(value & 0x7F);
            ++i;
            value >>>= 7;
        }
        data[offset + i] = (byte)(value | 0x80);
        return ++i;
    }

    public static int decode(byte[] data, int offset, Mutable<Long> value) {
        long out = 0L;
        int i = 0;
        int shift = 0;
        while ((0x80 & data[offset + i]) == 0) {
            assert (shift < 50) : "Read more bytes than required to load the max long";
            out |= ((long)data[offset + i] & 0x7FL) << shift;
            ++i;
            shift += 7;
        }
        out |= ((long)data[offset + i] & 0x7FL) << shift;
        value.setValue(out);
        return ++i;
    }

    public static int decode(BigByteBuffer data, long offset, Mutable<Long> value) {
        long out = 0L;
        int i = 0;
        int shift = 0;
        while ((0x80 & data.get(offset + (long)i)) == 0) {
            assert (shift < 50) : "Read more bytes than required to load the max long";
            out |= ((long)data.get(offset + (long)i) & 0x7FL) << shift;
            ++i;
            shift += 7;
        }
        out |= ((long)data.get(offset + (long)i) & 0x7FL) << shift;
        value.setValue(out);
        return ++i;
    }

    public static void show(byte[] data, int len) {
        for (int i = 0; i < len; ++i) {
            System.out.print(Long.toHexString(data[i] & 0xFF) + " ");
        }
    }
}

