/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.io.IOUtil;

public class SyncBitmap<T extends Bitmap>
implements Bitmap,
Closeable {
    protected final T bitmap;

    public static Bitmap of(Bitmap bitmap) {
        if (bitmap instanceof SyncBitmap) {
            return bitmap;
        }
        if (bitmap instanceof ModifiableBitmap) {
            return new SyncModBitmap<ModifiableBitmap>((ModifiableBitmap)bitmap);
        }
        return new SyncBitmap<Bitmap>(bitmap);
    }

    public static ModifiableBitmap of(ModifiableBitmap bitmap) {
        if (bitmap instanceof SyncBitmap) {
            return bitmap;
        }
        return new SyncModBitmap<ModifiableBitmap>(bitmap);
    }

    private SyncBitmap(T bitmap) {
        this.bitmap = bitmap;
    }

    public synchronized boolean access(long position) {
        return this.bitmap.access(position);
    }

    public synchronized long rank1(long position) {
        return this.bitmap.rank1(position);
    }

    public synchronized long rank0(long position) {
        return this.bitmap.rank0(position);
    }

    public synchronized long selectPrev1(long start) {
        return this.bitmap.selectPrev1(start);
    }

    public synchronized long selectNext1(long start) {
        return this.bitmap.selectNext1(start);
    }

    public synchronized long select0(long n) {
        return this.bitmap.select0(n);
    }

    public synchronized long select1(long n) {
        return this.bitmap.select1(n);
    }

    public synchronized long getNumBits() {
        return this.bitmap.getNumBits();
    }

    public synchronized long countOnes() {
        return this.bitmap.countOnes();
    }

    public synchronized long countZeros() {
        return this.bitmap.countZeros();
    }

    public synchronized long getSizeBytes() {
        return this.bitmap.getSizeBytes();
    }

    public synchronized void save(OutputStream output, ProgressListener listener) throws IOException {
        this.bitmap.save(output, listener);
    }

    public synchronized void load(InputStream input, ProgressListener listener) throws IOException {
        this.bitmap.load(input, listener);
    }

    public synchronized String getType() {
        return this.bitmap.getType();
    }

    @Override
    public void close() throws IOException {
        IOUtil.closeObject(this.bitmap);
    }

    private static class SyncModBitmap<T extends ModifiableBitmap>
    extends SyncBitmap<T>
    implements ModifiableBitmap {
        protected SyncModBitmap(T bitmap) {
            super(bitmap);
        }

        public synchronized void set(long position, boolean value) {
            ((ModifiableBitmap)this.bitmap).set(position, value);
        }

        public synchronized void append(boolean value) {
            ((ModifiableBitmap)this.bitmap).append(value);
        }
    }
}

