/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;

public class NegBitmap<T extends Bitmap>
implements Bitmap,
Closeable {
    protected final T handle;

    public static Bitmap of(Bitmap bitmap) {
        return new NegBitmap<Bitmap>(bitmap);
    }

    public static ModifiableBitmap of(ModifiableBitmap modifiableBitmap) {
        return new NegModifiableBitmap(modifiableBitmap);
    }

    private NegBitmap(T handle) {
        this.handle = handle;
    }

    public boolean access(long position) {
        return !this.handle.access(position);
    }

    public long rank1(long position) {
        return this.handle.rank0(position);
    }

    public long rank0(long position) {
        return this.handle.rank1(position);
    }

    public long selectPrev1(long start) {
        throw new NotImplementedException();
    }

    public long selectNext1(long start) {
        throw new NotImplementedException();
    }

    public long select0(long n) {
        return this.handle.select1(n);
    }

    public long select1(long n) {
        return this.handle.select0(n);
    }

    public long getNumBits() {
        return this.handle.getNumBits();
    }

    public long countOnes() {
        return this.handle.countZeros();
    }

    public long countZeros() {
        return this.handle.countOnes();
    }

    public long getSizeBytes() {
        return this.handle.getSizeBytes();
    }

    public void save(OutputStream output, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    public void load(InputStream input, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    public String getType() {
        return this.handle.getType();
    }

    @Override
    public void close() throws IOException {
        if (this.handle instanceof Closeable) {
            ((Closeable)this.handle).close();
        }
    }

    private static class NegModifiableBitmap
    extends NegBitmap<ModifiableBitmap>
    implements ModifiableBitmap {
        private NegModifiableBitmap(ModifiableBitmap handle) {
            super(handle);
        }

        public void set(long position, boolean value) {
            ((ModifiableBitmap)this.handle).set(position, !value);
        }

        public void append(boolean value) {
            ((ModifiableBitmap)this.handle).append(!value);
        }
    }
}

