/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.IOUtil;

public class EmptyBitmap
implements ModifiableBitmap {
    private long size;

    public static ModifiableBitmap of(long size) {
        return new EmptyBitmap(size);
    }

    private EmptyBitmap(long size) {
        this.size = size;
    }

    public void append(boolean value) {
        this.set(this.size, value);
    }

    public void set(long pos, boolean value) {
        if (value) {
            throw new NotImplementedException("true value in EmptyBitmap");
        }
        this.size = Math.max(this.size, pos);
    }

    public boolean access(long pos) {
        return false;
    }

    public long rank1(long pos) {
        return 0L;
    }

    public long rank0(long pos) {
        return pos;
    }

    public long selectPrev1(long start) {
        return -1L;
    }

    public long selectNext1(long start) {
        return -1L;
    }

    public long select0(long n) {
        return n;
    }

    public long select1(long n) {
        return -1L;
    }

    public long getNumBits() {
        return this.size;
    }

    public long countOnes() {
        return 0L;
    }

    public long countZeros() {
        return this.size;
    }

    public long getSizeBytes() {
        return 0L;
    }

    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        VByte.encode(out, 8L);
        out.writeCRC();
        out.setCRC(new CRC32());
        IOUtil.writeLong(out, 0L);
        out.writeCRC();
    }

    public void load(InputStream input, ProgressListener listener) {
        throw new NotImplementedException();
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#bitmapPlain>";
    }
}

