/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.compact.bitmap.SyncBitmap;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.CRCException;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCInputStream;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.disk.LargeLongArray;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.disk.LongArrayDisk;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.io.IOUtil;

public class Bitmap64Big
implements Closeable,
ModifiableBitmap {
    protected static final int LOGW = 6;
    protected static final int W = 64;
    protected long numbits = 0L;
    protected LongArray words;
    private final Closer closer;

    public static Bitmap64Big disk(Path location, long nbits) {
        return new Bitmap64Big(new LongArrayDisk(location, Bitmap64Big.numWords(nbits)));
    }

    public static Bitmap64Big memory(long nbits) {
        return new Bitmap64Big(new LargeLongArray(IOUtil.createLargeArray(Bitmap64Big.numWords(nbits))));
    }

    protected Bitmap64Big(LongArray words) {
        this.words = words;
        this.closer = Closer.of(new Object[0]);
        this.getCloser().with(this::closeObject, new Object[0]);
    }

    private void closeObject() throws IOException {
        Closer.closeAll(this.words);
    }

    protected static long wordIndex(long bitIndex) {
        return bitIndex >>> 6;
    }

    public static long numWords(long numbits) {
        if (numbits == 0L) {
            return 0L;
        }
        return (numbits - 1L >>> 6) + 1L;
    }

    public static long numBytes(long numbits) {
        return (numbits - 1L >>> 3) + 1L;
    }

    protected static int lastWordNumBits(long numbits) {
        if (numbits == 0L) {
            return 0;
        }
        return (int)((numbits - 1L) % 64L) + 1;
    }

    protected final void ensureSize(long wordsRequired) throws IOException {
        if (this.words.length() < wordsRequired) {
            this.words.resize(Math.max(this.words.length() * 2L, wordsRequired));
        }
    }

    public void trim(long numbits) {
        this.numbits = numbits;
    }

    public void trimToSize() {
        long wordNum = Bitmap64Big.numWords(this.numbits);
        if (wordNum != this.words.length()) {
            try {
                this.words.resize(wordNum);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean access(long bitIndex) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        long wordIndex = Bitmap64Big.wordIndex(bitIndex);
        if (wordIndex >= this.words.length()) {
            return false;
        }
        return (this.words.get(wordIndex) & 1L << (int)bitIndex) != 0L;
    }

    public long rank1(long pos) {
        throw new NotImplementedException();
    }

    public long rank0(long pos) {
        throw new NotImplementedException();
    }

    public long selectNext1(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        long wordIndex = Bitmap64Big.wordIndex(fromIndex);
        if (wordIndex >= this.words.length()) {
            return -1L;
        }
        long word = this.words.get(wordIndex) & -1L << (int)fromIndex;
        while (word == 0L) {
            if (++wordIndex == this.words.length()) {
                return -1L;
            }
            word = this.words.get(wordIndex);
        }
        return wordIndex * 64L + (long)Long.numberOfTrailingZeros(word);
    }

    public long select0(long n) {
        throw new NotImplementedException();
    }

    public long select1(long n) {
        throw new NotImplementedException();
    }

    public long countOnes() {
        if (this.words.length() == 0L) {
            return 0L;
        }
        long acc = 0L;
        long end = Bitmap64Big.wordIndex(this.numbits);
        if (end >= this.words.length()) {
            end = this.words.length() - 1L;
        }
        for (long i = 0L; i <= end; ++i) {
            acc += (long)Long.bitCount(this.words.get(i));
        }
        return acc;
    }

    public long countZeros() {
        return this.words.length() * 64L - this.countOnes();
    }

    public void append(boolean value) {
        this.set(this.numbits++, value);
    }

    public void set(long bitIndex, boolean value) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        long wordIndex = Bitmap64Big.wordIndex(bitIndex);
        try {
            this.ensureSize(wordIndex + 1L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        long wordText = this.words.get(wordIndex);
        long wordReplaced = value ? wordText | 1L << (int)bitIndex : wordText & (1L << (int)bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        if (wordText != wordReplaced) {
            this.words.set(wordIndex, wordReplaced);
        }
        this.numbits = Math.max(this.numbits, bitIndex + 1L);
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#bitmapPlain>";
    }

    public long selectPrev1(long start) {
        throw new NotImplementedException();
    }

    public long getNumBits() {
        return this.numbits;
    }

    public long getSizeBytes() {
        return Bitmap64Big.numWords(this.numbits) * 8L;
    }

    public void save(OutputStream output, ProgressListener listener) throws IOException {
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        VByte.encode(out, this.numbits);
        out.writeCRC();
        out.setCRC(new CRC32());
        long numwords = Bitmap64Big.numWords(this.numbits);
        for (long i = 0L; i < numwords - 1L; ++i) {
            IOUtil.writeLong(out, this.words.get(i));
        }
        if (numwords > 0L) {
            long lastWordUsed = Bitmap64Big.lastWordNumBits(this.numbits);
            BitUtil.writeLowerBitsByteAligned(this.words.get(numwords - 1L), lastWordUsed, out);
        }
        out.writeCRC();
    }

    public void load(InputStream input, ProgressListener listener) throws IOException {
        CRCInputStream in = new CRCInputStream(input, new CRC8());
        int type = in.read();
        if (type != 1) {
            throw new IllegalArgumentException("Trying to read BitmapPlain on a section that is not BitmapPlain");
        }
        this.numbits = VByte.decode(in);
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Bitmap64 header.");
        }
        in.setCRC(new CRC32());
        long numwords = Bitmap64Big.numWords(this.numbits);
        this.ensureSize(numwords);
        for (long i = 0L; i < numwords - 1L; ++i) {
            this.words.set(i, IOUtil.readLong(in));
        }
        if (numwords > 0L) {
            long lastWordUsedBits = Bitmap64Big.lastWordNumBits(this.numbits);
            this.words.set(numwords - 1L, BitUtil.readLowerBitsByteAligned(lastWordUsedBits, in));
        }
        if (!in.readCRCAndCheck()) {
            throw new CRCException("CRC Error while reading Bitmap64 data.");
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (long i = 0L; i < this.numbits; ++i) {
            str.append(this.access(i) ? (char)'1' : '0');
        }
        return str.toString();
    }

    public long getRealSizeBytes() {
        return this.words.length() * 8L;
    }

    public Closer getCloser() {
        return this.closer;
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }

    public ModifiableBitmap asSync() {
        return SyncBitmap.of(this);
    }
}

