/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.rdfhdt.hdt.compact.bitmap.Bitmap64Big;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.disk.LargeLongArray;
import org.rdfhdt.hdt.util.disk.LongArray;
import org.rdfhdt.hdt.util.disk.LongArrayDisk;
import org.rdfhdt.hdt.util.disk.SimpleSplitLongArray;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.Closer;
import org.rdfhdt.hdt.util.io.IOUtil;

public class Bitmap375Big
extends Bitmap64Big {
    private static final int BLOCKS_PER_SUPER = 4;
    private long pop;
    private LongArray superBlocks;
    private LongArray blocks;
    private boolean indexUpToDate;
    private final boolean useDiskSuperIndex;
    private final CloseSuppressPath superBlocksPath;
    private final CloseSuppressPath blocksPath;

    public static Bitmap375Big disk(Path location, long nbits) {
        return Bitmap375Big.disk(location, nbits, false);
    }

    public static Bitmap375Big disk(Path location, long nbits, boolean useDiskSuperIndex) {
        return new Bitmap375Big(new LongArrayDisk(location, Bitmap375Big.numWords(nbits)), location, useDiskSuperIndex);
    }

    public static Bitmap375Big memory(long nbits) {
        return Bitmap375Big.memory(nbits, null);
    }

    public static Bitmap375Big memory(long nbits, Path location) {
        return new Bitmap375Big(new LargeLongArray(IOUtil.createLargeArray(Bitmap375Big.numWords(nbits))), location, location != null);
    }

    protected Bitmap375Big(LongArray words, Path location, boolean useDiskSuperIndex) {
        super(words);
        this.useDiskSuperIndex = useDiskSuperIndex;
        if (useDiskSuperIndex) {
            CloseSuppressPath path = CloseSuppressPath.of(location);
            this.superBlocksPath = path.resolveSibling(path.getFileName() + ".sb");
            this.blocksPath = path.resolveSibling(path.getFileName() + ".bp");
        } else {
            this.superBlocksPath = null;
            this.blocksPath = null;
        }
        this.getCloser().with(this::closeObject, new Object[0]);
    }

    private void closeObject() throws IOException {
        Closer.closeAll(this.superBlocks, this.superBlocksPath, this.blocks, this.blocksPath);
    }

    public void dump() {
        long count = Bitmap375Big.numWords(this.numbits);
        for (long i = 0L; i < count; ++i) {
            System.out.print(i + "\t");
            IOUtil.printBitsln(this.words.get(i), 64);
        }
    }

    public void updateIndex() {
        this.trimToSize();
        try {
            Closer.closeAll(this.superBlocks, this.blocks, this.superBlocksPath, this.blocksPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.useDiskSuperIndex) {
            this.superBlocks = this.numbits > Integer.MAX_VALUE ? SimpleSplitLongArray.int64ArrayDisk(this.superBlocksPath, 1L + (this.words.length() - 1L) / 4L) : SimpleSplitLongArray.int32ArrayDisk(this.superBlocksPath, 1L + (this.words.length() - 1L) / 4L);
            this.blocks = SimpleSplitLongArray.int8ArrayDisk(this.blocksPath, this.words.length());
        } else {
            this.superBlocks = this.numbits > Integer.MAX_VALUE ? SimpleSplitLongArray.int64Array(1L + (this.words.length() - 1L) / 4L) : SimpleSplitLongArray.int32Array(1L + (this.words.length() - 1L) / 4L);
            this.blocks = SimpleSplitLongArray.int8Array(this.words.length());
        }
        long countBlock = 0L;
        long countSuperBlock = 0L;
        long superBlockIndex = 0L;
        for (long blockIndex = 0L; blockIndex < this.words.length(); ++blockIndex) {
            if (blockIndex % 4L == 0L) {
                this.superBlocks.set(superBlockIndex++, countSuperBlock += countBlock);
                countBlock = 0L;
            }
            this.blocks.set(blockIndex, countBlock);
            countBlock += (long)Long.bitCount(this.words.get(blockIndex));
        }
        this.pop = countSuperBlock + countBlock;
        this.indexUpToDate = true;
    }

    @Override
    public boolean access(long bitIndex) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        long wordIndex = Bitmap375Big.wordIndex(bitIndex);
        if (wordIndex >= this.words.length()) {
            return false;
        }
        return (this.words.get(wordIndex) & 1L << (int)bitIndex) != 0L;
    }

    @Override
    public void set(long bitIndex, boolean value) {
        this.indexUpToDate = false;
        super.set(bitIndex, value);
    }

    @Override
    public long rank1(long pos) {
        if (pos < 0L) {
            return 0L;
        }
        if (!this.indexUpToDate) {
            this.updateIndex();
        }
        if (pos >= this.numbits) {
            return this.pop;
        }
        long superBlockIndex = pos / 256L;
        long superBlockRank = this.superBlocks.get(superBlockIndex);
        long blockIndex = pos / 64L;
        long blockRank = 0xFFL & this.blocks.get(blockIndex);
        long chunkIndex = 63L - pos % 64L;
        long block = this.words.get(blockIndex) << (int)chunkIndex;
        long chunkRank = Long.bitCount(block);
        return superBlockRank + blockRank + chunkRank;
    }

    @Override
    public long rank0(long pos) {
        return pos + 1L - this.rank1(pos);
    }

    @Override
    public long select0(long x) {
        if (x < 0L) {
            return -1L;
        }
        if (!this.indexUpToDate) {
            this.updateIndex();
        }
        if (x > this.numbits - this.pop) {
            return this.numbits;
        }
        long superBlockIndex = Bitmap375Big.binarySearch0(this.superBlocks, 0L, this.superBlocks.length(), x);
        if (superBlockIndex < 0L) {
            superBlockIndex = -superBlockIndex - 2L;
        } else if (superBlockIndex > 0L) {
            --superBlockIndex;
        }
        while (superBlockIndex > 0L && superBlockIndex * 4L * 64L - this.superBlocks.get(superBlockIndex) >= x) {
            --superBlockIndex;
        }
        long countdown = x - (superBlockIndex * 4L * 64L - this.superBlocks.get(superBlockIndex));
        long blockIdx = superBlockIndex * 4L;
        while (true) {
            if (blockIdx >= (superBlockIndex + 1L) * 4L || blockIdx >= this.blocks.length()) {
                --blockIdx;
                break;
            }
            if ((0xFFL & 64L * (blockIdx % 4L) - (0xFFL & this.blocks.get(blockIdx))) >= countdown) {
                --blockIdx;
                break;
            }
            ++blockIdx;
        }
        if (blockIdx < 0L) {
            blockIdx = 0L;
        }
        long bitpos = BitUtil.select0(this.words.get(blockIdx), (int)(countdown -= 0xFFL & blockIdx % 4L * 64L - this.blocks.get(blockIdx)));
        return blockIdx * 64L + bitpos - 1L;
    }

    @Override
    public long select1(long x) {
        long superBlockIndex;
        if (x < 0L) {
            return -1L;
        }
        if (!this.indexUpToDate) {
            this.updateIndex();
        }
        if (x > this.pop) {
            return this.numbits;
        }
        if (this.numbits == 0L) {
            return 0L;
        }
        for (superBlockIndex = Bitmap375Big.binarySearch(this.superBlocks, x); superBlockIndex > 0L && this.superBlocks.get(superBlockIndex) >= x; --superBlockIndex) {
        }
        long countdown = x - this.superBlocks.get(superBlockIndex);
        long blockIdx = superBlockIndex * 4L;
        while (true) {
            if (blockIdx >= (superBlockIndex + 1L) * 4L || blockIdx >= this.blocks.length()) {
                --blockIdx;
                break;
            }
            if ((0xFFL & this.blocks.get(blockIdx)) >= countdown) {
                --blockIdx;
                break;
            }
            ++blockIdx;
        }
        if (blockIdx < 0L) {
            blockIdx = 0L;
        }
        int bitpos = BitUtil.select1(this.words.get(blockIdx), (int)(countdown -= 0xFFL & this.blocks.get(blockIdx)));
        return blockIdx * 64L + (long)bitpos - 1L;
    }

    @Override
    public long countOnes() {
        return this.rank1(this.numbits);
    }

    @Override
    public long countZeros() {
        return this.numbits - this.countOnes();
    }

    @Override
    public long getRealSizeBytes() {
        this.updateIndex();
        return super.getRealSizeBytes() + this.blocks.length() * (long)this.blocks.sizeOf() / 8L + this.superBlocks.length() * (long)this.superBlocks.sizeOf() / 8L;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#bitmapPlain>";
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        super.load(input, listener);
        this.updateIndex();
    }

    public static long binarySearch0(LongArray arr, long fromIndex, long toIndex, long key) {
        long low = fromIndex;
        long high = toIndex - 1L;
        while (low <= high) {
            long mid = low + high >>> 1;
            long midVal = mid * 4L * 64L - arr.get(mid);
            if (midVal < key) {
                low = mid + 1L;
                continue;
            }
            if (midVal > key) {
                high = mid - 1L;
                continue;
            }
            return mid;
        }
        return -(low + 1L);
    }

    public static long binarySearch(LongArray arr, long val) {
        long min = 0L;
        long max = arr.length();
        while (min + 1L < max) {
            long mid = (min + max) / 2L;
            if (arr.get(mid) >= val) {
                max = mid;
                continue;
            }
            min = mid;
        }
        return min;
    }

    public CloseSuppressPath getBlocksPath() {
        return this.blocksPath;
    }

    public CloseSuppressPath getSuperBlocksPath() {
        return this.superBlocksPath;
    }
}

