/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.rdfhdt.hdt.compact.bitmap.Bitmap64;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.io.IOUtil;

@Deprecated
public class Bitmap375
extends Bitmap64
implements ModifiableBitmap {
    private static final int BLOCKS_PER_SUPER = 4;
    private long pop;
    private long[] superBlocksLong;
    private int[] superBlocksInt;
    private byte[] blocks;
    private boolean indexUpToDate;

    public Bitmap375() {
    }

    public Bitmap375(long nbits) {
        super(nbits);
    }

    public Bitmap375(long nbits, InputStream in) throws IOException {
        this.numbits = nbits;
        int numwords = (int)Bitmap375.numWords(this.numbits);
        this.words = new long[numwords];
        for (int i = 0; i < numwords - 1; ++i) {
            this.words[i] = IOUtil.readLong(in);
        }
        if (numwords > 0) {
            int lastWordUsedBits = Bitmap375.lastWordNumBits(this.numbits);
            this.words[numwords - 1] = BitUtil.readLowerBitsByteAligned(lastWordUsedBits, in);
        }
    }

    private static int binarySearch0(long[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = (long)(mid * 4 * 64) - a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static int binarySearch0(int[] a, int fromIndex, int toIndex, long key) {
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = mid * 4 * 64 - a[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void dump() {
        int count = (int)Bitmap375.numWords(this.numbits);
        for (int i = 0; i < count; ++i) {
            System.out.print(i + "\t");
            IOUtil.printBitsln(this.words[i], 64);
        }
    }

    public void updateIndex() {
        this.trimToSize();
        if (this.numbits > Integer.MAX_VALUE) {
            this.superBlocksLong = new long[1 + (this.words.length - 1) / 4];
        } else {
            this.superBlocksInt = new int[1 + (this.words.length - 1) / 4];
        }
        this.blocks = new byte[this.words.length];
        long countBlock = 0L;
        long countSuperBlock = 0L;
        int superBlockIndex = 0;
        for (int blockIndex = 0; blockIndex < this.words.length; ++blockIndex) {
            if (blockIndex % 4 == 0) {
                countSuperBlock += countBlock;
                if (this.superBlocksLong != null) {
                    if (superBlockIndex < this.superBlocksLong.length) {
                        this.superBlocksLong[superBlockIndex++] = countSuperBlock;
                    }
                } else if (superBlockIndex < this.superBlocksInt.length) {
                    this.superBlocksInt[superBlockIndex++] = (int)countSuperBlock;
                }
                countBlock = 0L;
            }
            this.blocks[blockIndex] = (byte)countBlock;
            countBlock += (long)Long.bitCount(this.words[blockIndex]);
        }
        this.pop = countSuperBlock + countBlock;
        this.indexUpToDate = true;
    }

    @Override
    public boolean access(long bitIndex) {
        if (bitIndex < 0L) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = Bitmap375.wordIndex(bitIndex);
        if (wordIndex >= this.words.length) {
            return false;
        }
        return (this.words[wordIndex] & 1L << (int)bitIndex) != 0L;
    }

    @Override
    public void set(long bitIndex, boolean value) {
        this.indexUpToDate = false;
        super.set(bitIndex, value);
    }

    @Override
    public long rank1(long pos) {
        if (pos < 0L) {
            return 0L;
        }
        if (!this.indexUpToDate) {
            this.updateIndex();
        }
        if (pos >= this.numbits) {
            return this.pop;
        }
        long superBlockIndex = pos / 256L;
        long superBlockRank = this.superBlocksLong != null ? this.superBlocksLong[(int)superBlockIndex] : (long)this.superBlocksInt[(int)superBlockIndex];
        long blockIndex = pos / 64L;
        long blockRank = 0xFF & this.blocks[(int)blockIndex];
        long chunkIndex = 63L - pos % 64L;
        long block = this.words[(int)blockIndex] << (int)chunkIndex;
        long chunkRank = Long.bitCount(block);
        return superBlockRank + blockRank + chunkRank;
    }

    @Override
    public long rank0(long pos) {
        return pos + 1L - this.rank1(pos);
    }

    @Override
    public long select0(long x) {
        long countdown;
        if (x < 0L) {
            return -1L;
        }
        if (!this.indexUpToDate) {
            this.updateIndex();
        }
        if (x > this.numbits - this.pop) {
            return this.numbits;
        }
        int superBlockIndex = this.superBlocksLong != null ? Bitmap375.binarySearch0(this.superBlocksLong, 0, this.superBlocksLong.length, x) : Bitmap375.binarySearch0(this.superBlocksInt, 0, this.superBlocksInt.length, x);
        if (superBlockIndex < 0) {
            superBlockIndex = -superBlockIndex - 2;
        } else if (superBlockIndex > 0) {
            --superBlockIndex;
        }
        if (this.superBlocksLong != null) {
            while (superBlockIndex > 0 && (long)(superBlockIndex * 4 * 64) - this.superBlocksLong[superBlockIndex] >= x) {
                --superBlockIndex;
            }
            countdown = x - ((long)(superBlockIndex * 4 * 64) - this.superBlocksLong[superBlockIndex]);
        } else {
            while (superBlockIndex > 0 && (long)(superBlockIndex * 4 * 64 - this.superBlocksInt[superBlockIndex]) >= x) {
                --superBlockIndex;
            }
            countdown = x - (long)(superBlockIndex * 4 * 64 - this.superBlocksInt[superBlockIndex]);
        }
        int blockIdx = superBlockIndex * 4;
        while (true) {
            if (blockIdx >= (superBlockIndex + 1) * 4 || blockIdx >= this.blocks.length) {
                --blockIdx;
                break;
            }
            if ((long)(0xFF & 64 * (blockIdx % 4) - this.blocks[blockIdx]) >= countdown) {
                --blockIdx;
                break;
            }
            ++blockIdx;
        }
        if (blockIdx < 0) {
            blockIdx = 0;
        }
        int bitpos = BitUtil.select0(this.words[blockIdx], (int)(countdown -= (long)(0xFF & blockIdx % 4 * 64 - this.blocks[blockIdx])));
        return (long)blockIdx * 64L + (long)bitpos - 1L;
    }

    @Override
    public long select1(long x) {
        long countdown;
        int superBlockIndex;
        if (x < 0L) {
            return -1L;
        }
        if (!this.indexUpToDate) {
            this.updateIndex();
        }
        if (x > this.pop) {
            return this.numbits;
        }
        if (this.numbits == 0L) {
            return 0L;
        }
        if (this.superBlocksLong != null) {
            for (superBlockIndex = this.superBlocksLong != null ? this.binarySearch(this.superBlocksLong, x, this.superBlocksLong.length) : this.binarySearch(this.superBlocksInt, (long)((int)x), this.superBlocksInt.length); superBlockIndex > 0 && this.superBlocksLong[superBlockIndex] >= x; --superBlockIndex) {
            }
            countdown = x - this.superBlocksLong[superBlockIndex];
        } else {
            int mycount = 0;
            while (superBlockIndex > 0 && (long)this.superBlocksInt[superBlockIndex] >= x) {
                --superBlockIndex;
                ++mycount;
            }
            countdown = x - (long)this.superBlocksInt[superBlockIndex];
        }
        int blockIdx = superBlockIndex * 4;
        while (true) {
            if (blockIdx >= (superBlockIndex + 1) * 4 || blockIdx >= this.blocks.length) {
                --blockIdx;
                break;
            }
            if ((long)(0xFF & this.blocks[blockIdx]) >= countdown) {
                --blockIdx;
                break;
            }
            ++blockIdx;
        }
        if (blockIdx < 0) {
            blockIdx = 0;
        }
        int bitpos = BitUtil.select1(this.words[blockIdx], (int)(countdown -= (long)(0xFF & this.blocks[blockIdx])));
        return (long)blockIdx * 64L + (long)bitpos - 1L;
    }

    @Override
    public long countOnes() {
        return this.rank1(this.numbits);
    }

    @Override
    public long countZeros() {
        return this.numbits - this.countOnes();
    }

    @Override
    public long getRealSizeBytes() {
        this.updateIndex();
        long accum = super.getRealSizeBytes();
        if (this.superBlocksLong != null) {
            accum += (long)(this.superBlocksLong.length * 8);
        }
        if (this.superBlocksInt != null) {
            accum += (long)(this.superBlocksInt.length * 4);
        }
        return accum += (long)this.blocks.length;
    }

    @Override
    public String getType() {
        return "<http://purl.org/HDT/hdt#bitmapPlain>";
    }

    @Override
    public void save(OutputStream output, ProgressListener listener) throws IOException {
        super.save(output, listener);
    }

    @Override
    public void load(InputStream input, ProgressListener listener) throws IOException {
        super.load(input, listener);
        this.updateIndex();
    }

    public int binarySearch(int[] arr, long x, int n) {
        int i = 0;
        int j = n;
        while (i + 1 < j) {
            int m = (i + j) / 2;
            if ((long)arr[m] >= x) {
                j = m;
                continue;
            }
            i = m;
        }
        return i;
    }

    public int binarySearch(long[] arr, long x, int n) {
        int i = 0;
        int j = n;
        while (i + 1 < j) {
            int m = (i + j) / 2;
            if (arr[m] >= x) {
                j = m;
                continue;
            }
            i = m;
        }
        return i;
    }
}

