/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.rdfhdt.hdt.compact.bitmap.ModifiableBitmap;
import org.rdfhdt.hdt.compact.integer.VByte;
import org.rdfhdt.hdt.exceptions.NotImplementedException;
import org.rdfhdt.hdt.listener.ProgressListener;
import org.rdfhdt.hdt.util.BitUtil;
import org.rdfhdt.hdt.util.crc.CRC32;
import org.rdfhdt.hdt.util.crc.CRC8;
import org.rdfhdt.hdt.util.crc.CRCOutputStream;
import org.rdfhdt.hdt.util.io.CloseSuppressPath;
import org.rdfhdt.hdt.util.io.IOUtil;

public class AppendableWriteBitmap
implements ModifiableBitmap,
Closeable {
    private long countZeros;
    private long countOnes;
    private long numbits;
    private final CloseSuppressPath file;
    private final CRCOutputStream stream;
    private long currentElement;
    private int bit;
    private boolean saved;

    public AppendableWriteBitmap(CloseSuppressPath storage, int bufferSize) throws IOException {
        this.file = storage;
        this.stream = new CRCOutputStream(storage.openOutputStream(bufferSize, new OpenOption[0]), new CRC32());
    }

    public void set(long position, boolean value) {
        throw new NotImplementedException();
    }

    public void append(boolean value) {
        if (value) {
            ++this.countOnes;
        } else {
            ++this.countZeros;
        }
        ++this.numbits;
        if (value) {
            this.currentElement |= 1L << this.bit;
        }
        ++this.bit;
        try {
            this.pushByte(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void pushByte(boolean force) throws IOException {
        if (this.bit == 64 || force) {
            BitUtil.writeLowerBitsByteAligned(this.currentElement, this.bit, this.stream);
            this.bit = 0;
            this.currentElement = 0L;
        }
    }

    public boolean access(long position) {
        throw new NotImplementedException();
    }

    public long rank1(long position) {
        throw new NotImplementedException();
    }

    public long rank0(long position) {
        throw new NotImplementedException();
    }

    public long selectPrev1(long start) {
        throw new NotImplementedException();
    }

    public long selectNext1(long start) {
        throw new NotImplementedException();
    }

    public long select0(long n) {
        throw new NotImplementedException();
    }

    public long select1(long n) {
        throw new NotImplementedException();
    }

    public long getNumBits() {
        return this.numbits;
    }

    public long countOnes() {
        return this.countOnes;
    }

    public long countZeros() {
        return this.countZeros;
    }

    public long getSizeBytes() {
        return (this.numbits - 1L) / 8L + 1L;
    }

    public void save(OutputStream output, ProgressListener listener) throws IOException {
        this.saved = true;
        this.pushByte(true);
        this.stream.writeCRC();
        this.stream.close();
        CRCOutputStream out = new CRCOutputStream(output, new CRC8());
        out.write(1);
        VByte.encode(out, this.numbits);
        out.writeCRC();
        Files.copy(this.file, output);
        this.file.close();
    }

    public void load(InputStream input, ProgressListener listener) throws IOException {
        throw new NotImplementedException();
    }

    public String getType() {
        return "<http://purl.org/HDT/hdt#bitmapPlain>";
    }

    @Override
    public void close() throws IOException {
        if (!this.saved) {
            IOUtil.closeAll(this.stream, this.file);
        }
    }
}

