/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.compact.bitmap;

import org.rdfhdt.hdt.compact.bitmap.Bitmap;
import org.rdfhdt.hdt.compact.sequence.Sequence;
import org.rdfhdt.hdt.exceptions.NotFoundException;

public class AdjacencyList {
    private final Sequence array;
    private final Bitmap bitmap;

    public AdjacencyList(Sequence array, Bitmap bitmap) {
        this.array = array;
        this.bitmap = bitmap;
        if (array.getNumberOfElements() != bitmap.getNumBits()) {
            throw new IllegalArgumentException("Adjacency list bitmap and array should have the same size " + array.getNumberOfElements() + "!=" + bitmap.getNumBits());
        }
    }

    public final long find(long x) {
        return x <= 0L ? 0L : this.bitmap.select1(x) + 1L;
    }

    public final long findNext(long pos) {
        return this.bitmap.selectNext1(pos);
    }

    public final long last(long x) {
        return this.bitmap.select1(x + 1L);
    }

    public final long find(long x, long y) {
        long begin = this.find(x);
        long end = this.last(x);
        return this.binSearch(y, begin, end);
    }

    public final long findListIndex(long globalpos) {
        return this.bitmap.rank1(globalpos - 1L);
    }

    public final long countListsX() {
        return this.bitmap.countOnes();
    }

    public long countItemsY(long x) {
        return this.last(x) - this.find(x) + 1L;
    }

    public long search(long element, long begin, long end) throws NotFoundException {
        if (end - begin > 10L) {
            return this.binSearch(element, begin, end);
        }
        return this.linSearch(element, begin, end);
    }

    public long binSearch(long element, long begin, long end) {
        while (begin <= end) {
            long mid = (begin + end) / 2L;
            long read = this.array.get(mid);
            if (element > read) {
                begin = mid + 1L;
                continue;
            }
            if (element < read) {
                end = mid - 1L;
                continue;
            }
            return mid;
        }
        return -1L;
    }

    public long linSearch(long element, long begin, long end) throws NotFoundException {
        while (begin <= end) {
            long read = this.array.get(begin);
            if (read == element) {
                return begin;
            }
            ++begin;
        }
        throw new NotFoundException();
    }

    public final long get(long pos) {
        return this.array.get(pos);
    }

    public final long getNumberOfElements() {
        return this.array.getNumberOfElements();
    }

    public long findNextAppearance(long oldpos, long element) {
        for (long pos = oldpos; pos < this.array.getNumberOfElements(); ++pos) {
            long y = this.array.get(pos);
            if (y != element) continue;
            return pos;
        }
        return -1L;
    }

    public long findPreviousAppearance(long old, long element) {
        long y;
        do {
            y = this.array.get(old--);
        } while (old >= 0L && y != element);
        if (old < 0L) {
            return -1L;
        }
        return old + 1L;
    }

    public void dump() {
        long i;
        for (i = 0L; i < this.getNumberOfElements(); ++i) {
            System.out.print(" " + this.get(i));
            if (i == this.getNumberOfElements()) continue;
            System.out.println(",");
        }
        System.out.println();
        for (i = 0L; i < this.countListsX() && i < 100L; ++i) {
            System.out.print("List " + i + " [");
            long base = this.find(i);
            long items = this.countItemsY(i);
            for (long j = 0L; j < this.countItemsY(i) && j < 100L; ++j) {
                System.out.print(this.get(base + j));
                if (j == items - 1L) continue;
                System.out.print(',');
            }
            System.out.println("] ");
        }
        System.out.println();
    }
}

