/*
 * Decompiled with CFR 0.152.
 */
package org.rdfhdt.hdt.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.rdfhdt.hdt.cache.DictionaryCache;

public class DictionaryCacheLRI<T>
implements DictionaryCache<T> {
    private final Map<Long, T> cache;
    private final long[] arr;
    private int ptr = 0;
    private final int size;

    public DictionaryCacheLRI(int size) {
        this.size = size;
        this.arr = new long[size];
        this.cache = new ConcurrentHashMap<Long, T>(size);
    }

    @Override
    public T get(long id) {
        return this.cache.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(long id, T node) {
        this.cache.put(id, node);
        if (this.cache.size() > this.size) {
            this.cache.remove(this.arr[this.ptr]);
        }
        DictionaryCacheLRI dictionaryCacheLRI = this;
        synchronized (dictionaryCacheLRI) {
            this.arr[this.ptr] = id;
            this.ptr = (this.ptr + 1) % this.size;
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

