/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import com.google.common.collect.Range;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.yagi.framework.grammar.rule.AbstractTypeRule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class IntegerTypeRule
extends AbstractTypeRule {
    private final boolean castStringsAsNumbers;
    @Nullable
    private Range<Long> range;

    public IntegerTypeRule(@Nullable Range<Long> range) {
        this.range = range;
        this.castStringsAsNumbers = false;
    }

    public IntegerTypeRule() {
        this(null);
    }

    public IntegerTypeRule(boolean castStringsAsNumbers) {
        this.castStringsAsNumbers = castStringsAsNumbers;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof StringNode && this.castStringsAsNumbers) {
            String intString = ((StringNode)node).getValue();
            try {
                long longValue = Long.parseLong(intString);
                return this.isInRange(longValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (node instanceof IntegerNode) {
            return this.isInRange(((IntegerNode)node).getValue());
        }
        if (node instanceof FloatingNode) {
            try {
                long value = ((FloatingNode)node).getValue().longValue();
                if (((FloatingNode)node).getValue().compareTo(new BigDecimal(value)) != 0) {
                    return false;
                }
                return this.isInRange(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isInRange(Long value) {
        return this.range == null || this.range.contains((Comparable)value);
    }

    @Override
    public String getDescription() {
        return "Integer";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Integer;
    }
}

