/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoaderExtended;
import org.raml.v2.api.loader.ResourceUriCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootRamlFileResourceLoader
implements ResourceLoaderExtended {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private File parentPath;
    private URI callbackParam;

    public RootRamlFileResourceLoader(File path) {
        this.parentPath = path;
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName, ResourceUriCallback callback) {
        File includedFile = new File(this.parentPath, resourceName.startsWith("/") ? resourceName.substring(1) : resourceName);
        this.logger.debug("Looking for resource: {} on directory: {}...", (Object)resourceName, (Object)this.parentPath);
        try {
            if (callback != null) {
                this.callbackParam = includedFile.toURI();
                callback.onResourceFound(this.callbackParam);
            }
            return new FileInputStream(includedFile);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public InputStream fetchResource(String resourceName) {
        return this.fetchResource(resourceName, null);
    }

    @Override
    public URI getUriCallBackParam() {
        return this.callbackParam;
    }
}

