/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.model.NodeModelFactory;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;

public class ClassNodeModelFactory
implements NodeModelFactory {
    private Class<? extends NodeModel> aClass;

    public ClassNodeModelFactory(Class<? extends NodeModel> aClass) {
        this.aClass = aClass;
    }

    @Override
    public NodeModel create(Node node) {
        Constructor<?> nodeConstructor = ClassNodeModelFactory.findNodeConstructor(this.aClass);
        try {
            if (KeyValueNode.class.isAssignableFrom(nodeConstructor.getParameterTypes()[0])) {
                if (node instanceof KeyValueNode) {
                    return (NodeModel)nodeConstructor.newInstance(node);
                }
                return (NodeModel)nodeConstructor.newInstance(node.findAncestorWith(KeyValueNode.class));
            }
            return (NodeModel)nodeConstructor.newInstance(node);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean polymorphic() {
        return false;
    }

    private static Constructor<?> findNodeConstructor(Class<?> aClass) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = aClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 1 || !Node.class.isAssignableFrom(constructor.getParameterTypes()[0])) continue;
            return constructor;
        }
        throw new RuntimeException("No constructor with a single Node type was found for " + aClass.getName());
    }
}

