/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.yagi.framework.nodes.ArrayNode;
import org.raml.yagi.framework.nodes.BaseNode;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.Position;

public class ArrayWrapperNode
extends BaseNode
implements ArrayNode {
    private Node wrapped;

    public ArrayWrapperNode(Node child) {
        this.wrapped = child;
        this.wrapped.setParent(this);
    }

    @Override
    public boolean isJsonStyle() {
        return false;
    }

    @Override
    public void addChild(Node node) {
        this.wrapped.addChild(node);
    }

    @Override
    public void setChild(int idx, Node newNode) {
        if (newNode instanceof ErrorNode) {
            this.wrapped = newNode;
        } else {
            this.wrapped.setChild(idx, newNode);
        }
    }

    @Override
    public void addChild(int idx, Node newNode) {
        this.wrapped.addChild(idx, newNode);
    }

    @Override
    public void removeChild(Node node) {
        this.wrapped.removeChild(node);
    }

    @Override
    @Nonnull
    public List<Node> getChildren() {
        return Collections.singletonList(this.wrapped);
    }

    @Override
    @Nonnull
    public Position getStartPosition() {
        return DefaultPosition.emptyPosition();
    }

    @Override
    @Nonnull
    public Position getEndPosition() {
        return DefaultPosition.emptyPosition();
    }

    @Override
    @Nonnull
    public Node copy() {
        return new ArrayWrapperNode(this.wrapped);
    }

    @Override
    public NodeType getType() {
        return NodeType.Array;
    }
}

