/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import org.raml.yagi.framework.nodes.snakeyaml.LimitsException;
import org.yaml.snakeyaml.nodes.Node;

public class RamlParsingLimitsController {
    private static final boolean shouldVerify = Boolean.parseBoolean(System.getProperty("raml.verifyRaml", "true"));
    private static final boolean cycleCheck = Boolean.parseBoolean(System.getProperty("raml.verifyReferenceCycle", "true"));
    private static final int maxRamlDepth = Integer.parseInt(System.getProperty("raml.maxDepth", "2000"));
    private static final int maxRamlReferences = Integer.parseInt(System.getProperty("raml.maxReferences", "10000"));
    private IdentityHashMap<Node, Integer> seenNodes = new IdentityHashMap();
    private Set<Node> currentlyHandling = new HashSet<Node>();
    private final boolean verify;
    private final int maxDepth;
    private final int maxReferences;
    private final boolean verifyCycle;

    public RamlParsingLimitsController(boolean verify, int maxDepth, int maxRamlReferences, boolean verifyCycle) {
        this.verify = verify;
        this.maxDepth = maxDepth;
        this.maxReferences = maxRamlReferences;
        this.verifyCycle = verifyCycle;
    }

    public RamlParsingLimitsController() {
        this.verify = shouldVerify;
        this.maxDepth = maxRamlDepth;
        this.maxReferences = maxRamlReferences;
        this.verifyCycle = cycleCheck;
    }

    public void verifyNode(Node node, int depth) {
        try {
            if (!this.verify) {
                return;
            }
            if (this.verifyCycle && this.currentlyHandling.contains(node)) {
                throw new LimitsException("cycle detected", node.getStartMark());
            }
            this.currentlyHandling.add(node);
            if (depth > this.maxDepth) {
                throw new LimitsException("maximum depth exceeded: " + this.maxDepth, node.getStartMark());
            }
            if (this.seenNodes.containsKey(node)) {
                this.seenNodes.put(node, this.seenNodes.get(node) + 1);
            } else {
                this.seenNodes.put(node, 1);
            }
            if (this.seenNodes.get(node) > this.maxReferences) {
                throw new LimitsException("reference count exceeded: " + this.maxReferences, node.getStartMark());
            }
        }
        finally {
            this.currentlyHandling.remove(node);
        }
    }
}

